/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.external.radiobrowser.RadioBrowser4j;
import net.pms.network.HTTPResource;
import net.pms.network.HTTPResourceAuthenticator;
import net.pms.renderers.Renderer;
import net.pms.store.MediaInfoStore;
import net.pms.store.StoreItem;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebStream
extends StoreItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebStream.class);
    private String url;
    private String fluxName;
    private String thumbURL;
    private final Map<String, String> directives;

    public WebStream(Renderer renderer, String fluxName, String url, String thumbURL, int type, Map<String, String> directives) {
        super(renderer, type);
        URL tmpUrl;
        if (url != null) {
            try {
                tmpUrl = URI.create(url).toURL();
                tmpUrl = HTTPResourceAuthenticator.concatenateUserInfo(tmpUrl);
                this.url = tmpUrl.toString();
            }
            catch (IllegalArgumentException | MalformedURLException e) {
                this.url = url;
            }
        }
        if (thumbURL != null) {
            try {
                tmpUrl = URI.create(thumbURL).toURL();
                tmpUrl = HTTPResourceAuthenticator.concatenateUserInfo(tmpUrl);
                this.thumbURL = tmpUrl.toString();
            }
            catch (IllegalArgumentException | MalformedURLException e) {
                this.thumbURL = thumbURL;
            }
        }
        this.fluxName = fluxName;
        this.directives = directives;
    }

    @Override
    public String write() {
        return this.fluxName + ">" + this.url + ">" + this.thumbURL + ">" + this.getSpecificType();
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        DLNAThumbnailInputStream result = null;
        if (this.getMediaInfo() != null && this.getMediaInfo().getThumbnail() != null) {
            result = this.getMediaInfo().getThumbnailInputStream();
        }
        if (result == null && this.thumbURL != null) {
            result = DLNAThumbnailInputStream.toThumbnailInputStream(FileUtil.isUrl(this.thumbURL) ? HTTPResource.downloadAndSend(this.thumbURL, true) : new FileInputStream(this.thumbURL));
        }
        return result != null ? result : super.getThumbnailInputStream();
    }

    @Override
    public InputStream getInputStream() {
        try {
            InputStream input = new URL(this.url).openStream();
            return input;
        }
        catch (IOException e) {
            LOGGER.error("cannot read input stream from {}", (Object)this.url, (Object)e);
            return null;
        }
    }

    @Override
    public boolean isValid() {
        this.resolveFormat();
        return this.getFormat() != null;
    }

    @Override
    public long length() {
        return 0x7FFFFFFF7FFFFFFFL;
    }

    @Override
    public String getName() {
        return this.getFluxName();
    }

    @Override
    public String getSystemName() {
        return this.getUrl();
    }

    public String getUrl() {
        return this.url;
    }

    protected void setUrl(String url) {
        this.url = url;
    }

    protected String getFluxName() {
        return this.fluxName;
    }

    protected void setFluxName(String fluxName) {
        this.fluxName = fluxName;
    }

    protected String getThumbURL() {
        return this.thumbURL;
    }

    protected void setThumbURL(String thumbURL) {
        this.thumbURL = thumbURL;
    }

    @Override
    public boolean isSubSelectable() {
        return true;
    }

    @Override
    public synchronized void resolve() {
        if (this.url == null) {
            LOGGER.error("WebStream points to a null url.");
            return;
        }
        if (this.getMediaInfo() == null || !this.getMediaInfo().isMediaParsed()) {
            this.setMediaInfo(MediaInfoStore.getWebStreamMediaInfo(this.url, this.getSpecificType()));
        }
        if (this.directives != null && this.directives.containsKey("#RADIOBROWSERUUID:")) {
            RadioBrowser4j.backgroundLookupAndAddMetadata(this.url, this.directives.get("#RADIOBROWSERUUID:"), this.mediaInfo);
        }
        if (this.directives != null && this.directives.containsKey("#EXTIMG:")) {
            ThumbnailStore.updateThumbnailByURI(this.directives.get("#EXTIMG:"), this.getFileName(), ThumbnailSource.PLAYLIST);
        }
    }
}

