/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.item.ZippedEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZippedFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZippedFolder.class);
    private final String entryName;
    protected final File file;

    public ZippedFolder(Renderer renderer, File file, String entryName) {
        super(renderer, null, null);
        this.file = file;
        if (entryName == null || "".equals(entryName)) {
            this.entryName = "";
        } else {
            this.entryName = entryName;
            this.name = entryName;
            if (this.name.endsWith("/")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
            if (this.name.contains("/")) {
                this.name = this.name.substring(this.name.lastIndexOf("/"));
            }
        }
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath() + "#" + this.entryName;
    }

    @Override
    public boolean isValid() {
        return this.file.exists();
    }

    @Override
    public void discoverChildren() {
        this.getChildren().clear();
        try (ZipFile zip = new ZipFile(this.file);){
            Enumeration<? extends ZipEntry> enm = zip.entries();
            while (enm.hasMoreElements()) {
                ZipEntry entry = enm.nextElement();
                if (entry.getName().equals(this.entryName)) {
                    this.setLastModified(entry.getTime());
                    continue;
                }
                if (!this.isDirectChild(entry)) continue;
                if (entry.isDirectory()) {
                    this.addChild(new ZippedFolder(this.renderer, this.file, entry.getName()));
                    continue;
                }
                ZippedEntry child = new ZippedEntry(this.renderer, this.file, entry.getName(), entry.getSize());
                if (!child.isValid()) continue;
                this.addChild(child);
            }
        }
        catch (ZipException e) {
            LOGGER.error("Error reading zip file", e);
        }
        catch (IOException e) {
            LOGGER.error("Error reading zip file", e);
        }
    }

    private boolean isDirectChild(ZipEntry entry) {
        if (entry.getName().startsWith(this.entryName)) {
            String childName = entry.getName().substring(this.entryName.length());
            if (entry.isDirectory()) {
                childName = childName.substring(0, childName.length() - 1);
            }
            return !childName.contains("/");
        }
        return false;
    }
}

