/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.item.FeedItem;
import net.pms.store.item.RealFile;
import net.pms.store.item.WebAudioStream;
import net.pms.store.item.WebVideoStream;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnattachedFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UnattachedFolder.class);
    private static final List<String> IDS = new ArrayList<String>();

    public UnattachedFolder(Renderer renderer, String name) {
        super(renderer, name, null);
        this.setId(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getIdOf(String uri) {
        List<String> list = IDS;
        synchronized (list) {
            if (!IDS.contains(uri)) {
                IDS.add(uri);
            }
            return IDS.indexOf(uri);
        }
    }

    public StoreResource add(String uri, String name) {
        StoreResource d = this.autoMatch(uri, name);
        if (d != null) {
            d.setId(this.getId() + this.getIdOf(uri));
            this.addChild(d);
            d.syncResolve();
        }
        return d;
    }

    public int getIndex(String objectId) {
        int index = this.indexOf(objectId);
        if (index == -1) {
            index = this.indexOf(this.recreate(objectId, null).getResourceId());
        }
        return index;
    }

    public StoreResource get(String objectId) {
        int index = this.getIndex(objectId);
        return index > -1 ? this.getChildren().get(index) : null;
    }

    public List<StoreResource> asList(String objectId) {
        int index = this.getIndex(objectId);
        return index > -1 ? this.getChildren().subList(index, index + 1) : null;
    }

    public StoreResource recreate(String objectId, String name) {
        try {
            return this.add(StringUtils.substringAfter(objectId, "/"), name);
        }
        catch (Exception e) {
            return null;
        }
    }

    private StoreResource autoMatch(String uri, String name) {
        StoreItem resource;
        int type;
        try {
            uri = URLDecoder.decode(uri, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            LOGGER.error("URL decoding error ", e);
        }
        boolean isweb = uri.matches("\\S+://.+");
        Format format = FormatFactory.getAssociatedFormat((String)(isweb ? "." + FileUtil.getUrlExtension(uri) : uri));
        int n = type = format == null ? 4 : format.getType();
        if (name == null) {
            name = new File(StringUtils.substringBefore(uri, "?")).getName();
        }
        if (isweb) {
            resource = switch (type) {
                case 4 -> new WebVideoStream(this.renderer, name, uri, null);
                case 1 -> new WebAudioStream(this.renderer, name, uri, null);
                case 2 -> new FeedItem(this.renderer, name, uri, null, null, 2);
                default -> null;
            };
        } else {
            resource = new RealFile(this.renderer, new File(uri));
        }
        if (resource != null && format == null && !isweb) {
            resource.setFormat(FormatFactory.getAssociatedFormat(".mpg"));
        }
        LOGGER.debug(resource == null ? "Could not auto-match " + uri : "Created auto-matched container: " + String.valueOf(resource));
        return resource;
    }
}

