/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.util.List;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.item.VirtualVideoAction;
import net.pms.store.item.VirtualVideoActionLocalized;
import net.pms.store.utils.IOList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsPlaylist
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmsPlaylist.class);
    protected IOList list;
    protected int maxSize;

    public UmsPlaylist(Renderer renderer, String name) {
        this(renderer, name, null, 0, 2);
    }

    public UmsPlaylist(Renderer renderer, String name, String filename) {
        this(renderer, name, filename, 0, 2);
    }

    public UmsPlaylist(Renderer renderer, String name, String filename, int maxSize, int mode) {
        super(renderer, name, "images/store/folder.png");
        this.maxSize = maxSize > 0 ? maxSize : 0;
        this.list = new IOList(renderer, filename, mode);
        this.list.save();
    }

    public File getFile() {
        return this.list.getFile();
    }

    public void add(StoreResource resource) {
        StoreResource res1;
        LOGGER.debug("Adding \"{}\" to playlist \"{}\"", (Object)resource.getDisplayName(), (Object)this.getName());
        if (resource instanceof VirtualVideoAction) {
            return;
        }
        if (resource.getParent() == this) {
            res1 = resource;
            for (StoreResource r : this.list) {
                if (!r.getName().equals(resource.getName()) || !r.getSystemName().equals(resource.getSystemName())) continue;
                res1 = r;
                break;
            }
        } else {
            res1 = resource.clone();
            if (resource instanceof StoreItem) {
                StoreItem item = (StoreItem)resource;
                ((StoreItem)res1).setResume(item.getResume());
            }
        }
        this.list.remove(res1);
        if (this.maxSize > 0 && this.list.size() == this.maxSize) {
            this.list.remove(this.maxSize - 1);
        }
        this.list.add(0, res1);
        this.update();
    }

    public void remove(StoreResource res) {
        LOGGER.debug("Removing \"{}\" from playlist \"{}\"", (Object)res.getName(), (Object)this.getName());
        this.list.remove(res);
        this.update();
    }

    public void clear() {
        LOGGER.debug("Clearing playlist \"{}\": {} items", (Object)this.getName(), (Object)this.list.size());
        this.list.clear();
        this.update();
    }

    public boolean isMode(int m) {
        return this.list.isMode(m);
    }

    @Override
    public void discoverChildren() {
        if (!this.list.isEmpty()) {
            final UmsPlaylist self = this;
            if (!this.isMode(2)) {
                this.addChild(new VirtualVideoActionLocalized(this.renderer, "Save", true, null){

                    @Override
                    public boolean enable() {
                        self.save();
                        return true;
                    }
                });
            }
            this.addChild(new VirtualVideoActionLocalized(this.renderer, "Clear", true, null){

                @Override
                public boolean enable() {
                    self.clear();
                    return true;
                }
            });
        }
        for (StoreResource r : this.list) {
            StoreItem item;
            this.addChild(r);
            if (!(r instanceof StoreItem) || !(item = (StoreItem)r).isResume()) continue;
            StoreItem clone = item.clone();
            clone.setResume(null);
            this.addChild(clone);
        }
    }

    public List<StoreResource> getList() {
        return this.list;
    }

    public void update() {
        if (this.isMode(2)) {
            this.save();
        }
        this.getChildren().clear();
        this.setDiscovered(false);
        if (this.list.size() < 1 && !this.isMode(1)) {
            this.getParent().getChildren().remove(this);
        }
    }

    public void save() {
        this.list.save();
    }
}

