/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.item.SevenZipEntry;
import net.sf.sevenzipjbinding.IInArchive;
import net.sf.sevenzipjbinding.SevenZip;
import net.sf.sevenzipjbinding.SevenZipException;
import net.sf.sevenzipjbinding.impl.RandomAccessFileInStream;
import net.sf.sevenzipjbinding.simple.ISimpleInArchive;
import net.sf.sevenzipjbinding.simple.ISimpleInArchiveItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SevenZipFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SevenZipFolder.class);
    protected final File file;
    private final String entryName;

    public SevenZipFolder(Renderer renderer, File file, String entryName) {
        super(renderer, null, null);
        this.file = file;
        if (entryName == null || "".equals(entryName)) {
            this.entryName = "";
        } else {
            this.entryName = entryName;
            this.name = entryName;
            if (this.name.endsWith("/")) {
                this.name = this.name.substring(0, this.name.length() - 1);
            }
            if (this.name.contains("/")) {
                this.name = this.name.substring(this.name.lastIndexOf("/"));
            }
        }
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath() + "#" + this.entryName;
    }

    @Override
    public boolean isValid() {
        return this.file.exists();
    }

    @Override
    public void discoverChildren() {
        this.getChildren().clear();
        try (RandomAccessFile rf = new RandomAccessFile(this.file, "r");
             IInArchive arc = SevenZip.openInArchive(null, new RandomAccessFileInStream(rf));){
            ISimpleInArchive simpleInArchive = arc.getSimpleInterface();
            for (ISimpleInArchiveItem item : simpleInArchive.getArchiveItems()) {
                if (item.getPath().equals(this.entryName) && item.getCreationTime() != null) {
                    this.setLastModified(item.getCreationTime().getTime());
                    continue;
                }
                if (!this.isDirectChild(item)) continue;
                if (item.isFolder()) {
                    this.addChild(new SevenZipFolder(this.renderer, this.file, item.getPath()));
                    continue;
                }
                SevenZipEntry child = new SevenZipEntry(this.renderer, this.file, item.getPath(), item.getSize());
                if (!child.isValid()) continue;
                this.addChild(child);
            }
        }
        catch (IOException e) {
            LOGGER.error("Error reading archive file", e);
        }
    }

    private boolean isDirectChild(ISimpleInArchiveItem item) throws SevenZipException {
        if (item.getPath().startsWith(this.entryName)) {
            String childName = item.getPath().substring(this.entryName.length() + 1);
            return !childName.contains("/") && !childName.contains("\\");
        }
        return false;
    }
}

