/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.IOException;
import net.pms.database.MediaTableCoverArtArchive;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdMediaType;
import net.pms.store.DbIdTypeAndIdent;
import net.pms.store.container.VirtualFolderDbId;
import net.pms.store.container.VirtualFolderDbIdNamed;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MusicBrainzPersonFolder
extends VirtualFolderDbIdNamed {
    private static final Logger LOGGER = LoggerFactory.getLogger(MusicBrainzPersonFolder.class);
    private VirtualFolderDbId allFiles = null;
    private VirtualFolderDbId albumFiles = null;

    public MusicBrainzPersonFolder(Renderer renderer, String personName, DbIdTypeAndIdent typeIdent) {
        super(renderer, personName, typeIdent);
        if (StringUtils.isAllBlank(typeIdent.ident)) {
            LOGGER.debug("person name is blanc");
        } else {
            this.initChilds();
        }
    }

    @Override
    public void discoverChildren() {
        this.getChildren().clear();
        this.initChilds();
    }

    private void initChilds() {
        String encodedIdent = MusicBrainzPersonFolder.getIdent(this.getMediaType(), this.getMediaIdent());
        DbIdTypeAndIdent tiAllFilesFolder = new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON_ALL_FILES, encodedIdent);
        DbIdTypeAndIdent tiAlbumFolder = new DbIdTypeAndIdent(DbIdMediaType.TYPE_PERSON_ALBUM, encodedIdent);
        this.allFiles = new VirtualFolderDbId(this.renderer, "AllAudioTracks", tiAllFilesFolder);
        this.albumFiles = new VirtualFolderDbId(this.renderer, "ByAlbum_lowercase", tiAlbumFolder);
        this.addChild(this.allFiles);
        this.addChild(this.albumFiles);
    }

    private static String getIdent(DbIdMediaType type, String person) {
        if (type == null) {
            throw new RuntimeException("DbidMediaType is NULL");
        }
        switch (type) {
            case TYPE_PERSON_COMPOSER: {
                return String.format("%s%s", "COMP_", person);
            }
            case TYPE_PERSON_CONDUCTOR: {
                return String.format("%s%s", "COND_", person);
            }
            case TYPE_PERSON_ALBUMARTIST: {
                return String.format("%s%s", "AART_", person);
            }
            case TYPE_PERSON: {
                return person;
            }
        }
        throw new RuntimeException("Unknown DbidMediaType " + type.toString());
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        MediaTableCoverArtArchive.CoverArtArchiveResult res = MediaTableCoverArtArchive.findMBID(this.getMediaIdent());
        if (res.isFound()) {
            return DLNAThumbnailInputStream.toThumbnailInputStream(res.getCoverBytes());
        }
        return super.getThumbnailInputStream();
    }

    public VirtualFolderDbId getAllFilesFolder() {
        return this.allFiles;
    }

    public VirtualFolderDbId getAlbumFolder() {
        return this.albumFiles;
    }

    public VirtualFolderDbId getPersonFolder(Renderer renderer) {
        switch (this.getMediaType()) {
            case TYPE_PERSON_COMPOSER: {
                return renderer.getMediaStore().getDbIdLibrary().getPersonComposerFolder();
            }
            case TYPE_PERSON_CONDUCTOR: {
                return renderer.getMediaStore().getDbIdLibrary().getPersonConductorFolder();
            }
            case TYPE_PERSON_ALBUMARTIST: {
                return renderer.getMediaStore().getDbIdLibrary().getPersonAlbumArtistFolder();
            }
            case TYPE_PERSON: {
                return renderer.getMediaStore().getDbIdLibrary().getPersonArtistFolder();
            }
        }
        throw new RuntimeException("Unknown DbidMediaType " + String.valueOf((Object)this.getMediaType()));
    }
}

