/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.TranscodingSettings;
import net.pms.image.BufferedImageFilterChain;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.renderers.Renderer;
import net.pms.store.LibraryItemSorter;
import net.pms.store.StoreItem;
import net.pms.store.SystemFileResource;
import net.pms.store.container.ChapterFileTranscodeVirtualFolder;
import net.pms.store.container.TranscodeVirtualFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTranscodeVirtualFolder
extends TranscodeVirtualFolder
implements SystemFileResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTranscodeVirtualFolder.class);
    private final StoreItem originalResource;

    public FileTranscodeVirtualFolder(Renderer renderer, StoreItem resource) {
        super(renderer, resource.getDisplayNameBase());
        this.originalResource = resource;
        this.setSortable(false);
    }

    @Override
    public File getSystemFile() {
        StoreItem storeItem = this.originalResource;
        if (storeItem instanceof SystemFileResource) {
            SystemFileResource resource = (SystemFileResource)((Object)storeItem);
            return resource.getSystemFile();
        }
        return null;
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        try {
            return this.originalResource.getThumbnailInputStream();
        }
        catch (IOException e) {
            return super.getThumbnailInputStream();
        }
    }

    @Override
    public void checkThumbnail() {
        this.originalResource.checkThumbnail();
    }

    @Override
    protected void resolveOnce() {
        if (this.getChildren().isEmpty()) {
            this.originalResource.syncResolve();
            if (this.originalResource.getMediaInfo() != null && this.originalResource.getMediaInfo().isVideo()) {
                this.originalResource.registerExternalSubtitles(true);
            }
            ArrayList<MediaAudio> audioTracks = new ArrayList<MediaAudio>(this.originalResource.getMediaInfo().getAudioTracks());
            List<MediaSubtitle> subtitlesTracks = this.originalResource.getMediaSubtitle() != null ? Collections.singletonList(this.originalResource.getMediaSubtitle()) : new ArrayList<MediaSubtitle>(this.originalResource.getMediaInfo().getSubtitlesTracks());
            MediaAudio singleAudioTrack = audioTracks.size() == 1 ? (MediaAudio)audioTracks.get(0) : null;
            ArrayList<StoreItem> entries = new ArrayList<StoreItem>();
            LOGGER.trace("Duplicating {} for direct streaming to renderer: {}", (Object)this.originalResource.getName(), (Object)this.renderer.getRendererName());
            StoreItem noTranscode = FileTranscodeVirtualFolder.createResourceWithAudioSubtitleEngine(this.originalResource, singleAudioTrack, null, null);
            this.addChildInternal(noTranscode);
            this.addChapterFolder(noTranscode);
            if (audioTracks.isEmpty()) {
                audioTracks.add(null);
            }
            if (this.originalResource.getMediaSubtitle() == null) {
                if (subtitlesTracks.isEmpty()) {
                    subtitlesTracks.add(null);
                } else {
                    MediaSubtitle noSubtitle = new MediaSubtitle();
                    noSubtitle.setId(Integer.MIN_VALUE);
                    subtitlesTracks.add(noSubtitle);
                }
            }
            for (MediaAudio audio : audioTracks) {
                for (MediaSubtitle subtitle : subtitlesTracks) {
                    StoreItem temp = FileTranscodeVirtualFolder.createResourceWithAudioSubtitleEngine(this.originalResource, audio, subtitle, null);
                    List<TranscodingSettings> transcodingsSettings = TranscodingSettings.getTranscodingsSettings(temp);
                    for (TranscodingSettings transcodingSettings : transcodingsSettings) {
                        StoreItem copy = FileTranscodeVirtualFolder.createResourceWithAudioSubtitleEngine(this.originalResource, audio, subtitle, transcodingSettings);
                        entries.add(copy);
                    }
                }
            }
            if (this.renderer.isSubtitlesStreamingSupportedForAllFiletypes()) {
                for (MediaSubtitle subtitlesTrack : subtitlesTracks) {
                    if (subtitlesTrack == null || !subtitlesTrack.isExternal() || !this.renderer.isExternalSubtitlesFormatSupported(subtitlesTrack, this.originalResource)) continue;
                    StoreItem copy = FileTranscodeVirtualFolder.createResourceWithAudioSubtitleEngine(this.originalResource, singleAudioTrack, subtitlesTrack, null);
                    entries.add(copy);
                }
            }
            Collections.sort(entries, new LibraryItemSorter(EngineFactory.getEngines()));
            for (StoreItem resource : entries) {
                LOGGER.trace("Adding {}: audio: {}, subtitle: {}, engine: {}", resource.getName(), resource.getMediaAudio(), resource.getMediaSubtitle(), resource.getTranscodingSettings() != null ? resource.getTranscodingSettings().toString() : null);
                this.addChildInternal(resource);
                this.addChapterFolder(resource);
            }
        }
    }

    @Override
    public BufferedImageFilterChain addFlagFilters(BufferedImageFilterChain filterChain) {
        if (this.getParent() instanceof TranscodeVirtualFolder && this.originalResource.getMediaSubtitle() != null) {
            filterChain = this.originalResource.addSubtitlesFlagFilter(filterChain);
        }
        return filterChain;
    }

    private void addChapterFolder(StoreItem resource) {
        int chapterInterval;
        if (!resource.getFormat().isVideo()) {
            return;
        }
        int n = chapterInterval = this.renderer.getUmsConfiguration().isChapterSupport() ? this.renderer.getUmsConfiguration().getChapterInterval() : -1;
        if (chapterInterval > 0 && resource.isTimeSeekable()) {
            double duration = resource.getMediaInfo().getDurationInSeconds();
            if (duration != 0.0 && duration <= (double)(chapterInterval * 60)) {
                return;
            }
            StoreItem copy = resource.clone();
            copy.setNoName(true);
            ChapterFileTranscodeVirtualFolder chapterFolder = new ChapterFileTranscodeVirtualFolder(this.renderer, resource.getDisplayName(), copy, chapterInterval);
            this.addChildInternal(chapterFolder);
        }
    }

    private static StoreItem createResourceWithAudioSubtitleEngine(StoreItem original, MediaAudio audio, MediaSubtitle subtitle, TranscodingSettings transcodingSettings) {
        StoreItem copy = original.clone();
        copy.setMediaInfo(original.getMediaInfo());
        copy.setNoName(true);
        copy.setMediaAudio(audio);
        copy.setMediaSubtitle(subtitle);
        copy.setTranscodingSettings(transcodingSettings);
        return copy;
    }
}

