/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import com.rometools.rome.feed.synd.SyndCategory;
import com.rometools.rome.feed.synd.SyndEnclosure;
import com.rometools.rome.feed.synd.SyndEntry;
import com.rometools.rome.feed.synd.SyndFeed;
import com.rometools.rome.io.SyndFeedInput;
import com.rometools.rome.io.XmlReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pms.network.HTTPResource;
import net.pms.renderers.Renderer;
import net.pms.store.StoreContainer;
import net.pms.store.item.FeedItem;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Feed
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(Feed.class);
    private static final int REFRESH_INTERVAL = 3600000;
    private static final Map<String, String> FEED_TITLES_CACHE = Collections.synchronizedMap(new HashMap());
    private static final Map<String, String> FEED_URLS_CACHE = Collections.synchronizedMap(new HashMap());
    private final String url;
    private final int childSpecificType;
    private String tempItemTitle;
    private String tempItemLink;
    private String tempFeedLink;
    private String tempCategory;
    private String tempItemThumbURL;

    public Feed(Renderer renderer, String name, String url, int type) {
        super(renderer, name, null);
        this.childSpecificType = type;
        this.url = Feed.getFeedUrl(url);
        this.discoverChildren();
    }

    public void parse() throws Exception {
        SyndFeedInput input = new SyndFeedInput();
        byte[] b = HTTPResource.downloadAndSendBinary(this.url);
        if (b != null) {
            SyndFeed feed = input.build(new XmlReader(new ByteArrayInputStream(b)));
            this.setName(feed.getTitle());
            if (feed.getCategories() != null && !feed.getCategories().isEmpty()) {
                SyndCategory category = feed.getCategories().get(0);
                this.tempCategory = category.getName();
            }
            List<SyndEntry> entries = feed.getEntries();
            for (SyndEntry entry : entries) {
                this.tempItemTitle = entry.getTitle();
                this.tempItemLink = entry.getLink();
                this.tempFeedLink = entry.getUri();
                this.tempItemThumbURL = null;
                ArrayList elements = (ArrayList)entry.getForeignMarkup();
                for (Element elt : elements) {
                    if ("group".equals(elt.getName()) && "media".equals(elt.getNamespacePrefix())) {
                        List<Content> subElts = elt.getContent();
                        for (Content subelt : subElts) {
                            if (!(subelt instanceof Element)) continue;
                            Element element = (Element)subelt;
                            this.parseElement(element, false);
                        }
                    }
                    this.parseElement(elt, true);
                }
                List<SyndEnclosure> enclosures = entry.getEnclosures();
                for (SyndEnclosure enc : enclosures) {
                    if (!StringUtils.isNotBlank(enc.getUrl())) continue;
                    this.tempItemLink = enc.getUrl();
                }
                this.manageItem();
            }
        }
        this.setLastModified(System.currentTimeMillis());
    }

    private void parseElement(Element elt, boolean parseLink) {
        if ("content".equals(elt.getName()) && "media".equals(elt.getNamespacePrefix())) {
            if (parseLink) {
                this.tempItemLink = elt.getAttribute("url").getValue();
            }
            List<Content> subElts = elt.getContent();
            for (Content subelt : subElts) {
                if (!(subelt instanceof Element)) continue;
                Element element = (Element)subelt;
                this.parseElement(element, false);
            }
        }
        if ("thumbnail".equals(elt.getName()) && "media".equals(elt.getNamespacePrefix()) && this.tempItemThumbURL == null) {
            this.tempItemThumbURL = elt.getAttribute("url").getValue();
        }
        if ("image".equals(elt.getName()) && "exInfo".equals(elt.getNamespacePrefix()) && this.tempItemThumbURL == null) {
            this.tempItemThumbURL = elt.getValue();
        }
    }

    protected String getUrl() {
        return this.url;
    }

    protected String getTempItemTitle() {
        return this.tempItemTitle;
    }

    protected void setTempItemTitle(String tempItemTitle) {
        this.tempItemTitle = tempItemTitle;
    }

    protected String getTempItemLink() {
        return this.tempItemLink;
    }

    protected void setTempItemLink(String tempItemLink) {
        this.tempItemLink = tempItemLink;
    }

    protected String getTempFeedLink() {
        return this.tempFeedLink;
    }

    protected void setTempFeedLink(String tempFeedLink) {
        this.tempFeedLink = tempFeedLink;
    }

    protected String getTempCategory() {
        return this.tempCategory;
    }

    protected void setTempCategory(String tempCategory) {
        this.tempCategory = tempCategory;
    }

    protected String getTempItemThumbURL() {
        return this.tempItemThumbURL;
    }

    protected void setTempItemThumbURL(String tempItemThumbURL) {
        this.tempItemThumbURL = tempItemThumbURL;
    }

    @Override
    protected void resolveOnce() {
        try {
            this.parse();
        }
        catch (Exception e) {
            LOGGER.error("Error in parsing stream: " + this.url, e);
        }
    }

    @Override
    public String getSystemName() {
        return this.url;
    }

    protected void manageItem() {
        FeedItem fi = new FeedItem(this.renderer, this.tempItemTitle, this.tempItemLink, this.tempItemThumbURL, null, this.childSpecificType);
        this.addChild(fi);
    }

    @Override
    public boolean isRefreshNeeded() {
        return System.currentTimeMillis() - this.getLastModified() > 3600000L;
    }

    @Override
    public synchronized void doRefreshChildren() {
        try {
            this.getChildren().clear();
            this.parse();
        }
        catch (Exception e) {
            LOGGER.error("Error in parsing stream: " + this.url, e);
        }
        this.sortChildrenIfNeeded();
    }

    public static String getFeedTitle(String url) throws Exception {
        SyndFeed feed;
        if (StringUtils.isBlank(url)) {
            return "";
        }
        String feedTitle = FEED_TITLES_CACHE.get(url);
        if (feedTitle != null) {
            return feedTitle;
        }
        SyndFeedInput input = new SyndFeedInput();
        byte[] b = HTTPResource.downloadAndSendBinary(url);
        if (b != null && StringUtils.isNotBlank(feedTitle = (feed = input.build(new XmlReader(new ByteArrayInputStream(b)))).getTitle())) {
            FEED_TITLES_CACHE.put(url, feedTitle);
            return feedTitle;
        }
        return "";
    }

    private static String getFeedUrlFromWebpage(String url) throws IOException {
        String feedUrl = FEED_URLS_CACHE.get(url);
        if (feedUrl != null) {
            return feedUrl;
        }
        Document doc = Jsoup.connect(url).userAgent("Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)").get();
        try {
            feedUrl = doc.select("link[type=application/rss+xml]").first().attr("href");
            LOGGER.trace("Parsed feed URL {} from webpage {}", (Object)feedUrl, (Object)url);
        }
        catch (Exception e) {
            LOGGER.trace("Failed to parse feed URL from {}: {}", (Object)url, (Object)doc);
        }
        if (StringUtils.isNotBlank(feedUrl)) {
            FEED_URLS_CACHE.put(url, feedUrl);
            return feedUrl;
        }
        return null;
    }

    private static String getYouTubeChannelFeedUrl(String url) throws IOException {
        if (url.contains("youtube.com/@")) {
            return Feed.getFeedUrlFromWebpage(url);
        }
        if (url.contains("youtube.com/channel/")) {
            return url.replaceAll("youtube.com/channel/", "youtube.com/feeds/videos.xml?channel_id=");
        }
        return url;
    }

    public static String getFeedUrl(String url) {
        try {
            if (url.contains("youtube.com")) {
                return Feed.getYouTubeChannelFeedUrl(url);
            }
        }
        catch (IOException e) {
            LOGGER.debug("{}", e);
        }
        return url;
    }

    @Override
    public void discoverChildren() {
        super.discoverChildren();
        this.syncResolve();
    }
}

