/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.pms.renderers.Renderer;
import net.pms.store.container.UmsPlaylist;

public class DynamicPlaylist
extends UmsPlaylist {
    private final String savePath;
    private long start;

    public DynamicPlaylist(Renderer renderer, String name, String dir2, int mode) {
        super(renderer, name, null, 0, mode);
        this.savePath = dir2;
        this.start = 0L;
    }

    @Override
    public void clear() {
        super.clear();
        this.start = 0L;
    }

    @Override
    public void save() {
        if (this.start == 0L) {
            this.start = System.currentTimeMillis();
        }
        Date d = new Date(this.start);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm", Locale.US);
        this.list.save(new File(this.savePath, "dynamic_" + sdf.format(d) + ".ups"));
    }
}

