/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.Messages;
import net.pms.PMS;
import net.pms.dlna.DLNAImageProfile;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.item.CodeAction;

public class CodeEnter
extends StoreContainer {
    private final StoreResource resource;
    private String enteredCode;
    private String code;
    private long changed;
    private long commitTime;
    public static final int DIGITS = 0;
    public static final int LETTERS = 1;
    public static final int BOTH = 2;

    public CodeEnter(StoreResource resource) {
        super(resource.getDefaultRenderer(), resource.getName(), resource.getThumbnailURL(DLNAImageProfile.JPEG_TN));
        this.resource = resource;
        this.code = "";
        this.enteredCode = "";
        this.changed = 0L;
        this.commitTime = 0L;
    }

    private boolean preventAutoPlay() {
        int tmo = this.renderer != null ? this.renderer.getAutoPlayTmo() : 5000;
        return this.changed + (long)tmo > System.currentTimeMillis();
    }

    public void setCode(String str) {
        this.code = str;
    }

    public void setEnteredCode(String str) {
        this.enteredCode = str;
    }

    public String getCode() {
        return this.code;
    }

    public StoreResource getResource() {
        return this.resource;
    }

    private void addCharVVA(final String ch) {
        super.addChild(new CodeAction(this.renderer, ch, true){

            @Override
            public boolean enable() {
                if (CodeEnter.this.preventAutoPlay()) {
                    return false;
                }
                CodeEnter.this.enteredCode = CodeEnter.this.enteredCode + ch;
                CodeEnter.this.changed = System.currentTimeMillis();
                return true;
            }
        });
    }

    @Override
    public void discoverChildren() {
        int i;
        super.addChild(this.resource);
        int charset = this.renderer.getUmsConfiguration().getCodeCharSet();
        if (charset == 1 || charset == 2) {
            for (i = 65; i <= 90; i = (char)(i + '\u0001')) {
                this.addCharVVA(String.valueOf((char)i));
            }
        }
        if (charset == 0 || charset == 2) {
            for (i = 0; i < 10; ++i) {
                this.addCharVVA(String.valueOf(i));
            }
        }
        super.addChild(new CodeAction(this.renderer, Messages.getString("Clear"), true){

            @Override
            public boolean enable() {
                if (CodeEnter.this.preventAutoPlay()) {
                    return false;
                }
                CodeEnter.this.setEnteredCode("");
                CodeEnter.this.changed = System.currentTimeMillis();
                return true;
            }
        });
        this.sortChildrenIfNeeded();
    }

    @Override
    public synchronized void doRefreshChildren() {
        this.setEnteredCode("");
        this.getChildren().clear();
        this.discoverChildren();
    }

    public boolean validCode(StoreResource r) {
        boolean res;
        if (r instanceof CodeAction) {
            return true;
        }
        String realCode = PMS.get().codeDb().lookup(this.code);
        if (!this.enteredCode.equalsIgnoreCase(realCode)) {
            return false;
        }
        if (this.commitTime == 0L) {
            this.commitTime = System.currentTimeMillis();
            return true;
        }
        boolean bl = res = System.currentTimeMillis() - this.commitTime < (long)this.renderer.getUmsConfiguration().getCodeValidTmo();
        if (!res) {
            this.setEnteredCode("");
            this.commitTime = 0L;
            this.setDiscovered(false);
            this.getChildren().clear();
        }
        return res;
    }

    @Override
    public String toString() {
        return "CODE " + this.code;
    }
}

