/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableThumbnails;
import net.pms.dlna.DLNAThumbnail;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.external.JavaHttpClient;
import net.pms.store.ThumbnailSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThumbnailStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThumbnailStore.class.getName());
    private static final Map<Long, WeakReference<DLNAThumbnail>> STORE = new HashMap<Long, WeakReference<DLNAThumbnail>>();
    private static Long tempId = Long.MAX_VALUE;

    private ThumbnailStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getId(DLNAThumbnail thumbnail) {
        if (thumbnail == null) {
            return null;
        }
        Map<Long, WeakReference<DLNAThumbnail>> map = STORE;
        synchronized (map) {
            Connection connection = null;
            Long id = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null && (id = MediaTableThumbnails.setThumbnail(connection, thumbnail)) != null) {
                    STORE.put(id, new WeakReference<DLNAThumbnail>(thumbnail));
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long updateThumbnailByURI(String uri, String filePath, ThumbnailSource thumbnailSource) {
        DLNAThumbnail thumbnail = JavaHttpClient.getThumbnail(uri);
        Long fileId = MediaTableFiles.getFileId(filePath);
        Long id = ThumbnailStore.getId(thumbnail);
        if (id != null && fileId != null) {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) return id;
                MediaTableFiles.updateThumbnailId(connection, fileId, id, thumbnailSource.toString());
                return id;
            }
            finally {
                MediaDatabase.close(connection);
            }
        } else {
            LOGGER.debug("id : {} or fileId : {} is null", (Object)id, (Object)fileId);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getId(DLNAThumbnail thumbnail, Long fileId, ThumbnailSource thumbnailSource) {
        Long id = ThumbnailStore.getId(thumbnail);
        if (id != null && fileId != null) {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    MediaTableFiles.updateThumbnailId(connection, fileId, id, thumbnailSource.toString());
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getIdForTvSeries(DLNAThumbnail thumbnail, long tvSeriesId, ThumbnailSource thumbnailSource) {
        Long id = ThumbnailStore.getId(thumbnail);
        if (id != null) {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    MediaTableTVSeries.updateThumbnailId(connection, tvSeriesId, id, thumbnailSource.toString());
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Long getTempId(DLNAThumbnail thumbnail) {
        if (thumbnail == null) {
            return null;
        }
        Map<Long, WeakReference<DLNAThumbnail>> map = STORE;
        synchronized (map) {
            Long l = tempId;
            tempId = tempId - 1L;
            Long id = l;
            STORE.put(id, new WeakReference<DLNAThumbnail>(thumbnail));
            return id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DLNAThumbnail getThumbnail(Long id) {
        if (id == null) {
            return null;
        }
        Map<Long, WeakReference<DLNAThumbnail>> map = STORE;
        synchronized (map) {
            if (STORE.containsKey(id) && STORE.get(id).get() != null) {
                return (DLNAThumbnail)STORE.get(id).get();
            }
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) return null;
                DLNAThumbnail thumbnail = MediaTableThumbnails.getThumbnail(connection, id);
                if (thumbnail == null) return null;
                STORE.put(id, new WeakReference<DLNAThumbnail>(thumbnail));
                DLNAThumbnail dLNAThumbnail = thumbnail;
                return dLNAThumbnail;
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
    }

    public static DLNAThumbnailInputStream getThumbnailInputStream(Long id) {
        DLNAThumbnail thumbnail = ThumbnailStore.getThumbnail(id);
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetLanguage() {
        Map<Long, WeakReference<DLNAThumbnail>> map = STORE;
        synchronized (map) {
            STORE.clear();
            tempId = Long.MAX_VALUE;
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    MediaTableFiles.resetLocalizedThumbnail(connection);
                    MediaTableTVSeries.resetLocalizedThumbnail(connection);
                    MediaTableThumbnails.cleanup(connection);
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
    }
}

