/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.pms.PMS;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.encoders.TranscodingSettings;
import net.pms.media.MediaInfo;
import net.pms.network.HTTPResource;
import net.pms.renderers.Renderer;
import net.pms.store.ResumeObj;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.ThumbnailSource;
import net.pms.store.container.CodeEnter;
import net.pms.store.container.FileTranscodeVirtualFolder;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.TranscodeVirtualFolder;
import net.pms.store.container.UmsPlaylist;
import net.pms.store.item.VirtualVideoAction;
import net.pms.store.item.VirtualVideoActionLocalized;
import net.pms.store.utils.StoreResourceSorter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreContainer
extends StoreResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreResource.class);
    private static final int DEPTH_WARNING_LIMIT = 7;
    protected String name;
    protected String thumbnailIcon;
    private boolean isChildrenSorted = false;
    private boolean allChildrenAreContainers = true;
    private boolean discovered = false;
    private final List<StoreResource> children = new ArrayList<StoreResource>();
    private int lastChildId = 0;
    private StoreContainer dynamicPls;

    public StoreContainer(Renderer renderer, String name, String thumbnailIcon) {
        super(renderer);
        this.name = name;
        this.thumbnailIcon = thumbnailIcon;
    }

    public void addChild(StoreResource child) {
        this.addChild(child, true, true);
    }

    public void addChild(StoreResource child, boolean isNew, boolean isAddGlobally) {
        StoreResource cobj;
        String code;
        if (child == null) {
            LOGGER.error("A plugin has attempted to add a null child to \"{}\"", (Object)this.getName());
            LOGGER.debug("Error info:", new NullPointerException("Invalid store resource"));
            return;
        }
        child.setParent(this);
        if (isAddGlobally && this.renderer.getUmsConfiguration().useCode() && !PMS.get().masterCodeValid() && PMS.get().codeDb() != null && StringUtils.isNotEmpty(code = PMS.get().codeDb().getCode(child)) && ((cobj = child.isCoded()) == null || !((CodeEnter)cobj).getCode().equals(code))) {
            LOGGER.debug("Resource {} is coded add code folder", (Object)child);
            CodeEnter ce = new CodeEnter(child);
            ce.setParent(this);
            ce.setCode(code);
            this.addChildInternal(ce);
            return;
        }
        if (child instanceof StoreItem) {
            StoreItem storeItem = (StoreItem)child;
            child.resolve();
            this.addChildItem(storeItem, isNew, isAddGlobally);
        } else if (child instanceof StoreContainer) {
            StoreContainer storeContainer = (StoreContainer)child;
            this.addChildContainer(storeContainer, isNew, isAddGlobally);
        }
    }

    private void addChildItem(StoreItem item, boolean isNew, boolean isAddGlobally) {
        try {
            if (item.isValid()) {
                if (isAddGlobally && item.getFormat() != null) {
                    if (this.renderer != null && !this.renderer.supportsFormat(item.getFormat())) {
                        LOGGER.trace("Ignoring file \"{}\" because it is not supported by renderer \"{}\"", (Object)item.getName(), (Object)this.renderer.getRendererName());
                        this.children.remove(item);
                        return;
                    }
                    if (item.isHideFullyPlayed()) {
                        LOGGER.trace("Ignoring video file \"{}\" because it has been watched", (Object)item.getName());
                        return;
                    }
                }
                LOGGER.trace("{} child \"{}\" with class \"{}\"", isNew ? "Adding new" : "Updating", item.getName(), item.getClass().getSimpleName());
                if (this.allChildrenAreContainers && !item.isFolder()) {
                    this.allChildrenAreContainers = false;
                }
                item.setResumeHash(Math.abs(item.getSystemName().hashCode() + this.hashCode()));
                StoreItem resumeRes = null;
                ResumeObj resumeObject = ResumeObj.create(item);
                if (isAddGlobally && resumeObject != null && !this.renderer.disableUmsResume() && !this.renderer.isSamsung()) {
                    resumeRes = item.clone();
                    resumeRes.setResume(resumeObject);
                    resumeRes.setResumeHash(item.resumeHash());
                }
                if (isAddGlobally && item.getFormat() != null) {
                    if (item.getFormat().transcodable() || item.getMediaInfo() != null) {
                        if (item.getMediaInfo() == null) {
                            item.setMediaInfo(new MediaInfo());
                        }
                        TranscodingSettings transcodingSettings = null;
                        String currentName = this.getName();
                        if (this.renderer.getUmsConfiguration().isShowRecentlyPlayedFolder()) {
                            transcodingSettings = item.getTranscodingSettings();
                        } else {
                            for (TranscodingSettings tSettings : TranscodingSettings.getTranscodingsSettings(item)) {
                                String end = "[" + tSettings.getEngine().getEngineId().toString() + "]";
                                if (currentName.endsWith(end)) {
                                    this.truncateDisplayName(end);
                                    transcodingSettings = tSettings;
                                    LOGGER.trace("Selecting engine based on name end");
                                    break;
                                }
                                if (this.getParent() == null || !this.getParent().getName().endsWith(end)) continue;
                                this.getParent().truncateDisplayName(end);
                                transcodingSettings = tSettings;
                                LOGGER.trace("Selecting engine based on parent name end");
                                break;
                            }
                        }
                        if (transcodingSettings == null) {
                            transcodingSettings = item.resolveTranscodingSettings();
                        }
                        item.setTranscodingSettings(transcodingSettings);
                        if (resumeRes != null) {
                            resumeRes.setTranscodingSettings(transcodingSettings);
                            resumeRes.setMediaSubtitle(item.getMediaSubtitle());
                        }
                        if (!this.allChildrenAreContainers) {
                            TranscodeVirtualFolder transcodeFolder;
                            if ((item.getFormat().isVideo() || item.getFormat().isAudio()) && item.isTranscodeFolderAvailable() && (transcodeFolder = this.getTranscodeFolder()) != null) {
                                FileTranscodeVirtualFolder fileTranscodeFolder = new FileTranscodeVirtualFolder(this.renderer, item);
                                LOGGER.trace("Adding \"{}\" to transcode folder for engine: \"{}\"", (Object)item.getName(), (Object)transcodingSettings);
                                transcodeFolder.addChildInternal(fileTranscodeFolder);
                            }
                            if (this.renderer.getUmsConfiguration().isDynamicPls() && !item.isFolder() && this.renderer != null && !this.renderer.isNoDynPlsFolder()) {
                                this.addDynamicPls(item);
                            }
                        } else if (!item.getFormat().isCompatible(item, this.renderer) && !item.isFolder()) {
                            LOGGER.trace("Ignoring file \"{}\" because it is not compatible with renderer \"{}\"", (Object)item.getName(), (Object)this.renderer.getRendererName());
                            this.children.remove(item);
                            return;
                        }
                    }
                    if (resumeRes != null && resumeRes.getMediaInfo() != null) {
                        resumeRes.getMediaInfo().setThumbnailId(null);
                        resumeRes.getMediaInfo().setThumbnailSource(ThumbnailSource.UNKNOWN);
                        resumeRes.getMediaInfo().setMimeType("video/transcode");
                    }
                    if (item.getFormat().getSecondaryFormat() != null && item.getMediaInfo() != null && this.renderer != null && this.renderer.supportsFormat(item.getFormat().getSecondaryFormat()) && this.renderer.isPS3()) {
                        StoreItem newChild = item.clone();
                        newChild.setFormat(newChild.getFormat().getSecondaryFormat());
                        LOGGER.trace("Detected secondary format \"{}\" for \"{}\"", (Object)newChild.getFormat().toString(), (Object)newChild.getName());
                        newChild.setPrimaryResource(item);
                        item.setSecondaryResource(newChild);
                        if (!newChild.getFormat().isCompatible(newChild, this.renderer)) {
                            TranscodingSettings transcodingSettings = TranscodingSettings.getBestTranscodingSettings(newChild);
                            newChild.setTranscodingSettings(transcodingSettings);
                            LOGGER.trace("Secondary format \"{}\" will use engine \"{}\" for \"{}\"", newChild.getFormat().toString(), transcodingSettings == null ? "null" : transcodingSettings.toString(), newChild.getName());
                        }
                        if (item.getMediaInfo() != null && item.getMediaInfo().isSecondaryFormatValid()) {
                            this.addChild(newChild);
                            LOGGER.trace("Adding secondary format \"{}\" for \"{}\"", (Object)newChild.getFormat().toString(), (Object)newChild.getName());
                        } else {
                            LOGGER.trace("Ignoring secondary format \"{}\" for \"{}\": invalid format", (Object)newChild.getFormat().toString(), (Object)newChild.getName());
                        }
                    }
                }
                if (isNew) {
                    this.addChildInternal(item, isAddGlobally);
                } else {
                    LOGGER.trace("Details on media being imported :" + String.valueOf(item));
                }
                if (resumeRes != null) {
                    this.addChildInternal(resumeRes);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error adding child {}: {}", (Object)item.getName(), (Object)t);
            item.setParent(null);
            this.children.remove(item);
        }
    }

    private void addChildContainer(StoreContainer container, boolean isNew, boolean isAddGlobally) {
        try {
            if (container.isValid()) {
                LOGGER.trace("{} child \"{}\" with class \"{}\"", isNew ? "Adding new" : "Updating", container.getName(), container.getClass().getSimpleName());
                if (isNew) {
                    this.addChildInternal(container, isAddGlobally);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Error adding child {}: {}", (Object)container.getName(), (Object)t);
            container.setParent(null);
            this.children.remove(container);
        }
    }

    public boolean allowScan() {
        return false;
    }

    public List<StoreResource> getChildren() {
        return this.children;
    }

    public int childrenCount() {
        return this.children.size();
    }

    public void clearChildren() {
        Iterator<StoreResource> resources = this.children.iterator();
        while (resources.hasNext()) {
            StoreResource resource = resources.next();
            if (resource instanceof StoreContainer) {
                StoreContainer container = (StoreContainer)resource;
                container.clearChildren();
            }
            resources.remove();
            this.renderer.getMediaStore().deleteWeakResource(resource);
        }
    }

    protected int getLastChildId() {
        return this.lastChildId;
    }

    protected void setLastChildId(int lastChildId) {
        this.lastChildId = lastChildId;
    }

    public void updateChild(StoreResource child) {
        StoreResource found;
        StoreResource storeResource = found = this.children.contains(child) ? child : this.searchByName(child.getName());
        if (found != null) {
            if (child != found) {
                child.setParent(this);
                this.renderer.getMediaStore().replaceWeakResource(found, child);
                this.children.set(this.children.indexOf(found), child);
            }
            this.addChild(child, false, true);
        } else {
            this.addChild(child, true, true);
        }
    }

    public void removeChild(StoreResource child) {
        if (this.children.contains(child)) {
            if (child instanceof StoreContainer) {
                StoreContainer storeContainer = (StoreContainer)child;
                storeContainer.clearChildren();
            }
            this.children.remove(child);
        }
        this.renderer.getMediaStore().deleteWeakResource(child);
    }

    protected synchronized void addChildInternal(StoreResource child) {
        this.addChildInternal(child, true);
    }

    protected synchronized void addChildInternal(StoreResource child, boolean isAddGlobally) {
        if (child.getId() != null && !child.getId().startsWith("$DBID$")) {
            LOGGER.debug("Node ({}) already has an ID ({}), which is overridden now. The previous parent node was: {}", child.getClass().getName(), child.getResourceId(), child.getParent());
        }
        this.children.add(child);
        child.setParent(this);
        if (isAddGlobally && this.getLongId() != null) {
            this.addGlobalRepo(child);
        }
    }

    private void addGlobalRepo(StoreResource resource) {
        this.renderer.getMediaStore().addWeakResource(resource);
        if (resource instanceof StoreContainer) {
            StoreContainer container = (StoreContainer)resource;
            for (StoreResource child : container.children) {
                this.addGlobalRepo(child);
            }
        }
    }

    protected synchronized void sortChildrenIfNeeded() {
        if (this.isChildrenSorted()) {
            StoreResourceSorter.sortResourcesByDefault(this.children);
        }
    }

    protected void refreshChildrenIfNeeded() {
        if (this.isDiscovered() && this.isRefreshNeeded()) {
            this.refreshChildren();
            this.notifyRefresh();
        }
    }

    private void addDynamicPls(final StoreResource child) {
        UmsPlaylist dynPls = this.renderer.getMediaStore().getDynamicPls();
        if (dynPls == child || child.getParent() == dynPls) {
            return;
        }
        if (child instanceof VirtualVideoAction) {
            return;
        }
        if (this.dynamicPls == null) {
            this.dynamicPls = new LocalizedStoreContainer(this.renderer, "DynamicPlaylist_FolderName");
            this.addChildInternal(this.dynamicPls);
            this.dynamicPls.addChild(dynPls);
        }
        VirtualVideoActionLocalized vva = new VirtualVideoActionLocalized(this.renderer, "AddXToDynamicPlaylist", true, null, child.getDisplayName()){

            @Override
            public boolean enable() {
                this.renderer.getMediaStore().getDynamicPls().add(child);
                return true;
            }
        };
        vva.setParent(this);
        this.dynamicPls.addChildInternal(vva);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean isFolder() {
        return true;
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public String getSystemName() {
        return this.getName();
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        if (StringUtils.isEmpty(this.thumbnailIcon)) {
            try {
                return super.getThumbnailInputStream();
            }
            catch (IOException e) {
                return null;
            }
        }
        return DLNAThumbnailInputStream.toThumbnailInputStream(HTTPResource.getResourceInputStream(this.thumbnailIcon));
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public void setThumbnail(String thumbnailIcon) {
        this.thumbnailIcon = thumbnailIcon;
    }

    private TranscodeVirtualFolder getTranscodeFolder() {
        if (!this.isTranscodeFolderAvailable()) {
            return null;
        }
        if (!this.renderer.getUmsConfiguration().isShowTranscodeFolder()) {
            return null;
        }
        for (StoreResource child : this.children) {
            if (!(child instanceof TranscodeVirtualFolder)) continue;
            TranscodeVirtualFolder transcodeVirtualFolder = (TranscodeVirtualFolder)child;
            return transcodeVirtualFolder;
        }
        TranscodeVirtualFolder transcodeFolder = new TranscodeVirtualFolder(this.renderer, this.renderer.getUmsConfiguration());
        transcodeFolder.setChildrenSorted(this.isChildrenSorted);
        this.addChildInternal(transcodeFolder);
        return transcodeFolder;
    }

    protected StoreContainer getSharedContentParent(String parentPath) {
        StoreContainer result = null;
        if (parentPath != null) {
            StringTokenizer st = new StringTokenizer(parentPath, "/");
            StoreContainer currentRoot = this;
            while (st.hasMoreTokens()) {
                String folder = st.nextToken();
                result = currentRoot.searchByName(folder);
                if (result == null) {
                    result = new StoreContainer(this.renderer, folder, "");
                    currentRoot.addChild(result);
                }
                currentRoot = result;
            }
        }
        if (result == null) {
            result = this;
        }
        return result;
    }

    public StoreContainer searchByName(String name) {
        for (StoreResource child : this.children) {
            if (!(child instanceof StoreContainer)) continue;
            StoreContainer virtualFolder = (StoreContainer)child;
            if (!child.getName().equals(name)) continue;
            return virtualFolder;
        }
        return null;
    }

    public int indexOf(String objectId) {
        String resourceId = StringUtils.substringBefore(objectId, "/");
        if (resourceId != null) {
            for (int i = 0; i < this.children.size(); ++i) {
                if (!resourceId.equals(this.children.get(i).getResourceId())) continue;
                return i;
            }
        }
        return -1;
    }

    public void discoverChildren() {
        this.sortChildrenIfNeeded();
    }

    public void discoverChildren(String str) {
        this.discoverChildren();
    }

    protected final synchronized void discover(boolean forced) {
        if (!this.isDiscovered()) {
            LOGGER.trace("Initial discovering children for container: {}", (Object)this.getDisplayName());
            if (this.renderer.getUmsConfiguration().getFolderLimit() && this.depthLimit()) {
                if (this.renderer.isPS3() || this.renderer.isXbox360()) {
                    LOGGER.info("Depth limit potentionally hit for " + this.getDisplayName());
                }
                this.renderer.addFolderLimit(this);
            }
            this.discoverChildren();
            this.setDiscovered(true);
            this.notifyRefresh();
        } else {
            LOGGER.trace("discover {} refresh forced: {}", (Object)this.getResourceId(), (Object)forced);
            if (forced) {
                if (this.refreshChildren()) {
                    this.notifyRefresh();
                } else {
                    this.sortChildrenIfNeeded();
                }
            } else if (this.isRefreshNeeded()) {
                this.doRefreshChildren();
                this.notifyRefresh();
            } else {
                this.sortChildrenIfNeeded();
            }
        }
    }

    public void doRefreshChildren() {
        this.sortChildrenIfNeeded();
    }

    public void doRefreshChildren(String search, String lang) {
        this.doRefreshChildren();
    }

    private boolean depthLimit() {
        StoreContainer tmp = this;
        int depth = 0;
        while (tmp != null) {
            tmp = tmp.getParent();
            ++depth;
        }
        return depth > 7;
    }

    public boolean isRefreshNeeded() {
        return false;
    }

    public boolean refreshChildren() {
        if (this.isRefreshNeeded()) {
            this.doRefreshChildren();
            return true;
        }
        return false;
    }

    public boolean refreshChildren(String search, String lang) {
        if (this.isRefreshNeeded()) {
            this.doRefreshChildren(search, lang);
            return true;
        }
        return false;
    }

    public boolean isDiscovered() {
        return this.discovered;
    }

    public void setDiscovered(boolean discovered) {
        this.discovered = discovered;
    }

    protected void setChildrenSorted(boolean isChildrenSorted) {
        this.isChildrenSorted = isChildrenSorted;
    }

    public boolean isChildrenSorted() {
        return this.isChildrenSorted;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" [id=").append(this.getId());
        result.append(", name=").append(this.getName());
        result.append(", discovered=").append(this.isDiscovered());
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            result.append(", children=").append(this.getChildren());
        }
        result.append(']');
        return result.toString();
    }
}

