/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.Nonnull;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.sharedcontent.FolderContent;
import net.pms.configuration.sharedcontent.SharedContent;
import net.pms.configuration.sharedcontent.SharedContentArray;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.configuration.sharedcontent.SharedContentListener;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFiles;
import net.pms.gui.GuiManager;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.ConnectedRenderers;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.MediaScannerDevice;
import net.pms.store.MediaInfoStore;
import net.pms.store.MediaStore;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.SystemFilesHelper;
import net.pms.store.container.DVDISOFile;
import net.pms.store.container.PlaylistFolder;
import net.pms.store.container.RealFolder;
import net.pms.util.FileUtil;
import net.pms.util.FileWatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaScanner
implements SharedContentListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaScanner.class);
    private static final String ENTRY_CREATE = StandardWatchEventKinds.ENTRY_CREATE.name();
    private static final String ENTRY_DELETE = StandardWatchEventKinds.ENTRY_DELETE.name();
    private static final String ENTRY_MODIFY = StandardWatchEventKinds.ENTRY_MODIFY.name();
    private static final Object DEFAULT_FOLDERS_LOCK = new Object();
    private static final ReentrantLock SCANNER_LOCK = new ReentrantLock();
    private static final List<FileWatcher.Watch> MEDIA_FILEWATCHERS = new ArrayList<FileWatcher.Watch>();
    private static final List<String> SHARED_FOLDERS = new ArrayList<String>();
    private static final Renderer RENDERER = MediaScannerDevice.getRenderer();
    private static final MediaScanner INSTANCE = new MediaScanner();
    private static final List<String> FILES_PARSING = Collections.synchronizedList(new ArrayList());
    @GuardedBy(value="DEFAULT_FOLDERS_LOCK")
    private static List<String> defaultFolders = null;
    private static Thread scannerThread;
    private static boolean running;
    private static final FileWatcher.Listener MEDIA_RESCANNER;

    private MediaScanner() {
    }

    @Override
    public synchronized void updateSharedContent() {
        MediaScanner.setMediaFileWatchers();
        MediaScanner.setSharedFolders();
    }

    public static void init() {
        SharedContentConfiguration.addListener(INSTANCE);
    }

    private static void startScan() {
        if (running) {
            throw new IllegalStateException("Can't scan when scan in progress");
        }
        MediaScanner.setRunning(true);
        MediaScanner.reset();
        GuiManager.setMediaScanStatus(true);
        MediaScanner.setSharedContent();
        LOGGER.debug("Starting media scanner");
        if (running) {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    MediaScanner.scan(RENDERER.getMediaStore());
                    if (running) {
                        MediaTableFiles.cleanup(connection);
                    }
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
            MediaScanner.setRunning(false);
        }
        MediaScanner.reset();
        GuiManager.setMediaScanStatus(false);
        GuiManager.setStatusLine(null);
    }

    private static void scan(StoreContainer resource) {
        if (running) {
            for (StoreResource child : resource.getChildren()) {
                StoreContainer storeContainer;
                try {
                    MediaStore.waitWorkers();
                }
                catch (InterruptedException ex) {
                    running = false;
                    Thread.currentThread().interrupt();
                }
                if (running && child instanceof StoreContainer && (storeContainer = (StoreContainer)child).allowScan()) {
                    int count;
                    if (storeContainer instanceof RealFolder) {
                        String childName = child.getName();
                        LOGGER.debug("Scanning folder: " + childName);
                        GuiManager.setStatusLine(Messages.getString("ScanningFolder") + " " + childName);
                    }
                    if (storeContainer.isDiscovered()) {
                        storeContainer.refreshChildren();
                    } else {
                        if (storeContainer instanceof DVDISOFile || storeContainer instanceof PlaylistFolder) {
                            storeContainer.syncResolve();
                        }
                        storeContainer.discoverChildren();
                        storeContainer.setDiscovered(true);
                    }
                    if ((count = storeContainer.getChildren().size()) == 0) continue;
                    MediaScanner.scan(storeContainer);
                    storeContainer.getChildren().clear();
                    continue;
                }
                if (running) continue;
                break;
            }
        } else {
            GuiManager.setStatusLine(null);
        }
    }

    private static void reset() {
        RENDERER.getMediaStore().getChildren().clear();
        RENDERER.getMediaStore().setDiscovered(false);
    }

    private static void setSharedContent() {
        if (RENDERER.getMediaStore().isDiscovered()) {
            return;
        }
        SharedContentArray sharedContents = SharedContentConfiguration.getSharedContentArray();
        for (SharedContent sharedContent : sharedContents) {
            FolderContent folder;
            if (!(sharedContent instanceof FolderContent) || (folder = (FolderContent)sharedContent).getFile() == null || !folder.isActive()) continue;
            StoreResource realSystemFileResource = RENDERER.getMediaStore().createResourceFromFile(folder.getFile(), true);
            if (realSystemFileResource != null) {
                RENDERER.getMediaStore().addChild(realSystemFileResource);
                continue;
            }
            LOGGER.trace("createResourceFromFile has failed for {}", (Object)folder.getFile());
        }
    }

    public static boolean isMediaScanRunning() {
        return scannerThread != null && scannerThread.isAlive();
    }

    public static void startMediaScan() {
        if (MediaScanner.isMediaScanRunning()) {
            LOGGER.info("Cannot start media scanner: A scan is already in progress");
        } else if (PMS.isRunningTests()) {
            LOGGER.debug("Skipping media scanner because UMS is being run by a test");
        } else {
            Runnable scan = () -> {
                block5: {
                    try {
                        if (RENDERER == null) break block5;
                        LOGGER.info("Media scan started");
                        long start = System.currentTimeMillis();
                        try {
                            SCANNER_LOCK.lock();
                            MediaScanner.startScan();
                        }
                        finally {
                            SCANNER_LOCK.unlock();
                        }
                        LOGGER.info("Media scan completed in {} seconds", (Object)((System.currentTimeMillis() - start) / 1000L));
                        LOGGER.info("Database analyze started");
                        start = System.currentTimeMillis();
                        MediaDatabase.analyzeDb();
                        LOGGER.info("Database analyze completed in {} seconds", (Object)((System.currentTimeMillis() - start) / 1000L));
                    }
                    catch (Exception e) {
                        LOGGER.error("Unhandled exception during media scan: {}", (Object)e.getMessage());
                        LOGGER.trace("", e);
                    }
                }
            };
            scannerThread = new Thread(scan, "Media Scanner");
            scannerThread.setPriority(1);
            scannerThread.start();
            GuiManager.setMediaScanStatus(true);
        }
    }

    public static void stopMediaScan() {
        if (MediaScanner.isMediaScanRunning()) {
            MediaScanner.setRunning(false);
            GuiManager.setMediaScanStatus(false);
        }
    }

    public static void backgroundScanFileOrFolder(String filename) {
        if (!MediaScanner.isMediaScanRunning()) {
            Runnable scan = () -> {
                if (RENDERER != null) {
                    MediaScanner.scanFileOrFolder(filename);
                }
            };
            Thread scanThread = new Thread(scan, "scanFileOrFolder");
            scanThread.start();
        }
    }

    private static void scanFileOrFolder(String filename) {
        try {
            SCANNER_LOCK.lock();
            MediaScanner.reset();
            MediaScanner.internalScanFileOrFolder(filename);
            MediaScanner.reset();
        }
        finally {
            SCANNER_LOCK.unlock();
        }
    }

    private static void internalScanFileOrFolder(String filename) {
        if (MediaScanner.isInSharedFolders(filename) || MediaScanner.isInDefaultFolders(filename)) {
            String parent;
            LOGGER.debug("Scanning file or folder : " + filename);
            File file = new File(filename);
            if (!file.exists()) {
                LOGGER.debug("Not scanning file or folder that no longer exists: " + filename);
                return;
            }
            if (file.isFile()) {
                file = file.getParentFile();
                LOGGER.debug("Scanning folder \"{}\" for file \"{}\"", (Object)file.getAbsolutePath(), (Object)filename);
            } else {
                LOGGER.debug("Scanning folder \"{}\"", (Object)file.getAbsolutePath());
            }
            List<StoreResource> systemFileResources = RENDERER.getMediaStore().findSystemFileResources(file);
            if (systemFileResources.isEmpty() && MediaScanner.isInSharedFolders(parent = file.getParentFile().getAbsolutePath())) {
                MediaScanner.internalScanFileOrFolder(parent);
                systemFileResources = RENDERER.getMediaStore().findSystemFileResources(file);
            }
            if (!systemFileResources.isEmpty()) {
                for (StoreResource storeResource : systemFileResources) {
                    if (!(storeResource instanceof StoreContainer)) continue;
                    StoreContainer storeContainer = (StoreContainer)storeResource;
                    storeContainer.discoverChildren();
                    storeContainer.setDiscovered(true);
                }
            } else {
                LOGGER.warn("Given folder was not found in store : " + file.getAbsolutePath());
            }
        } else {
            LOGGER.warn("Given file or folder doesn't share same base path as this server : " + filename);
        }
    }

    private static void setRunning(boolean value) {
        running = value;
    }

    private static synchronized boolean isInSharedFolders(String filename) {
        return MediaScanner.hasSameBasePath(SHARED_FOLDERS, filename);
    }

    private static boolean isInDefaultFolders(String filename) {
        return MediaScanner.hasSameBasePath(MediaScanner.getDefaultFolders(), filename);
    }

    private static boolean hasSameBasePath(List<String> dirs, String filename) {
        for (String path : dirs) {
            if (!filename.startsWith(path)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    private static List<String> getDefaultFolders() {
        Object object = DEFAULT_FOLDERS_LOCK;
        synchronized (object) {
            if (defaultFolders == null) {
                ArrayList<String> result = new ArrayList<String>();
                for (Path path : PlatformUtils.INSTANCE.getDefaultFolders()) {
                    result.add(path.toString());
                }
                defaultFolders = Collections.unmodifiableList(result);
            }
            return defaultFolders;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void parseFileEntry(File file, boolean advise, boolean isCrawlingParentDirectory) {
        String filename = file.getAbsolutePath();
        List<String> list = FILES_PARSING;
        synchronized (list) {
            if (FILES_PARSING.contains(filename)) {
                return;
            }
            FILES_PARSING.add(filename);
        }
        Runnable r = () -> {
            try {
                if (advise) {
                    LOGGER.debug("File {} was created on the hard drive", (Object)filename);
                }
                long currentSize = file.length();
                Thread.sleep(500L);
                while (file.exists() && (currentSize != file.length() || FileUtil.isLocked(file))) {
                    LOGGER.trace("Waiting until file {} is fully written", (Object)filename);
                    currentSize = file.length();
                    Thread.sleep(500L);
                }
                List<String> list = FILES_PARSING;
                synchronized (list) {
                    FILES_PARSING.remove(filename);
                }
                if (file.exists()) {
                    LOGGER.debug("Analyzing file {}", (Object)filename);
                    if (!SystemFilesHelper.isPotentialMediaFile(file.getAbsolutePath())) {
                        LOGGER.trace("Not parsing file that can't be media");
                        return;
                    }
                    if (!file.exists()) {
                        LOGGER.trace("Not parsing file that no longer exists");
                        return;
                    }
                    if (FileUtil.isLocked(file)) {
                        LOGGER.debug("File will not be parsed because it is open in another process");
                        return;
                    }
                    if (!MediaScanner.isInSharedFolders(file.getAbsolutePath())) {
                        LOGGER.debug("File will not be parsed because it is not in a shared folder");
                        return;
                    }
                    StoreResource rf = RENDERER.getMediaStore().createResourceFromFile(file);
                    if (rf != null) {
                        if (rf instanceof StoreItem) {
                            StoreItem storeItem = (StoreItem)rf;
                            storeItem.resolveFormat();
                        }
                        rf.syncResolve();
                        if (rf.isValid()) {
                            LOGGER.info("New file {} was detected and added to the media store", (Object)file.getName());
                            MediaStoreIds.incrementSystemUpdateId();
                            if (FileUtil.isLocked(file)) {
                                System.gc();
                            }
                            if (advise || isCrawlingParentDirectory) {
                                for (Renderer connectedRenderer : ConnectedRenderers.getConnectedRenderers()) {
                                    connectedRenderer.getMediaStore().fileAdded(file);
                                }
                            }
                        }
                    } else {
                        LOGGER.trace("File {} was not recognized as valid media so was not added to the media store", (Object)file.getName());
                    }
                } else {
                    LOGGER.debug("File {} does not exist anymore", (Object)filename);
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        };
        new Thread(r, "MediaScanner File Parser").start();
    }

    private static void addFolderEntry(File directory) {
        LOGGER.trace("Folder {} was created on the hard drive", (Object)directory);
        if (RENDERER.getUmsConfiguration().getIgnoredFolderNames().contains(directory.getName())) {
            LOGGER.debug("Ignoring {} because it is in the ignored folders list", (Object)directory.getName());
            return;
        }
        File[] files = directory.listFiles();
        if (files != null) {
            LOGGER.trace("Crawling {}", (Object)directory.getName());
            for (File file : files) {
                if (file.isFile()) {
                    LOGGER.trace("File {} found in {}", (Object)file.getName(), (Object)directory.getName());
                    MediaScanner.parseFileEntry(file, false, true);
                    continue;
                }
                if (!file.isDirectory()) continue;
                MediaScanner.addFolderEntry(file);
            }
        } else {
            LOGGER.trace("Folder {} is empty", (Object)directory.getName());
        }
    }

    private static void removeFolderEntry(String filename) {
        LOGGER.trace("Folder {} was deleted or moved on the hard drive, removing all files within it from the database", (Object)filename);
        File folder = new File(filename);
        for (Renderer connectedRenderer : ConnectedRenderers.getConnectedRenderers()) {
            connectedRenderer.getMediaStore().fileRemoved(folder);
        }
        if (MediaInfoStore.removeMediaEntriesInFolder(filename)) {
            MediaStoreIds.incrementSystemUpdateId();
        }
    }

    private static void removeFileEntry(String filename) {
        LOGGER.info("File {} was deleted or moved on the hard drive, removing it from the database", (Object)filename);
        if (MediaInfoStore.removeMediaEntry(filename)) {
            File file = new File(filename);
            for (Renderer connectedRenderer : ConnectedRenderers.getConnectedRenderers()) {
                connectedRenderer.getMediaStore().fileRemoved(file);
            }
            MediaStoreIds.incrementSystemUpdateId();
        }
    }

    private static void setSharedFolders() {
        SHARED_FOLDERS.clear();
        for (File file : SharedContentConfiguration.getSharedFolders()) {
            if (!file.exists()) continue;
            SHARED_FOLDERS.add(file.getAbsolutePath());
        }
    }

    private static void setMediaFileWatchers() {
        for (FileWatcher.Watch watcher : MEDIA_FILEWATCHERS) {
            FileWatcher.remove(watcher);
        }
        MEDIA_FILEWATCHERS.clear();
        List<String> ignoredFolderNames = RENDERER.getUmsConfiguration().getIgnoredFolderNames();
        for (File file : SharedContentConfiguration.getMonitoredFolders()) {
            if (file.exists()) {
                if (!file.isDirectory()) {
                    LOGGER.trace("Skip adding a FileWatcher for non-folder \"{}\"", (Object)file);
                    continue;
                }
                if (ignoredFolderNames.contains(file.getName())) {
                    LOGGER.debug("Skip adding a FileWatcher for \"{}\" because it is in the ignored folders list", (Object)file.getName());
                    continue;
                }
                LOGGER.trace("Creating FileWatcher for " + file.toString());
                try {
                    FileWatcher.Watch watcher = new FileWatcher.Watch(file.toString() + File.separator + "**", MEDIA_RESCANNER);
                    watcher.setIgnoredFolderNames(ignoredFolderNames);
                    MEDIA_FILEWATCHERS.add(watcher);
                    FileWatcher.add(watcher);
                }
                catch (Exception e) {
                    LOGGER.warn("File watcher access denied for directory {}", (Object)file.toString());
                }
                continue;
            }
            LOGGER.trace("Skip adding a FileWatcher for non-existent \"{}\"", (Object)file);
        }
    }

    static {
        MEDIA_RESCANNER = (filename, event, watch, isDir) -> {
            if (ENTRY_DELETE.equals(event) || ENTRY_CREATE.equals(event) || ENTRY_MODIFY.equals(event)) {
                if (isDir) {
                    if (ENTRY_CREATE.equals(event)) {
                        MediaScanner.addFolderEntry(new File(filename));
                    } else if (ENTRY_DELETE.equals(event)) {
                        MediaScanner.removeFolderEntry(filename);
                    }
                } else if (ENTRY_CREATE.equals(event)) {
                    MediaScanner.parseFileEntry(new File(filename), true, false);
                } else if (ENTRY_DELETE.equals(event)) {
                    MediaScanner.removeFileEntry(filename);
                } else {
                    MediaScanner.parseFileEntry(new File(filename), false, false);
                }
            }
        };
    }
}

