/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.util.Comparator;
import java.util.List;
import net.pms.encoders.Engine;
import net.pms.store.StoreItem;

public class LibraryItemSorter
implements Comparator<StoreItem> {
    private final List<Engine> engines;

    public LibraryItemSorter(List<Engine> engines) {
        this.engines = engines;
    }

    @Override
    public int compare(StoreItem resource1, StoreItem resource2) {
        Integer engineIndex2;
        Integer engineIndex1 = this.engines.indexOf(resource1.isTranscoded() ? resource1.getTranscodingSettings().getEngine() : null);
        if (!engineIndex1.equals(engineIndex2 = Integer.valueOf(this.engines.indexOf(resource2.isTranscoded() ? resource2.getTranscodingSettings().getEngine() : null)))) {
            return engineIndex1.compareTo(engineIndex2);
        }
        int cmpAudioLang = LibraryItemSorter.compareLanguage(LibraryItemSorter.getMediaAudioLanguage(resource1), LibraryItemSorter.getMediaAudioLanguage(resource2));
        if (cmpAudioLang != 0) {
            return cmpAudioLang;
        }
        return LibraryItemSorter.compareLanguage(LibraryItemSorter.getMediaSubtitleLanguage(resource1), LibraryItemSorter.getMediaSubtitleLanguage(resource2));
    }

    private static int compareLanguage(String lang1, String lang2) {
        if (lang1 == null && lang2 == null) {
            return 0;
        }
        if (lang1 != null && lang2 != null) {
            return lang1.compareToIgnoreCase(lang2);
        }
        if (lang1 == null) {
            return -1;
        }
        return 1;
    }

    private static String getMediaAudioLanguage(StoreItem resource) {
        return resource.getMediaAudio() == null ? null : resource.getMediaAudio().getLang();
    }

    private static String getMediaSubtitleLanguage(StoreItem resource) {
        return resource.getMediaSubtitle() == null ? null : resource.getMediaSubtitle().getLang();
    }
}

