/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.sleep;

import java.util.Locale;
import net.pms.Messages;

public enum PreventSleepMode {
    NEVER,
    PLAYBACK,
    RUNNING;


    public static PreventSleepMode typeOf(String sleepMode) {
        if (sleepMode == null) {
            return null;
        }
        return switch (sleepMode = sleepMode.trim().toLowerCase(Locale.ROOT)) {
            case "never", "off", "none", "no" -> NEVER;
            case "playback", "during playback", "while playing", "while streaming" -> PLAYBACK;
            case "running", "while running", "when running", "yes" -> RUNNING;
            default -> null;
        };
    }

    public String getValue() {
        return super.toString();
    }

    public String toString() {
        switch (this) {
            case NEVER: {
                return Messages.getString("Never");
            }
            case PLAYBACK: {
                return Messages.getString("DuringPlayback");
            }
            case RUNNING: {
                return Messages.getString("WhileRunning");
            }
        }
        throw new IllegalStateException("Unimplemented enum value: " + super.toString());
    }
}

