/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.process;

import com.google.errorprone.annotations.Immutable;
import jakarta.annotation.Nonnull;
import net.pms.service.process.ProcessTicketAction;
import org.apache.commons.lang3.StringUtils;

@Immutable
public class ProcessTicket {
    protected final Process process;
    protected final String processName;
    protected final ProcessTicketAction action;
    protected final long timeoutMS;
    protected final long terminateTimeoutMS;

    public ProcessTicket(@Nonnull Process process, @Nonnull String processName, @Nonnull ProcessTicketAction action, long timeoutMS, long terminateTimeoutMS) {
        if (process == null) {
            throw new IllegalArgumentException("process cannot be null");
        }
        if (StringUtils.isBlank(processName)) {
            throw new IllegalArgumentException("processName cannot be blank");
        }
        if (action == null) {
            throw new IllegalArgumentException("action cannot be null");
        }
        this.process = process;
        this.processName = processName;
        this.action = action;
        this.timeoutMS = Math.max(0L, timeoutMS);
        this.terminateTimeoutMS = Math.max(action == ProcessTicketAction.ADD ? 100L : 0L, terminateTimeoutMS);
    }

    public Process getProcess() {
        return this.process;
    }

    public String getName() {
        return this.processName;
    }

    public ProcessTicketAction getAction() {
        return this.action;
    }

    public long getTimeoutMS() {
        return this.timeoutMS;
    }

    public long getTerminateTimeoutMS() {
        return this.terminateTimeoutMS;
    }

    public String toString() {
        return "ProcessTicket [Name=" + this.processName + ", Timeout=" + this.timeoutMS + " ms, Terminate Timeout=" + this.terminateTimeoutMS + " ms, Action=" + String.valueOf((Object)this.action) + "]";
    }
}

