/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.process;

import com.google.errorprone.annotations.ThreadSafe;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import jakarta.annotation.Nonnull;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import net.pms.platform.PlatformUtils;
import net.pms.service.process.AbstractProcessTerminator;
import net.pms.service.process.ProcessTicket;
import net.pms.service.process.ProcessTicketAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ProcessManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessManager.class);
    protected final LinkedList<ProcessTicket> incoming = new LinkedList();
    @GuardedBy(value="incoming")
    protected AbstractProcessTerminator terminator;

    public ProcessManager() {
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        LinkedList<ProcessTicket> linkedList = this.incoming;
        synchronized (linkedList) {
            if (this.terminator == null || !this.terminator.isAlive()) {
                LOGGER.debug("Starting ProcessManager");
                this.terminator = PlatformUtils.INSTANCE.getProcessTerminator(this);
                this.terminator.start();
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.warn("ProcessManager is already running, start attempt failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AbstractProcessTerminator currentTerminator;
        LinkedList<ProcessTicket> linkedList = this.incoming;
        synchronized (linkedList) {
            currentTerminator = this.terminator;
            this.terminator = null;
        }
        if (currentTerminator != null) {
            LOGGER.debug("Stopping ProcessManager");
            currentTerminator.interrupt();
            try {
                currentTerminator.join();
            }
            catch (InterruptedException e) {
                LOGGER.debug("ProcessManager was interrupted while waiting for the process terminator to terminate");
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearWorker(AbstractProcessTerminator terminator) {
        LinkedList<ProcessTicket> linkedList = this.incoming;
        synchronized (linkedList) {
            if (this.terminator == terminator) {
                this.terminator = null;
            }
        }
    }

    public void addProcess(@Nonnull Process process, @Nonnull String processName, long timeoutMS, long terminateTimeoutMS) {
        this.addTicket(new ProcessTicket(process, processName, ProcessTicketAction.ADD, timeoutMS, terminateTimeoutMS));
    }

    public void addProcess(@Nonnull Process process, @Nonnull String processName, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) {
        this.addTicket(new ProcessTicket(process, processName, ProcessTicketAction.ADD, timeUnit.toMillis(timeout), terminateTimeoutMS));
    }

    public void shutdownProcess(@Nonnull Process process, @Nonnull String processName, long terminateTimeoutMS) {
        this.addTicket(new ProcessTicket(process, processName, ProcessTicketAction.SHUTDOWN, 0L, terminateTimeoutMS));
    }

    public void shutdownProcess(@Nonnull Process process, @Nonnull String processName) {
        this.addTicket(new ProcessTicket(process, processName, ProcessTicketAction.SHUTDOWN, 0L, 0L));
    }

    public void removeProcess(@Nonnull Process process, @Nonnull String processName) {
        this.addTicket(new ProcessTicket(process, processName, ProcessTicketAction.REMOVE, 0L, 0L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTicket(@Nonnull ProcessTicket ticket) {
        if (ticket == null) {
            throw new IllegalArgumentException("ticket cannot be null");
        }
        LinkedList<ProcessTicket> linkedList = this.incoming;
        synchronized (linkedList) {
            this.incoming.add(ticket);
            this.incoming.notifyAll();
            if (this.terminator == null || !this.terminator.isAlive()) {
                LOGGER.warn("ProcessManager added the following ticket while no ProcessTerminator is processing tickets: {}", (Object)ticket);
            }
        }
    }
}

