/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.renderers.devices.players.PlayerItem;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistItem
extends PlayerItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlaylistItem.class);
    private static final Matcher DC_TITLE = Pattern.compile("<dc:title>(.+)</dc:title>").matcher("");

    public PlaylistItem(String uri, String name, String metadata) {
        this.uri = uri;
        this.name = name;
        this.metadata = metadata;
    }

    public String toString() {
        if (StringUtils.isBlank(this.name)) {
            try {
                this.name = !StringUtils.isEmpty(this.metadata) && DC_TITLE.reset(UMSUtils.unescape(this.metadata)).find() ? DC_TITLE.group(1) : new File(StringUtils.substringBefore(UMSUtils.unescape(this.uri), "?")).getName();
            }
            catch (IllegalArgumentException e) {
                LOGGER.error("URL decoding error ", e);
            }
        }
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == null) return false;
        if (other == this) return true;
        if (other instanceof PlaylistItem) {
            PlaylistItem item = (PlaylistItem)other;
            if (item.uri.equals(this.uri)) return true;
        }
        if (!other.toString().equals(this.uri)) return false;
        return true;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }
}

