/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import javax.swing.DefaultComboBoxModel;
import javax.swing.SwingUtilities;
import net.pms.dlna.DidlHelper;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.LogicalPlayer;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Playlist
extends DefaultComboBoxModel<PlaylistItem> {
    private static final long serialVersionUID = 5934677633834195753L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Playlist.class);
    LogicalPlayer player;

    public Playlist(LogicalPlayer p) {
        this.player = p;
    }

    public PlaylistItem get(String uri) {
        int index = this.getIndexOf(new PlaylistItem(uri, null, null));
        if (index > -1) {
            return (PlaylistItem)this.getElementAt(index);
        }
        return null;
    }

    public PlaylistItem resolve(String uri) {
        PlaylistItem item = null;
        try {
            String selectedName;
            Object selected = this.getSelectedItem();
            PlaylistItem selectedItem = selected instanceof PlaylistItem ? (PlaylistItem)selected : null;
            String string = selectedName = selectedItem != null ? selectedItem.getName() : null;
            item = StringUtils.isBlank(uri) || uri.equals(selectedName) ? selectedItem : (uri.startsWith("$i$") ? (PlaylistItem)this.getElementAt(Integer.parseInt(uri.substring(3))) : this.get(uri));
        }
        catch (NumberFormatException e) {
            LOGGER.error("An error occurred while resolving the item for URI \"{}\": {}", (Object)uri, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return item != null && Playlist.isValid(item, this.player.getRenderer()) ? item : null;
    }

    public void validate() {
        for (int i = this.getSize() - 1; i > -1; --i) {
            if (Playlist.isValid((PlaylistItem)this.getElementAt(i), this.player.getRenderer())) continue;
            this.removeElementAt(i);
        }
    }

    public void set(String uri, String name, String metadata) {
        this.add(0, uri, name, metadata, true);
    }

    public void add(int index, String uri, String name, String metadata, boolean select) {
        if (!StringUtils.isBlank(uri)) {
            SwingUtilities.invokeLater(() -> {
                PlaylistItem item = this.resolve(uri);
                if (item == null) {
                    item = new PlaylistItem(uri, name, metadata);
                    this.insertElementAt(item, index > -1 ? index : this.getSize());
                }
                if (select) {
                    this.setSelectedItem(item);
                }
            });
        }
    }

    public void remove(String uri) {
        if (!StringUtils.isBlank(uri)) {
            SwingUtilities.invokeLater(() -> {
                PlaylistItem item = this.resolve(uri);
                if (item != null) {
                    this.removeElement(item);
                }
            });
        }
    }

    public void step(int n) {
        if (this.getSize() > 0) {
            int i = (this.getIndexOf(this.getSelectedItem()) + this.getSize() + n) % this.getSize();
            this.setSelectedItem(this.getElementAt(i));
        }
    }

    @Override
    protected void fireContentsChanged(Object source, int index0, int index1) {
        this.player.alert();
        super.fireContentsChanged(source, index0, index1);
    }

    @Override
    protected void fireIntervalAdded(Object source, int index0, int index1) {
        this.player.alert();
        super.fireIntervalAdded(source, index0, index1);
    }

    @Override
    protected void fireIntervalRemoved(Object source, int index0, int index1) {
        this.player.alert();
        super.fireIntervalRemoved(source, index0, index1);
    }

    public static boolean isValid(PlaylistItem item, Renderer renderer) {
        if (StoreResource.isResourceUrl(item.getUri())) {
            if (renderer.getMediaStore().weakResourceExists(StoreResource.parseResourceId(item.getUri()))) {
                return true;
            }
            StoreResource resource = renderer.getMediaStore().getValidResource(item.getUri(), item.getName());
            if (resource instanceof StoreItem) {
                StoreItem storeItem = (StoreItem)resource;
                item.setUri(storeItem.getMediaURL("", true));
                item.setMetadata(DidlHelper.getDidlString(resource));
                return true;
            }
            return false;
        }
        return true;
    }
}

