/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import net.pms.renderers.devices.players.PlayerItem;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class PlayerState
extends PlayerItem {
    static final int UNKNOWN = -1;
    static final int STOPPED = 0;
    static final int PLAYING = 1;
    static final int PAUSED = 2;
    private int playback;
    private boolean mute;
    private int volume;
    private String position;
    private String duration;
    private long buffer;

    public int getPlayback() {
        return this.playback;
    }

    public void setPlayback(int value) {
        this.playback = value;
    }

    public boolean isUnknown() {
        return this.playback == -1;
    }

    public boolean isStopped() {
        return this.playback == 0;
    }

    public boolean isPlaying() {
        return this.playback == 1;
    }

    public boolean isPaused() {
        return this.playback == 2;
    }

    public boolean isMuted() {
        return this.mute;
    }

    public void setMuted(boolean value) {
        this.mute = value;
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int value) {
        this.volume = value;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String value) {
        this.duration = value;
    }

    public void setDuration(long value) {
        this.duration = DurationFormatUtils.formatDuration(value, "HH:mm:ss");
    }

    public void setDuration(double value) {
        this.duration = StringUtil.convertTimeToString(value, "%02d:%02d:%02.0f");
    }

    public String getPosition() {
        return this.position;
    }

    public void setPosition(String value) {
        this.position = value;
    }

    public void setPosition(long value) {
        this.position = DurationFormatUtils.formatDuration(value, "HH:mm:ss");
    }

    public void setPosition(double value) {
        this.position = StringUtil.convertTimeToString(value, "%02d:%02d:%02.0f");
    }

    public long getBuffer() {
        return this.buffer;
    }

    public void setBuffer(long value) {
        this.buffer = value;
    }

    public void reset() {
        this.playback = 0;
        this.position = "";
        this.duration = "";
        this.name = " ";
        this.buffer = 0L;
    }
}

