/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import net.pms.io.BufferedOutputFile;
import net.pms.io.BufferedOutputFileImpl;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsNamedPipe
extends Thread
implements ProcessWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsNamedPipe.class);
    private String path;
    private boolean in;
    private boolean forceReconnect;
    private WinNT.HANDLE handle1;
    private WinNT.HANDLE handle2;
    private OutputStream writable;
    private InputStream readable;
    private Thread forced;
    private boolean b2;
    private FileOutputStream debug;
    private BufferedOutputFile directBuffer;
    private static boolean loop = true;
    private static final int BUFSIZE = 500000;

    public String getPipeName() {
        return this.path;
    }

    public OutputStream getWritable() {
        return this.writable;
    }

    public InputStream getReadable() {
        return this.readable;
    }

    public BufferedOutputFile getDirectBuffer() {
        return this.directBuffer;
    }

    @Override
    public InputStream getInputStream(long seek) throws IOException {
        return null;
    }

    public ArrayList<String> getResults() {
        return null;
    }

    @Override
    public boolean isDestroyed() {
        return !this.isAlive();
    }

    @Override
    public void runInNewThread() {
    }

    @Override
    public void runInSameThread() {
    }

    @Override
    public boolean isReadyToStop() {
        return false;
    }

    @Override
    public void setReadyToStop(boolean nullable) {
    }

    @Override
    public void stopProcess() {
        this.interrupt();
    }

    public static void setLoop(boolean value) {
        loop = value;
    }

    public WindowsNamedPipe(String basename, boolean forceReconnect, boolean in, OutputParams params) {
        this.path = "\\\\.\\pipe\\" + basename;
        this.in = in;
        this.forceReconnect = forceReconnect;
        LOGGER.debug("Creating pipe " + this.path);
        try {
            this.handle1 = Kernel32.INSTANCE.CreateNamedPipe(this.path, 3, 0, 255, 500000, 500000, 0, null);
            if (forceReconnect) {
                this.handle2 = Kernel32.INSTANCE.CreateNamedPipe(this.path, 3, 0, 255, 500000, 500000, 0, null);
            }
            if (params != null) {
                this.directBuffer = new BufferedOutputFileImpl(params);
            } else {
                this.writable = new PipedOutputStream();
                this.readable = new PipedInputStream((PipedOutputStream)this.writable, 500000);
            }
            this.start();
            if (forceReconnect) {
                this.forced = new Thread(() -> {
                    this.b2 = Kernel32.INSTANCE.ConnectNamedPipe(this.handle2, null);
                }, "Forced Reconnector");
                this.forced.start();
            }
        }
        catch (Exception e1) {
            LOGGER.warn("Error creating Windows named pipe: {}", (Object)e1.getMessage());
            LOGGER.trace("", e1);
        }
    }

    @Override
    public void run() {
        block29: {
            LOGGER.debug("Waiting for Windows named pipe connection \"{}\"", (Object)this.path);
            boolean b1 = Kernel32.INSTANCE.ConnectNamedPipe(this.handle1, null);
            if (this.forceReconnect) {
                while (this.forced.isAlive()) {
                    UMSUtils.sleep(200);
                }
                LOGGER.debug("Forced reconnection of {} with result: {}", (Object)this.path, (Object)this.b2);
                this.handle1 = this.handle2;
            }
            LOGGER.debug("Result of {}: {}", (Object)this.path, (Object)b1);
            try {
                if (!b1) break block29;
                if (this.in) {
                    IntByReference intRef = new IntByReference();
                    byte[] buffer = new byte[500000];
                    while (loop) {
                        boolean fSuccess = Kernel32.INSTANCE.ReadFile(this.handle1, buffer, 500000, intRef, null);
                        int cbBytesRead = intRef.getValue();
                        if (cbBytesRead == -1) {
                            if (this.directBuffer != null) {
                                this.directBuffer.close();
                            }
                            if (this.writable != null) {
                                this.writable.close();
                            }
                            if (this.debug != null) {
                                this.debug.close();
                            }
                        } else {
                            if (this.directBuffer != null) {
                                this.directBuffer.write(buffer, 0, cbBytesRead);
                            }
                            if (this.writable != null) {
                                this.writable.write(buffer, 0, cbBytesRead);
                            }
                            if (this.debug != null) {
                                this.debug.write(buffer, 0, cbBytesRead);
                            }
                            if (fSuccess && cbBytesRead != 0) continue;
                            if (this.directBuffer != null) {
                                this.directBuffer.close();
                            }
                            if (this.writable != null) {
                                this.writable.close();
                            }
                            if (this.debug != null) {
                                this.debug.close();
                            }
                        }
                        break block29;
                    }
                    break block29;
                }
                byte[] buffer = new byte[500000];
                IntByReference intRef = new IntByReference();
                while (loop) {
                    int cbBytesRead = this.readable.read(buffer);
                    if (cbBytesRead == -1) {
                        this.readable.close();
                        if (this.debug != null) {
                            this.debug.close();
                        }
                    } else {
                        boolean fSuccess = Kernel32.INSTANCE.WriteFile(this.handle1, buffer, cbBytesRead, intRef, null);
                        int cbWritten = intRef.getValue();
                        if (this.debug != null) {
                            this.debug.write(buffer, 0, cbBytesRead);
                        }
                        if (fSuccess && cbWritten != 0) continue;
                        this.readable.close();
                        if (this.debug != null) {
                            this.debug.close();
                        }
                    }
                    break;
                }
            }
            catch (InterruptedIOException e) {
                if (LOGGER.isDebugEnabled()) {
                    if (StringUtils.isNotBlank(e.getMessage())) {
                        LOGGER.debug("Windows named pipe interrupted after writing {} bytes, shutting down: {}", (Object)e.bytesTransferred, (Object)e.getMessage());
                    } else {
                        LOGGER.debug("Windows named pipe interrupted after writing {} bytes, shutting down...", (Object)e.bytesTransferred);
                    }
                    LOGGER.trace("", e);
                }
            }
            catch (IOException e) {
                LOGGER.debug("Windows named pipe error: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        if (!this.in) {
            LOGGER.debug("Disconnecting Windows named pipe: {}", (Object)this.path);
            Kernel32.INSTANCE.FlushFileBuffers(this.handle1);
            Kernel32.INSTANCE.DisconnectNamedPipe(this.handle1);
        } else {
            Kernel32.INSTANCE.CloseHandle(this.handle1);
        }
    }
}

