/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.posix;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Locale;
import net.pms.platform.posix.POSIXSignal;
import net.pms.service.process.AbstractProcessTerminator;
import net.pms.service.process.ProcessInfo;
import net.pms.service.process.ProcessManager;
import net.pms.service.process.ProcessState;

public class POSIXProcessTerminator
extends AbstractProcessTerminator {
    public POSIXProcessTerminator(@Nonnull ProcessManager owner) {
        super(owner);
    }

    @Override
    protected void stopPlatformProcess(@Nullable ProcessInfo processInfo) throws InterruptedException {
        String nameLower;
        if (processInfo == null) {
            return;
        }
        if (processInfo.getState() == ProcessState.RUNNING && this.sendPOSIXSignal(processInfo, POSIXSignal.SIGTERM)) {
            processInfo.setState(ProcessState.SIGTERM);
            this.processes.put(this.getSchedule(processInfo.getTerminateTimeoutMS()), processInfo);
            return;
        }
        if ((processInfo.getState() == ProcessState.RUNNING || processInfo.getState() == ProcessState.SIGTERM) && ((nameLower = processInfo.getName().toLowerCase(Locale.ROOT)).contains("mencoder") || nameLower.contains("mplayer")) && this.sendPOSIXSignal(processInfo, POSIXSignal.SIGALRM)) {
            processInfo.setState(ProcessState.SIGALRM);
            this.processes.put(this.getSchedule(processInfo.getTerminateTimeoutMS()), processInfo);
            return;
        }
        if ((processInfo.getState() == ProcessState.RUNNING || processInfo.getState() == ProcessState.SIGTERM || processInfo.getState() == ProcessState.SIGALRM) && this.sendPOSIXSignal(processInfo, POSIXSignal.SIGKILL)) {
            processInfo.setState(ProcessState.SIGKILL);
            this.processes.put(this.getSchedule(Math.max(500L, processInfo.getTerminateTimeoutMS())), processInfo);
            return;
        }
        LOGGER.warn("All previous attempts to terminate process \"{}\" ({}) has failed, leaving it to the JVM and hoping for the best", (Object)processInfo.getName(), (Object)processInfo.getPID());
        this.destroyProcess(processInfo.getProcess());
    }

    protected boolean sendPOSIXSignal(@Nonnull ProcessInfo processInfo, @Nullable POSIXSignal signal) throws InterruptedException {
        if (signal == null) {
            signal = POSIXSignal.SIGTERM;
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Attempting to send {} to timed out process \"{}\" ({})", new Object[]{signal, processInfo.getName(), processInfo.getPID()});
        }
        ProcessBuilder processBuilder = new ProcessBuilder("kill", "-" + signal.getValue(), Long.toString(processInfo.getPID()));
        processBuilder.redirectErrorStream(true);
        try {
            Process process = processBuilder.start();
            this.gobbleStream(process.getInputStream());
            int exitCode = process.waitFor();
            if (exitCode != 0) {
                LOGGER.debug("kill -{} failed for process \"{}\" ({}) with exit code {}", signal.getValue(), processInfo.getName(), processInfo.getPID(), exitCode);
                return false;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("{} sent to process \"{}\" ({})", new Object[]{signal, processInfo.getName(), processInfo.getPID()});
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("kill -{} for process \"{}\" ({}) failed with: {}", signal.getValue(), processInfo.getName(), processInfo.getPID(), e.getMessage());
            LOGGER.trace("", e);
            return false;
        }
    }
}

