/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac;

import net.pms.Messages;
import net.pms.platform.mac.iokit.IOKitException;
import net.pms.platform.mac.iokit.IOKitUtils;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacSleepWorker
extends AbstractSleepWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(MacSleepWorker.class);
    protected int preventAssertionId = -1;
    protected int postponeAssertionId = -1;

    public MacSleepWorker(SleepManager owner, PreventSleepMode mode) {
        super("macOS Sleep Worker", mode, owner);
    }

    @Override
    protected synchronized void doAllowSleep() {
        this.doResetSleepTimer();
        if (this.preventAssertionId > 0) {
            try {
                LOGGER.trace("Calling IOKitUtils.enableGoToSleep to stop preventing macOS idle sleep");
                IOKitUtils.enableGoToSleep(this.preventAssertionId);
                this.sleepPrevented = false;
            }
            catch (IOKitException e) {
                this.preventSleep = this.sleepPrevented;
                LOGGER.warn("Unable to release idle sleep prevention assertion: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        } else {
            LOGGER.warn("Ignoring attempt to release idle sleep prevention assertion with invalid id ", (Object)this.preventAssertionId);
            this.preventSleep = this.sleepPrevented;
        }
    }

    @Override
    protected synchronized void doPreventSleep() {
        try {
            LOGGER.trace("Calling IOKitUtils.disableGoToSleep() to prevent macOS idle sleep");
            this.preventAssertionId = IOKitUtils.disableGoToSleep(this.getPreventAssertionName(), this.getPreventAssertionDetails());
            this.sleepPrevented = true;
        }
        catch (IOKitException e) {
            LOGGER.warn("Unable to create idle sleep prevention assertion: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            this.preventSleep = this.sleepPrevented;
        }
    }

    @Override
    protected synchronized void doResetSleepTimer() {
        try {
            LOGGER.trace("Calling IOKitUtils.resetSleepTimer() to postpone macOS idle sleep");
            this.postponeAssertionId = IOKitUtils.resetIdleTimer(Messages.getString("UniversalMediaServerResetIdle"), this.postponeAssertionId);
        }
        catch (IOKitException e) {
            LOGGER.warn("Unable to reset idle sleep timer: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            this.postponeAssertionId = -1;
        }
        this.resetSleepTimer = false;
    }

    protected synchronized String getPreventAssertionName() {
        if (this.mode == PreventSleepMode.PLAYBACK) {
            return Messages.getString("UniversalMediaServerPlaying");
        }
        if (this.mode == PreventSleepMode.RUNNING) {
            return Messages.getString("UniversalMediaServerRunning");
        }
        return "Universal Media Server internal error";
    }

    protected synchronized String getPreventAssertionDetails() {
        if (this.mode == PreventSleepMode.PLAYBACK) {
            return Messages.getString("SystemIdleSleepPreventedPlayback");
        }
        if (this.mode == PreventSleepMode.RUNNING) {
            return Messages.getString("SystemIdleSleepPreventedRunning");
        }
        return "A bug in Universal Media Server causes this assertion to exist";
    }
}

