/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public abstract class TerminatedArray<E>
extends PointerType
implements List<E> {
    protected List<E> buffer;

    protected TerminatedArray() {
    }

    protected TerminatedArray(Pointer p) {
        super(p);
    }

    public abstract E getTerminator();

    public abstract int getElementSize();

    protected abstract E readElement(int var1);

    protected abstract void writeElement(int var1);

    protected abstract void writeTerminator();

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        this.setPointer((Pointer)nativeValue);
        return nativeValue == null ? null : this;
    }

    @Override
    public Object toNative() {
        if (this.buffer == null) {
            return null;
        }
        long size = (long)this.getElementSize() * ((long)this.buffer.size() + 1L);
        if (!(this.getPointer() instanceof Memory) || ((Memory)this.getPointer()).size() < size) {
            super.setPointer(new Memory(size));
        }
        for (int i = 0; i < this.buffer.size(); ++i) {
            this.writeElement(i);
        }
        this.writeTerminator();
        return this.getPointer();
    }

    @Override
    public void setPointer(Pointer p) {
        super.setPointer(p);
        this.readElements();
    }

    protected void readElements() {
        E element;
        if (this.getPointer() == null) {
            this.buffer = null;
            return;
        }
        E terminator = this.getTerminator();
        if (this.buffer == null) {
            this.buffer = new ArrayList();
        } else {
            this.buffer.clear();
        }
        int i = 0;
        while ((element = this.readElement(i)) != terminator) {
            this.buffer.add(element);
            ++i;
        }
    }

    @Override
    public String toString() {
        return this.buffer == null ? "null" : this.buffer.toString();
    }

    @Override
    public int size() {
        return this.buffer == null ? 0 : this.buffer.size();
    }

    @Override
    public boolean isEmpty() {
        return this.buffer == null || this.buffer.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.buffer != null && this.buffer.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.buffer == null ? null : this.buffer.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.buffer == null ? null : this.buffer.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.buffer == null ? null : this.buffer.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.buffer != null && this.buffer.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.buffer != null && this.buffer.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.buffer != null && this.buffer.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.buffer != null && this.buffer.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.buffer != null && this.buffer.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.buffer != null && this.buffer.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.buffer != null && this.buffer.retainAll(c);
    }

    @Override
    public void clear() {
        if (this.buffer != null) {
            this.buffer.clear();
        }
    }

    @Override
    public E get(int index) {
        return this.buffer == null ? null : (E)this.buffer.get(index);
    }

    @Override
    public E set(int index, E element) {
        if (this.buffer == null) {
            throw new IndexOutOfBoundsException("TerminatedArray is empty");
        }
        return this.buffer.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        if (this.buffer != null) {
            this.buffer.add(index, element);
        }
    }

    @Override
    public E remove(int index) {
        return this.buffer == null ? null : (E)this.buffer.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.buffer == null ? -1 : this.buffer.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.buffer == null ? -1 : this.buffer.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.buffer == null ? null : this.buffer.listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.buffer == null ? null : this.buffer.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.buffer == null ? null : this.buffer.subList(fromIndex, toIndex);
    }
}

