/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.jna;

import com.sun.jna.FromNativeContext;
import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.PointerType;

public abstract class FixedArrayByReference<E>
extends PointerType {
    protected final long size;

    protected FixedArrayByReference(long fixedSize) {
        this.size = Math.max(fixedSize, 0L);
        if (this.size > 0L) {
            super.setPointer(new Memory((long)this.getElementSize() * this.size));
        }
    }

    public abstract int getElementSize();

    protected abstract E[] getElements();

    protected abstract void setElements(E[] var1);

    public long getSize() {
        return this.size;
    }

    public boolean isGarbageCollected() {
        return this.getPointer() == null || this.getPointer() instanceof Memory;
    }

    public void setArray(E[] array) {
        if (array == null) {
            throw new NullPointerException("array cannot be null");
        }
        if ((long)array.length != this.size) {
            throw new IllegalArgumentException("array size must be " + this.size);
        }
        if (this.size < 1L) {
            super.setPointer(Pointer.NULL);
            return;
        }
        if (this.getPointer() == null) {
            super.setPointer(new Memory((long)this.getElementSize() * this.size));
        }
        this.setElements(array);
    }

    public E[] getArray() {
        if (this.size > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Array to big, please read it \"manually\" using getPointer.readX");
        }
        return this.getPointer() == null ? null : this.getElements();
    }

    @Override
    public void setPointer(Pointer p) {
        if (!this.isGarbageCollected()) {
            throw new UnsupportedOperationException("The internal pointer points to native memory, setting it could lead to memory leak and is not supported");
        }
        super.setPointer(p);
    }

    @Override
    public Object fromNative(Object nativeValue, FromNativeContext context) {
        if (nativeValue == null) {
            return null;
        }
        super.setPointer((Pointer)nativeValue);
        return this;
    }
}

