/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFolder {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFolder.class);
    private static final String DEFAULT_TEMP_FOLDER_NAME = "UMS";
    private final String userSpecifiedFolder;
    private File folder;

    public TempFolder(String userSpecifiedFolder) {
        this.userSpecifiedFolder = userSpecifiedFolder;
    }

    public synchronized File getTempFolder() throws IOException {
        if (this.folder == null) {
            this.folder = TempFolder.getTempFolder(this.userSpecifiedFolder);
        }
        return this.folder;
    }

    private static File getTempFolder(String userSpecifiedFolder) throws IOException {
        if (userSpecifiedFolder == null) {
            return TempFolder.getSystemTempFolder();
        }
        try {
            return TempFolder.getUserSpecifiedTempFolder(userSpecifiedFolder);
        }
        catch (IOException e) {
            LOGGER.error("Problem with user specified temp directory - using system", e);
            return TempFolder.getSystemTempFolder();
        }
    }

    private static File getUserSpecifiedTempFolder(String userSpecifiedFolder) throws IOException {
        if (userSpecifiedFolder == null || userSpecifiedFolder.length() == 0) {
            throw new IOException("Temporary directory path must not be null or empty if specified");
        }
        File folderFile = new File(userSpecifiedFolder);
        folderFile.setReadable(true, false);
        folderFile.setWritable(true, false);
        FileUtils.forceMkdir(folderFile);
        TempFolder.assertFolderIsValid(folderFile);
        return folderFile;
    }

    private static File getSystemTempFolder() throws IOException {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        File myTMP = Platform.isWindows() ? new File(tmp, DEFAULT_TEMP_FOLDER_NAME) : new File(tmp, "UMS-" + System.getProperty("user.name"));
        myTMP.setReadable(true, false);
        myTMP.setWritable(true, false);
        FileUtils.forceMkdir(myTMP);
        TempFolder.assertFolderIsValid(myTMP);
        return myTMP;
    }

    private static void assertFolderIsValid(File folder) throws IOException {
        FilePermissions permission = FileUtil.getFilePermissions(folder);
        if (!permission.isFolder()) {
            throw new IOException("Temporary folder isn't a folder: " + folder.getAbsolutePath());
        }
        if (!permission.isBrowsable()) {
            throw new IOException("Temporary folder isn't browsable: " + folder.getAbsolutePath());
        }
        if (!permission.isWritable()) {
            throw new IOException("Temporary folder isn't writable: " + folder.getAbsolutePath());
        }
    }
}

