/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform;

import java.io.File;
import java.io.IOException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.service.process.AbstractProcessTerminator;
import net.pms.service.process.ProcessManager;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import net.pms.util.Version;

public interface IPlatformUtils {
    public File getAvsPluginsDir();

    public File getKLiteFiltersDir();

    public String getSystemPathName(String var1);

    public String getDiskLabel(File var1);

    public boolean isKerioFirewall();

    public Path getVlcPath();

    public Version getVlcVersion();

    public boolean isAviSynthAvailable();

    public boolean isAviSynthPlusAvailable();

    public boolean isTsMuxeRCompatible();

    public boolean browseURI(String var1);

    public boolean isNetworkInterfaceLoopback(NetworkInterface var1) throws SocketException;

    public String getTrayIcon();

    public byte[] getHardwareAddress(NetworkInterface var1) throws SocketException;

    public String[] getPingCommand(String var1, int var2, int var3);

    public String parsePingLine(String var1);

    public int getPingPacketFragments(int var1);

    public void moveToTrash(File var1) throws IOException;

    public boolean isAdmin();

    public List<Path> getDefaultFolders();

    public Version getFileVersionInfo(String var1);

    public String getiTunesFile() throws IOException, URISyntaxException;

    public Charset getDefaultCharset();

    public String getDefaultFontPath();

    public boolean isPreventSleepSupported();

    public AbstractSleepWorker getSleepWorker(SleepManager var1, PreventSleepMode var2);

    public AbstractProcessTerminator getProcessTerminator(ProcessManager var1);

    public IPipeProcess getPipeProcess(String var1, OutputParams var2, String ... var3);

    public IPipeProcess getPipeProcess(String var1, String ... var2);

    public void appendErrorString(StringBuilder var1, int var2);

    public List<String> getRestartCommand(boolean var1);

    public String[] getShutdownCommand();

    public String getJvmExecutableName();

    public void destroyProcess(Process var1);
}

