/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webplayerserver;

import java.io.IOException;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.network.webplayerserver.WebPlayerServerJetty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class WebPlayerServer {
    protected static final Logger LOGGER = LoggerFactory.getLogger(WebPlayerServer.class);
    protected static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    protected static final int DEFAULT_PORT = CONFIGURATION.getWebPlayerServerPort();

    public abstract Object getServer();

    public abstract int getPort();

    public abstract String getAddress();

    public abstract String getUrl();

    public abstract boolean isSecure();

    public abstract void stop();

    public static WebPlayerServer createServer(int port) throws IOException {
        return WebPlayerServerJetty.createServer(port);
    }
}

