/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import net.pms.configuration.RendererConfigurations;
import net.pms.configuration.UmsConfiguration;
import net.pms.iam.Account;
import net.pms.iam.AuthService;
import net.pms.network.configuration.NetworkConfiguration;
import net.pms.network.webguiserver.GuiHttpServlet;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationConverter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="SettingsApiServlet", urlPatterns={"/v1/api/settings"}, displayName="Settings Api Servlet")
public class SettingsApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingsApiServlet.class);
    private static final Pattern INT_PATTERN = Pattern.compile("^\\d+$");
    private static final Pattern FLOAT_PATTERN = Pattern.compile("^\\d+(\\.\\d+)?$");
    private static final JsonObject WEB_SETTINGS_WITH_DEFAULTS = UmsConfiguration.getWebSettingsWithDefaults();
    private static final JsonArray AUDIO_COVER_SUPPLIERS = UmsConfiguration.getAudioCoverSuppliersAsJsonArray();
    private static final JsonArray FFMPEG_LOGLEVEL = UmsConfiguration.getFfmpegLoglevels();
    private static final JsonArray UPNP_LOGLEVEL = UmsConfiguration.getUpnpLoglevels();
    private static final JsonArray FULLY_PLAYED_ACTIONS = UmsConfiguration.getFullyPlayedActionsAsJsonArray();
    private static final JsonArray SORT_METHODS = UmsConfiguration.getSortMethodsAsJsonArray();
    private static final JsonArray SUBTITLES_CODEPAGES = UmsConfiguration.getSubtitlesCodepageArray();
    private static final JsonArray SUBTITLES_DEPTH = UmsConfiguration.getSubtitlesDepthArray();
    private static final JsonArray SUBTITLES_INFO_LEVELS = UmsConfiguration.getSubtitlesInfoLevelsAsJsonArray();
    private static final JsonArray TRANSCODING_ENGINES_PURPOSES = UmsConfiguration.getEnginesPurposesAsJsonArray();
    private static final JsonArray GPU_ENCODING_H264_ACCELERATION_METHODS = UmsConfiguration.getFFmpegAvailableGPUH264EncodingAccelerationMethodsArray();
    private static final JsonArray GPU_ENCODING_H265_ACCELERATION_METHODS = UmsConfiguration.getFFmpegAvailableGPUH265EncodingAccelerationMethodsArray();

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getPathInfo();
            if (path.equals("/")) {
                Account account = AuthService.getAccountLoggedIn(req.getHeader("Authorization"), req.getRemoteAddr(), req.getRemoteAddr().equals(req.getLocalAddr()));
                if (account == null) {
                    SettingsApiServlet.respondUnauthorized(req, resp);
                    return;
                }
                if (!account.havePermission(3072)) {
                    SettingsApiServlet.respondForbidden(req, resp);
                    return;
                }
                JsonObject jsonResponse = new JsonObject();
                jsonResponse.add("userSettingsDefaults", WEB_SETTINGS_WITH_DEFAULTS);
                JsonObject selectionSettings = new JsonObject();
                selectionSettings.add("allRendererNames", RendererConfigurations.getAllRendererNamesAsJsonArray());
                selectionSettings.add("audioCoverSuppliers", AUDIO_COVER_SUPPLIERS);
                selectionSettings.add("enabledRendererNames", RendererConfigurations.getEnabledRendererNamesAsJsonArray());
                selectionSettings.add("ffmpegLoglevels", FFMPEG_LOGLEVEL);
                selectionSettings.add("fullyPlayedActions", FULLY_PLAYED_ACTIONS);
                selectionSettings.add("gpuEncodingH264AccelerationMethods", GPU_ENCODING_H264_ACCELERATION_METHODS);
                selectionSettings.add("gpuEncodingH265AccelerationMethods", GPU_ENCODING_H265_ACCELERATION_METHODS);
                selectionSettings.add("networkInterfaces", NetworkConfiguration.getNetworkInterfacesAsJsonArray());
                selectionSettings.add("sortMethods", SORT_METHODS);
                selectionSettings.add("subtitlesCodepages", SUBTITLES_CODEPAGES);
                selectionSettings.add("subtitlesDepth", SUBTITLES_DEPTH);
                selectionSettings.add("subtitlesInfoLevels", SUBTITLES_INFO_LEVELS);
                selectionSettings.add("transcodingEngines", UmsConfiguration.getAllEnginesAsJsonObject());
                selectionSettings.add("transcodingEnginesPurposes", TRANSCODING_ENGINES_PURPOSES);
                selectionSettings.add("upnpLoglevels", UPNP_LOGLEVEL);
                jsonResponse.add("selectionSettings", selectionSettings);
                jsonResponse.add("userSettings", SettingsApiServlet.getConfigurationAsJsonObject());
                SettingsApiServlet.respond(req, resp, jsonResponse.toString(), 200, "application/json");
            } else {
                LOGGER.trace("SettingsApiServlet request not available : {}", (Object)path);
                SettingsApiServlet.respondNotFound(req, resp);
            }
        }
        catch (RuntimeException e) {
            LOGGER.trace("", e);
            SettingsApiServlet.respondInternalServerError(req, resp);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error in SettingsApiServlet.doGet(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path;
            switch (path = req.getPathInfo()) {
                case "/": {
                    Configuration configuration = CONFIGURATION.getConfiguration();
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account == null) {
                        SettingsApiServlet.respondUnauthorized(req, resp);
                        return;
                    }
                    if (!account.havePermission(2048)) {
                        SettingsApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject data = SettingsApiServlet.getJsonObjectFromBody(req);
                    for (Map.Entry<String, JsonElement> configurationSetting : data.entrySet()) {
                        String key = configurationSetting.getKey();
                        if (!WEB_SETTINGS_WITH_DEFAULTS.has(key)) {
                            LOGGER.trace("The key {} is not allowed", (Object)key);
                            continue;
                        }
                        JsonElement jsonElement = configurationSetting.getValue();
                        if (jsonElement instanceof JsonPrimitive) {
                            JsonPrimitive element = (JsonPrimitive)jsonElement;
                            if (element.isBoolean()) {
                                LOGGER.trace("Saving key {} and Boolean value {}", (Object)key, (Object)element);
                                configuration.setProperty(key, element.getAsBoolean());
                                continue;
                            }
                            if (element.isNumber()) {
                                LOGGER.trace("Saving key {} and Number value {}", (Object)key, (Object)element);
                                configuration.setProperty(key, element.getAsNumber().longValue());
                                continue;
                            }
                            if (element.isString()) {
                                LOGGER.trace("Saving key {} and String value {}", (Object)key, (Object)element);
                                configuration.setProperty(key, element.getAsString());
                                continue;
                            }
                            LOGGER.trace("Invalid value passed from client: {}, {} of type {}", key, configurationSetting.getValue(), configurationSetting.getValue().getClass().getSimpleName());
                            continue;
                        }
                        jsonElement = configurationSetting.getValue();
                        if (jsonElement instanceof JsonArray) {
                            JsonArray element = (JsonArray)jsonElement;
                            StringBuilder arrayAsCommaDelimitedString = new StringBuilder();
                            for (int i = 0; i < element.size(); ++i) {
                                if (i != 0) {
                                    arrayAsCommaDelimitedString.append(",");
                                }
                                arrayAsCommaDelimitedString.append(element.get(i).getAsString());
                            }
                            configuration.setProperty(key, arrayAsCommaDelimitedString.toString());
                            continue;
                        }
                        if (configurationSetting.getValue() instanceof JsonNull) {
                            configuration.setProperty(key, "");
                            continue;
                        }
                        LOGGER.trace("Invalid value passed from client: {}, {} of type {}", key, configurationSetting.getValue(), configurationSetting.getValue().getClass().getSimpleName());
                    }
                    SettingsApiServlet.respond(req, resp, "{}", 200, "application/json");
                    break;
                }
                case "/directories": {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account == null) {
                        SettingsApiServlet.respondUnauthorized(req, resp);
                        return;
                    }
                    if (!account.havePermission(2048)) {
                        SettingsApiServlet.respondForbidden(req, resp);
                        return;
                    }
                    JsonObject post = SettingsApiServlet.getJsonObjectFromBody(req);
                    String directoryResponse = SettingsApiServlet.getDirectoryResponse(post);
                    if (directoryResponse == null) {
                        SettingsApiServlet.respondNotFound(req, resp, "Directory does not exist");
                        return;
                    }
                    SettingsApiServlet.respond(req, resp, directoryResponse, 200, "application/json");
                    break;
                }
                default: {
                    LOGGER.trace("SettingsApiServlet request not available : {}", (Object)path);
                    SettingsApiServlet.respondNotFound(req, resp);
                    break;
                }
            }
        }
        catch (RuntimeException e) {
            LOGGER.trace("", e);
            SettingsApiServlet.respondInternalServerError(req, resp);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected error in SettingsApiServlet.doPost(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static boolean haveKey(String key) {
        return WEB_SETTINGS_WITH_DEFAULTS.has(key);
    }

    private static boolean acceptEmptyValueForKey(String key) {
        return UmsConfiguration.VALID_EMPTY_KEYS.contains(key);
    }

    private static boolean isSelectKey(String key) {
        return UmsConfiguration.SELECT_KEYS.contains(key);
    }

    private static boolean isArrayKey(String key) {
        return UmsConfiguration.ARRAY_KEYS.contains(key);
    }

    private static String getDirectoryResponse(JsonObject data) {
        String requestedDirectory = data != null && data.has("path") ? data.get("path").getAsString() : "";
        return SettingsApiServlet.getDirectoryResponse(requestedDirectory);
    }

    private static String getDirectoryResponse(String path) {
        if (StringUtils.isEmpty(path)) {
            path = System.getProperty("user.home");
        }
        if ("roots".equals(path)) {
            return SettingsApiServlet.getRootsDirectoryResponse();
        }
        List<File> roots = Arrays.asList(File.listRoots());
        JsonObject jsonResponse = new JsonObject();
        File requestedDirectoryFile = new File(path);
        if (!requestedDirectoryFile.exists()) {
            return SettingsApiServlet.getRootsDirectoryResponse();
        }
        Object[] directories = requestedDirectoryFile.listFiles(file -> file.isDirectory() && !file.isHidden() && file.canRead() && !file.getName().startsWith("."));
        Arrays.sort(directories);
        JsonArray jsonArray = new JsonArray();
        for (Object file2 : directories) {
            JsonObject directoryGroup = new JsonObject();
            String value = ((File)file2).toString();
            String label = ((File)file2).getName();
            directoryGroup.addProperty("label", label);
            directoryGroup.addProperty("value", value);
            jsonArray.add(directoryGroup);
        }
        jsonResponse.add("children", jsonArray);
        String name = requestedDirectoryFile.getName();
        if (StringUtils.isEmpty(name) && roots.contains(requestedDirectoryFile)) {
            name = requestedDirectoryFile.toString().replace("\\", "");
        }
        jsonArray = new JsonArray();
        JsonObject directoryGroup = new JsonObject();
        directoryGroup.addProperty("label", name);
        directoryGroup.addProperty("value", requestedDirectoryFile.toString());
        jsonArray.add(directoryGroup);
        while (requestedDirectoryFile.getParentFile() != null && requestedDirectoryFile.getParentFile().isDirectory()) {
            directoryGroup = new JsonObject();
            name = (requestedDirectoryFile = requestedDirectoryFile.getParentFile()).getName();
            if (StringUtils.isEmpty(name) && roots.contains(requestedDirectoryFile)) {
                name = requestedDirectoryFile.toString().replace("\\", "");
            }
            directoryGroup.addProperty("label", name);
            directoryGroup.addProperty("value", requestedDirectoryFile.toString());
            jsonArray.add(directoryGroup);
        }
        jsonResponse.add("parents", jsonArray);
        jsonResponse.add("separator", new JsonPrimitive(File.separator));
        return jsonResponse.toString();
    }

    private static String getRootsDirectoryResponse() {
        JsonObject jsonResponse = new JsonObject();
        JsonArray jsonArray = new JsonArray();
        for (File file : File.listRoots()) {
            JsonObject directoryGroup = new JsonObject();
            directoryGroup.addProperty("label", file.toString().replace("\\", ""));
            directoryGroup.addProperty("value", file.toString());
            jsonArray.add(directoryGroup);
        }
        jsonResponse.add("children", jsonArray);
        jsonResponse.add("parents", new JsonArray());
        jsonResponse.add("separator", new JsonPrimitive(File.separator));
        return jsonResponse.toString();
    }

    public static String getConfigurationUpdate(String key) {
        if (SettingsApiServlet.haveKey(key)) {
            JsonObject datas = new JsonObject();
            datas.addProperty("action", "set_configuration_changed");
            Configuration configuration = CONFIGURATION.getConfiguration();
            JsonObject jsonObject = new JsonObject();
            if (!configuration.containsKey(key) || !SettingsApiServlet.addPropertyToJsonObject(jsonObject, key, configuration.getProperty(key))) {
                jsonObject.add(key, WEB_SETTINGS_WITH_DEFAULTS.get(key));
            }
            datas.add("value", jsonObject);
            return datas.toString();
        }
        return "";
    }

    private static JsonObject getConfigurationAsJsonObject() {
        Properties userConfiguration = ConfigurationConverter.getProperties(CONFIGURATION.getConfiguration());
        return SettingsApiServlet.getPropertiesAsJsonObject(userConfiguration);
    }

    private static JsonObject getPropertiesAsJsonObject(Properties properties) {
        JsonObject jsonObject = new JsonObject();
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            String strKey = Objects.toString(key);
            SettingsApiServlet.addPropertyToJsonObject(jsonObject, strKey, value);
        }));
        return jsonObject;
    }

    private static boolean addPropertyToJsonObject(JsonObject jsonObject, String key, Object value) {
        String strValue;
        if (SettingsApiServlet.haveKey(key) && (StringUtils.isNotEmpty(strValue = Objects.toString(value)) || SettingsApiServlet.acceptEmptyValueForKey(key))) {
            if (SettingsApiServlet.isSelectKey(key)) {
                jsonObject.addProperty(key, strValue);
            } else if (SettingsApiServlet.isArrayKey(key)) {
                JsonArray array = new JsonArray();
                for (String arrayValue : StringUtils.split(strValue, UmsConfiguration.getListDelimiter())) {
                    array.add(arrayValue);
                }
                jsonObject.add(key, array);
            } else if (strValue.equals("true") || strValue.equals("false")) {
                jsonObject.addProperty(key, Boolean.valueOf(strValue));
            } else if (INT_PATTERN.matcher(strValue).matches()) {
                jsonObject.addProperty(key, Integer.valueOf(strValue));
            } else if (FLOAT_PATTERN.matcher(strValue).matches()) {
                jsonObject.addProperty(key, Float.valueOf(strValue));
            } else {
                jsonObject.addProperty(key, strValue);
            }
            return true;
        }
        return false;
    }
}

