/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonObject;
import com.sun.jna.Platform;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.SQLException;
import net.pms.PMS;
import net.pms.database.MediaDatabase;
import net.pms.iam.Account;
import net.pms.iam.AuthService;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.platform.PlatformUtils;
import net.pms.store.MediaScanner;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="ActionsApiServlet", urlPatterns={"/v1/api/actions"}, displayName="Actions Api Servlet")
public class ActionsApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ActionsApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getPathInfo();
            if (path.equals("/")) {
                boolean canShutdownComputer = !Platform.isLinux() && !Platform.isMac() || PlatformUtils.INSTANCE.isAdmin();
                JsonObject jsonResponse = new JsonObject();
                jsonResponse.addProperty("canShutdownComputer", canShutdownComputer);
                ActionsApiServlet.respond(req, resp, jsonResponse.toString(), 200, "application/json");
            } else {
                LOGGER.trace("ActionsApiServlet request not available : {}", (Object)path);
                ActionsApiServlet.respondNotFound(req, resp);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in ActionsApiServlet: {}", (Object)e.getMessage());
            ActionsApiServlet.respondInternalServerError(req, resp);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block37: {
            try {
                String path = req.getPathInfo();
                if (path == null || path.equals("/")) {
                    Account account = AuthService.getAccountLoggedIn(req);
                    if (account != null) {
                        String operation;
                        JsonObject data = ActionsApiServlet.getJsonObjectFromBody(req);
                        String string = operation = data.has("operation") ? data.get("operation").getAsString() : null;
                        if (operation != null) {
                            switch (operation) {
                                case "Server.Restart": {
                                    if (account.havePermission(0x100000)) {
                                        PMS.get().resetMediaServer();
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Computer.Shutdown": {
                                    if (account.havePermission(0x800000)) {
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        PMS.get().shutdownComputer();
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Server.ResetCache": {
                                    if (account.havePermission(2048)) {
                                        MediaDatabase.initForce();
                                        try {
                                            MediaDatabase.resetCache();
                                        }
                                        catch (SQLException e) {
                                            LOGGER.debug("Error when re-initializing after manual cache reset:", e);
                                        }
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Process.Reboot": {
                                    if (account.havePermission(0x600000)) {
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        ProcessUtil.reboot();
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Process.Reboot.Trace": {
                                    if (account.havePermission(0x600000)) {
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        ProcessUtil.reboot("trace");
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Process.Exit": {
                                    if (account.havePermission(0x400000)) {
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        PMS.quit();
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Server.ScanAllSharedFolders": {
                                    if (account.havePermission(2048)) {
                                        if (!MediaScanner.isMediaScanRunning()) {
                                            MediaScanner.startMediaScan();
                                        }
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "Server.ScanAllSharedFoldersCancel": {
                                    if (account.havePermission(2048)) {
                                        if (MediaScanner.isMediaScanRunning()) {
                                            MediaScanner.stopMediaScan();
                                        }
                                        ActionsApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        break;
                                    }
                                    ActionsApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                default: {
                                    ActionsApiServlet.respondBadRequest(req, resp, "Operation not configured");
                                    break;
                                }
                            }
                            break block37;
                        }
                        ActionsApiServlet.respondBadRequest(req, resp);
                        break block37;
                    }
                    ActionsApiServlet.respondUnauthorized(req, resp);
                    break block37;
                }
                LOGGER.trace("ActionsApiHandler request not available : {}", (Object)path);
                ActionsApiServlet.respondNotFound(req, resp);
            }
            catch (RuntimeException e) {
                LOGGER.error("RuntimeException in ActionsApiHandler: {}", (Object)e.getMessage());
                ActionsApiServlet.respondInternalServerError(req, resp);
            }
        }
    }
}

