/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver.servlets;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.sql.Connection;
import java.util.Base64;
import java.util.List;
import net.pms.database.UserDatabase;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.iam.AuthService;
import net.pms.iam.Group;
import net.pms.iam.User;
import net.pms.image.Image;
import net.pms.image.ImageFormat;
import net.pms.image.ImagesUtil;
import net.pms.network.webguiserver.GuiHttpServlet;
import net.pms.network.webguiserver.WebSocketDispatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(name="AccountApiServlet", urlPatterns={"/v1/api/account"}, displayName="Account Api Servlet")
public class AccountApiServlet
extends GuiHttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountApiServlet.class);

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getPathInfo();
            if (path.equals("/accounts")) {
                Account account = AuthService.getAccountLoggedIn(req);
                if (account != null) {
                    JsonObject jObject = new JsonObject();
                    JsonArray jUsers = new JsonArray();
                    if (account.havePermission(1)) {
                        jObject.add("usersManage", new JsonPrimitive(true));
                        for (User user : AccountService.getAllUsers()) {
                            jUsers.add(AccountApiServlet.userToJsonObject(user));
                        }
                    } else {
                        jObject.add("usersManage", new JsonPrimitive(false));
                        jUsers.add(AccountApiServlet.userToJsonObject(account.getUser()));
                    }
                    jObject.add("users", jUsers);
                    JsonArray jGroups = new JsonArray();
                    if (account.havePermission(3)) {
                        jObject.add("groupsManage", new JsonPrimitive(true));
                        for (Group group : AccountService.getAllGroups()) {
                            jGroups.add(AccountApiServlet.groupToJsonObject(group));
                        }
                    } else {
                        jObject.add("groupsManage", new JsonPrimitive(false));
                        if (account.getGroup().getId() > 0) {
                            jGroups.add(AccountApiServlet.groupToJsonObject(account.getGroup()));
                        }
                    }
                    jObject.add("groups", jGroups);
                    jObject.add("enabled", new JsonPrimitive(AuthService.isEnabled()));
                    jObject.add("localhost", new JsonPrimitive(AuthService.isLocalhostAsAdmin()));
                    AccountApiServlet.respond(req, resp, jObject.toString(), 200, "application/json");
                } else {
                    AccountApiServlet.respondUnauthorized(req, resp);
                }
            } else {
                AccountApiServlet.respondNotFound(req, resp);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in AccountApiServlet: {}", (Object)e.getMessage());
            AccountApiServlet.respondInternalServerError(req, resp);
        }
    }

    @Override
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String path = req.getPathInfo();
            if (path.equals("/action")) {
                Account account = AuthService.getAccountLoggedIn(req);
                if (account != null) {
                    JsonObject action = AccountApiServlet.getJsonObjectFromBody(req);
                    if (action == null || !action.has("operation") || !action.get("operation").isJsonPrimitive()) {
                        AccountApiServlet.respondBadRequest(req, resp);
                        return;
                    }
                    String operation = action.get("operation").getAsString();
                    if (operation != null) {
                        Connection connection = UserDatabase.getConnectionIfAvailable();
                        if (connection != null) {
                            switch (operation) {
                                case "authentication": {
                                    if (action.has("enabled") && account.havePermission(2048)) {
                                        boolean enabled = action.get("enabled").getAsBoolean();
                                        AuthService.setEnabled(enabled);
                                        AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        WebSocketDispatcher.setUpdateAccounts();
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to change authentication service", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "localhost": {
                                    if (action.has("enabled") && account.havePermission(2048)) {
                                        boolean enabled = action.get("enabled").getAsBoolean();
                                        AuthService.setLocalhostAsAdmin(enabled);
                                        AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                        WebSocketDispatcher.setUpdateAccounts();
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to change localhost auto admin", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "changelogin": {
                                    if (action.has("username") && action.has("password")) {
                                        int clUserId = action.has("userid") ? action.get("userid").getAsInt() : account.getUser().getId();
                                        String clUsername = action.get("username").getAsString();
                                        String clPassword = action.get("password").getAsString();
                                        if (clUserId == account.getUser().getId() || account.havePermission(1)) {
                                            AccountService.updateLogin(connection, clUserId, clUsername, clPassword);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            break;
                                        }
                                        LOGGER.trace("User '{}' try to change password for user id: {}", (Object)account.toString(), (Object)clUserId);
                                        AccountApiServlet.respondForbidden(req, resp);
                                        break;
                                    }
                                    AccountApiServlet.respondBadRequest(req, resp);
                                    break;
                                }
                                case "createuser": {
                                    if (account.havePermission(1)) {
                                        if (action.has("username") && action.has("password")) {
                                            String cuUsername = action.get("username").getAsString();
                                            String cuPassword = action.get("password").getAsString();
                                            String cuName = action.has("displayname") ? action.get("displayname").getAsString() : cuUsername;
                                            int cuGroupId = action.has("groupid") ? action.get("groupid").getAsInt() : 0;
                                            if (cuGroupId != 0 && !account.havePermission(2) && cuGroupId != account.getGroup().getId()) {
                                                cuGroupId = 0;
                                            }
                                            AccountService.createUser(connection, cuUsername, cuPassword, cuName, cuGroupId);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            WebSocketDispatcher.setUpdateAccounts();
                                            break;
                                        }
                                        AccountApiServlet.respondBadRequest(req, resp);
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to create a user", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "modifyuser": {
                                    if (action.has("userid")) {
                                        int muUserId = action.get("userid").getAsInt();
                                        if (muUserId == account.getUser().getId() || account.havePermission(1)) {
                                            User muUser = AccountService.getUserById(muUserId);
                                            if (muUser != null) {
                                                String muName = action.has("name") ? action.get("name").getAsString() : muUser.getDisplayName();
                                                int muGroupId = action.has("groupid") ? action.get("groupid").getAsInt() : muUser.getGroupId();
                                                Image muAvatar = null;
                                                if (action.has("avatar")) {
                                                    String muAvatarBase64 = action.get("avatar").getAsString();
                                                    if (muAvatarBase64.contains("data:image") && muAvatarBase64.contains(";base64,")) {
                                                        muAvatarBase64 = muAvatarBase64.substring(muAvatarBase64.indexOf(";base64,") + 8);
                                                        muAvatar = AccountApiServlet.getAvatarFromBase64(muAvatarBase64);
                                                    }
                                                    if (muAvatar == null && !"".equals(muAvatarBase64)) {
                                                        muAvatar = muUser.getAvatar();
                                                    }
                                                } else {
                                                    muAvatar = muUser.getAvatar();
                                                }
                                                String muPinCode = action.has("pincode") ? action.get("pincode").getAsString() : muUser.getPinCode();
                                                boolean muLibraryHidden = action.has("library_hidden") ? action.get("library_hidden").getAsBoolean() : muUser.isLibraryHidden();
                                                if (!account.havePermission(2) && muGroupId != muUser.getGroupId()) {
                                                    if (!muName.equals(muUser.getDisplayName())) {
                                                        muGroupId = muUser.getGroupId();
                                                    } else {
                                                        LOGGER.trace("User '{}' try to modify group of user id: {}", (Object)account.toString(), (Object)muUserId);
                                                        AccountApiServlet.respondForbidden(req, resp);
                                                        UserDatabase.close(connection);
                                                        return;
                                                    }
                                                }
                                                AccountService.updateUser(connection, muUserId, muName, muGroupId, muAvatar, muPinCode, muLibraryHidden);
                                                AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                                WebSocketDispatcher.setRefreshSession(muUserId);
                                                WebSocketDispatcher.setUpdateAccounts();
                                                break;
                                            }
                                            AccountApiServlet.respondBadRequest(req, resp);
                                            break;
                                        }
                                        LOGGER.trace("User '{}' try to modify account of user id {}", (Object)account.toString(), (Object)muUserId);
                                        AccountApiServlet.respondForbidden(req, resp);
                                        break;
                                    }
                                    AccountApiServlet.respondBadRequest(req, resp);
                                    break;
                                }
                                case "deleteuser": {
                                    if (action.has("userid")) {
                                        int duUserId = action.get("userid").getAsInt();
                                        if (account.havePermission(1)) {
                                            AccountService.deleteUser(connection, duUserId);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            WebSocketDispatcher.setRefreshSession(duUserId);
                                            WebSocketDispatcher.setUpdateAccounts();
                                            break;
                                        }
                                        LOGGER.trace("User '{}' try to delete the user with id {}", (Object)account.toString(), (Object)duUserId);
                                        AccountApiServlet.respondForbidden(req, resp);
                                        break;
                                    }
                                    AccountApiServlet.respondBadRequest(req, resp);
                                    break;
                                }
                                case "creategroup": {
                                    if (account.havePermission(2)) {
                                        if (action.has("name")) {
                                            String cgName = action.get("name").getAsString();
                                            AccountService.createGroup(connection, cgName, 0);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            WebSocketDispatcher.setUpdateAccounts();
                                            break;
                                        }
                                        AccountApiServlet.respondBadRequest(req, resp);
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to create a group", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "modifygroup": {
                                    if (account.havePermission(2)) {
                                        if (action.has("groupid") && action.has("name")) {
                                            int mgGroupId = action.get("groupid").getAsInt();
                                            String mgName = action.get("name").getAsString();
                                            List<Integer> userIds = AccountService.getUserIdsForGroup(mgGroupId);
                                            AccountService.updateGroup(connection, mgGroupId, mgName);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            WebSocketDispatcher.setRefreshSessions(userIds);
                                            WebSocketDispatcher.setUpdateAccounts();
                                            break;
                                        }
                                        AccountApiServlet.respondBadRequest(req, resp);
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to modify a group", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "deletegroup": {
                                    if (account.havePermission(2)) {
                                        if (action.has("groupid")) {
                                            int dgGroupId = action.get("groupid").getAsInt();
                                            List<Integer> userIds = AccountService.getUserIdsForGroup(dgGroupId);
                                            AccountService.deleteGroup(connection, dgGroupId);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            WebSocketDispatcher.setRefreshSessions(userIds);
                                            WebSocketDispatcher.setUpdateAccounts();
                                            break;
                                        }
                                        AccountApiServlet.respondBadRequest(req, resp);
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to delete a group", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                case "updatepermission": {
                                    if (account.havePermission(2)) {
                                        if (action.has("groupid") && action.has("permissions")) {
                                            int upGroupId = action.get("groupid").getAsInt();
                                            int upPermissions = action.get("permissions").getAsInt();
                                            List<Integer> userIds = AccountService.getUserIdsForGroup(upGroupId);
                                            AccountService.updatePermissions(connection, upGroupId, upPermissions);
                                            AccountApiServlet.respond(req, resp, "{}", 200, "application/json");
                                            WebSocketDispatcher.setRefreshSessions(userIds);
                                            WebSocketDispatcher.setUpdateAccounts();
                                            break;
                                        }
                                        AccountApiServlet.respondBadRequest(req, resp);
                                        break;
                                    }
                                    LOGGER.trace("User '{}' try to update permissions", (Object)account.toString());
                                    AccountApiServlet.respondForbidden(req, resp);
                                    break;
                                }
                                default: {
                                    AccountApiServlet.respondBadRequest(req, resp, "Operation not configured");
                                }
                            }
                            UserDatabase.close(connection);
                        } else {
                            LOGGER.error("User database not available");
                            AccountApiServlet.respondInternalServerError(req, resp, "User database not available");
                        }
                    } else {
                        AccountApiServlet.respondBadRequest(req, resp);
                    }
                } else {
                    AccountApiServlet.respondUnauthorized(req, resp);
                }
            } else {
                AccountApiServlet.respondNotFound(req, resp);
            }
        }
        catch (RuntimeException e) {
            LOGGER.error("RuntimeException in AccountApiServlet: {}", (Object)e.getMessage());
            AccountApiServlet.respondInternalServerError(req, resp);
        }
    }

    public static JsonObject accountToJsonObject(Account account) {
        JsonElement jElement = GSON.toJsonTree(account);
        JsonObject jAccount = jElement.getAsJsonObject();
        jAccount.getAsJsonObject("user").remove("password");
        return jAccount;
    }

    private static JsonObject userToJsonObject(User user) {
        JsonElement jElement = GSON.toJsonTree(user);
        JsonObject jUser = jElement.getAsJsonObject();
        jUser.remove("password");
        return jUser;
    }

    private static JsonObject groupToJsonObject(Group group) {
        JsonElement jElement = GSON.toJsonTree(group);
        return jElement.getAsJsonObject();
    }

    private static Image getAvatarFromBase64(String imageString) {
        try {
            byte[] avatarBytes = Base64.getDecoder().decode(imageString);
            return Image.toImage(avatarBytes, 640, 480, ImagesUtil.ScaleType.MAX, ImageFormat.JPEG, false);
        }
        catch (IllegalArgumentException e) {
            LOGGER.trace("Avatar seems to not be a valid Base64: {}", e);
        }
        catch (IOException e) {
            LOGGER.trace("Avatar seems to not be a valid image: {}", e);
        }
        return null;
    }
}

