/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import net.pms.network.webguiserver.WebGuiServer;
import net.pms.network.webguiserver.servlets.AboutApiServlet;
import net.pms.network.webguiserver.servlets.AccountApiServlet;
import net.pms.network.webguiserver.servlets.ActionsApiServlet;
import net.pms.network.webguiserver.servlets.AuthApiServlet;
import net.pms.network.webguiserver.servlets.I18nApiServlet;
import net.pms.network.webguiserver.servlets.LogsApiServlet;
import net.pms.network.webguiserver.servlets.PlayerApiServlet;
import net.pms.network.webguiserver.servlets.RenderersApiServlet;
import net.pms.network.webguiserver.servlets.SettingsApiServlet;
import net.pms.network.webguiserver.servlets.SharedContentApiServlet;
import net.pms.network.webguiserver.servlets.WebGuiServlet;
import net.pms.network.webguiserver.servlets.WebSocketServlet;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.servlet.ServletHolder;
import org.eclipse.jetty.ee10.websocket.jakarta.server.config.JakartaWebSocketServletContainerInitializer;
import org.eclipse.jetty.http2.server.HTTP2CServerConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.NetworkConnector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.util.thread.QueuedThreadPool;

public class WebGuiServerJetty
extends WebGuiServer {
    private Server server;

    public WebGuiServerJetty() throws IOException {
        this(-1);
    }

    public WebGuiServerJetty(int port) throws IOException {
        if (port < 0) {
            port = CONFIGURATION.getWebGuiServerPort();
        }
        InetSocketAddress address = new InetSocketAddress(InetAddress.getByName("0.0.0.0"), port);
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("webgui-server");
        this.server = new Server(threadPool);
        ServerConnector connector = new ServerConnector(this.server, new HttpConnectionFactory(), new HTTP2CServerConnectionFactory());
        connector.setHost("0.0.0.0");
        connector.setPort(port);
        connector.setIdleTimeout(0x6DDD00L);
        this.server.addConnector(connector);
        ServletContextHandler servletHandler = new ServletContextHandler(0);
        WebGuiServerJetty.addServlet(servletHandler, AboutApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, AccountApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, ActionsApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, AuthApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, I18nApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, LogsApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, PlayerApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, RenderersApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, SettingsApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, SharedContentApiServlet.class);
        WebGuiServerJetty.addServlet(servletHandler, WebGuiServlet.class);
        JakartaWebSocketServletContainerInitializer.configure(servletHandler, null);
        WebGuiServerJetty.addServlet(servletHandler, WebSocketServlet.class);
        this.server.setHandler(servletHandler);
        try {
            this.start();
        }
        catch (Exception e) {
            LOGGER.error("Failed to start web graphical user interface server ({}) : {}", (Object)address, (Object)e.getMessage());
        }
    }

    @Override
    public Server getServer() {
        return this.server;
    }

    @Override
    public int getPort() {
        NetworkConnector connector = this.getNetworkConnector();
        return connector != null ? connector.getLocalPort() : 0;
    }

    @Override
    public String getAddress() {
        return "localhost:" + this.getPort();
    }

    @Override
    public String getUrl() {
        if (this.server != null) {
            return (this.isSecure() ? "https://" : "http://") + this.getAddress();
        }
        return null;
    }

    @Override
    public boolean isSecure() {
        NetworkConnector connector = this.getNetworkConnector();
        if (connector != null) {
            String protocol = connector.getDefaultConnectionFactory().getProtocol();
            return protocol.startsWith("SSL-") || protocol.equals("SSL");
        }
        return false;
    }

    public final synchronized void start() throws Exception {
        if (this.server != null && !this.server.isStarted() && !this.server.isStarting()) {
            LOGGER.info("Starting Jetty server {}", (Object)Server.getVersion());
            try {
                this.server.start();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't start Jetty server", e);
                throw e;
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.server != null && !this.server.isStopped() && !this.server.isStopping()) {
            LOGGER.info("Stopping Jetty server...");
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't stop Jetty server", e);
            }
        }
    }

    private NetworkConnector getNetworkConnector() {
        for (Connector connector : this.server.getConnectors()) {
            if (!(connector instanceof NetworkConnector)) continue;
            NetworkConnector networkConnector = (NetworkConnector)connector;
            return networkConnector;
        }
        return null;
    }

    public static WebGuiServerJetty createServer(int port) throws IOException {
        LOGGER.debug("Using Jetty as web gui server");
        return new WebGuiServerJetty(port);
    }

    /*
     * WARNING - void declaration
     */
    private static void addServlet(ServletContextHandler servletHandler, Class<? extends HttpServlet> clazz) {
        String[] urlPatterns;
        WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
        String name = webServlet.name();
        if (name == null) {
            name = clazz.getSimpleName();
        }
        if ((urlPatterns = webServlet.urlPatterns()).length == 0) {
            urlPatterns = webServlet.value();
        }
        if (urlPatterns.length > 0) {
            for (String string : urlPatterns) {
                void var8_8;
                if (!"/".equals(string) && !string.endsWith("*")) {
                    void var8_11;
                    if (!string.endsWith("/")) {
                        String string2 = string + "/";
                    }
                    String string3 = (String)var8_11 + "*";
                }
                ServletHolder holder = new ServletHolder(name, clazz);
                servletHandler.addServlet(holder, (String)var8_8);
            }
        } else {
            LOGGER.debug("Servlet '{}' does not include any pattern.", (Object)clazz.getSimpleName());
        }
    }
}

