/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.webguiserver;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.gui.IRendererGuiListener;
import net.pms.network.webguiserver.WebSocketDispatcher;
import net.pms.renderers.Renderer;
import net.pms.renderers.RendererUser;
import net.pms.renderers.devices.players.PlayerState;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.StringUtil;
import net.pms.util.UMSUtils;
import org.apache.commons.lang3.StringUtils;

public class RendererItem
implements IRendererGuiListener {
    private static final HashMap<Renderer, RendererItem> RENDERERS = new HashMap();
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final int MAX_BUFFER_SIZE = CONFIGURATION.getMaxMemoryBufferSize();
    private static final AtomicInteger RENDERER_ID = new AtomicInteger(1);
    private static final Gson GSON = new Gson();
    private static final String ACTION_ADD = "renderer_add";
    private static final String ACTION_DELETE = "renderer_delete";
    private static final String ACTION_UPDATE = "renderer_update";
    private final int id = RENDERER_ID.getAndIncrement();
    private final Renderer renderer;
    private String name;
    private String address;
    private String uuid;
    private String icon;
    private String iconOverlays;
    private String playing;
    private String time;
    private int progressPercent;
    private boolean isActive;
    private boolean isAllowed;
    private boolean isAuthenticated;
    private int userId;
    private int controls;
    private PlayerState state;

    public RendererItem(Renderer value) {
        this.renderer = value;
        this.init();
    }

    @Override
    public void updateRenderer(Renderer value) {
        this.updateRendererValues();
        this.sendRendererAction(ACTION_UPDATE);
    }

    @Override
    public void setActive(boolean active) {
        if (this.isActive != this.renderer.isActive()) {
            this.isActive = this.renderer.isActive();
            this.sendRendererAction(ACTION_UPDATE);
        }
    }

    @Override
    public void setAllowed(boolean allowed) {
        if (this.isAllowed != this.renderer.isAllowed()) {
            this.isAllowed = this.renderer.isAllowed();
            this.sendRendererAction(ACTION_UPDATE);
        }
    }

    @Override
    public void setUserId(int value) {
        if (this.userId != this.renderer.getUserId()) {
            this.userId = this.renderer.getUserId();
            this.sendRendererAction(ACTION_UPDATE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete() {
        this.renderer.removeGuiListener(this);
        HashMap<Renderer, RendererItem> hashMap = RENDERERS;
        synchronized (hashMap) {
            if (RENDERERS.containsKey(this.renderer)) {
                RENDERERS.remove(this.renderer);
            }
        }
        this.sendRendererAction(ACTION_DELETE);
    }

    @Override
    public void refreshPlayerState(PlayerState state) {
        this.state = state;
        this.time = state.isStopped() || StringUtil.isZeroTime(state.getPosition()) ? " " : UMSUtils.playedDurationStr(state.getPosition(), state.getDuration());
        this.progressPercent = (int)(100L * state.getBuffer() / (long)MAX_BUFFER_SIZE);
        this.playing = state.isStopped() || StringUtils.isBlank(state.getName()) ? " " : state.getName();
        this.sendRendererAction(ACTION_UPDATE);
    }

    public String getIcon() {
        return this.icon;
    }

    public JsonObject getInfos() {
        JsonObject result = new JsonObject();
        result.addProperty("title", this.name);
        result.addProperty("isUpnp", this.renderer.isUpnp());
        JsonArray detailsArray = new JsonArray();
        JsonObject entryObject = new JsonObject();
        entryObject.addProperty("key", "confname");
        entryObject.addProperty("value", this.renderer.getConfName());
        detailsArray.add(entryObject);
        if (!this.renderer.isFileless() && this.renderer.getFile() != null) {
            entryObject = new JsonObject();
            entryObject.addProperty("key", "conffile");
            entryObject.addProperty("value", this.renderer.getFile().getName());
            detailsArray.add(entryObject);
        }
        if (this.renderer.isUpnp()) {
            Map<String, String> details = this.renderer.getDetails();
            for (Map.Entry<String, String> entry : details.entrySet()) {
                entryObject = new JsonObject();
                entryObject.addProperty("key", entry.getKey());
                entryObject.addProperty("value", entry.getValue());
                detailsArray.add(entryObject);
            }
            entryObject = new JsonObject();
            entryObject.addProperty("key", "Services");
            entryObject.addProperty("value", StringUtils.join(this.renderer.getUpnpServices(), ", "));
            detailsArray.add(entryObject);
        } else {
            entryObject = new JsonObject();
            entryObject.addProperty("key", "i18n@Name");
            entryObject.addProperty("value", this.name);
            detailsArray.add(entryObject);
            result.addProperty("i18n@Name", this.name);
            if (!"".equals(this.address)) {
                entryObject = new JsonObject();
                entryObject.addProperty("key", "i18n@Address");
                entryObject.addProperty("value", this.address);
                detailsArray.add(entryObject);
            }
            if (this.renderer.getIdentifiers() != null) {
                for (String identifier : this.renderer.getIdentifiers()) {
                    entryObject = new JsonObject();
                    entryObject.addProperty("key", "");
                    entryObject.addProperty("value", identifier);
                    detailsArray.add(entryObject);
                }
            }
        }
        result.add("details", detailsArray);
        return result;
    }

    private void init() {
        this.updateRendererValues();
        this.playing = "";
        this.progressPercent = 0;
        this.renderer.addGuiListener(this);
        this.sendRendererAction(ACTION_ADD);
    }

    private void updateRendererValues() {
        this.name = this.renderer.getRendererName();
        this.address = this.renderer.getAddress() != null ? this.renderer.getAddress().getHostAddress() : "";
        this.uuid = this.renderer.getUUID() != null ? this.renderer.getUUID() : "";
        this.icon = this.renderer.getRendererIcon();
        this.iconOverlays = this.renderer.getRendererIconOverlays();
        this.isActive = this.renderer.isActive();
        this.isAllowed = this.renderer.isAllowed();
        this.isAuthenticated = this.renderer.isAuthenticated();
        this.userId = RendererUser.getUserId(this.uuid);
        this.controls = this.renderer.getControls();
        this.state = this.renderer.getPlayer().getState();
    }

    private void playerBack() {
        this.renderer.getPlayer().rewind();
    }

    private void playerPrev() {
        this.renderer.getPlayer().prev();
    }

    private void playerPlay() {
        this.renderer.getPlayer().play();
    }

    private void playerPause() {
        this.renderer.getPlayer().pause();
    }

    private void playerStop() {
        this.renderer.getPlayer().stop();
    }

    private void playerNext() {
        this.renderer.getPlayer().next();
    }

    private void playerForward() {
        this.renderer.getPlayer().forward();
    }

    private void playerMute() {
        this.renderer.getPlayer().mute();
    }

    private void playerSetVolume(int volume) {
        this.renderer.getPlayer().setVolume(volume);
    }

    private void playerSetMediaId(String id) {
        StoreResource storeResource;
        List<StoreResource> resources = this.renderer.getMediaStore().getResources(id, false);
        if (!resources.isEmpty() && (storeResource = resources.get(0)) instanceof StoreItem) {
            StoreItem item = (StoreItem)storeResource;
            this.renderer.getPlayer().setURI(item.getMediaURL("", true), null);
        }
    }

    private JsonObject toJsonObject() {
        JsonObject result = new JsonObject();
        result.addProperty("id", this.id);
        result.addProperty("name", this.name);
        result.addProperty("address", this.address);
        result.addProperty("uuid", this.uuid);
        result.addProperty("icon", this.icon);
        result.addProperty("iconOverlays", this.iconOverlays);
        result.addProperty("playing", this.playing);
        result.addProperty("time", this.time);
        result.addProperty("progressPercent", this.progressPercent);
        result.addProperty("userId", this.userId);
        result.add("state", GSON.toJsonTree(this.state));
        if (this.renderer != null) {
            result.addProperty("isActive", this.renderer.isActive());
            result.addProperty("isAllowed", this.renderer.isAllowed());
            result.addProperty("isAuthenticated", this.renderer.isAuthenticated());
            result.addProperty("controls", this.renderer.getControls());
        } else {
            result.addProperty("isActive", this.isActive);
            result.addProperty("isAllowed", this.isAllowed);
            result.addProperty("isAuthenticated", this.isAuthenticated);
            result.addProperty("controls", this.controls);
        }
        return result;
    }

    private void sendRendererAction(String action) {
        if (WebSocketDispatcher.hasHomeSession()) {
            JsonObject result = new JsonObject();
            result.addProperty("action", action);
            result.add("data", this.toJsonObject());
            WebSocketDispatcher.broadcastHomeMessage(result.toString());
        }
    }

    public static boolean remoteControlRenderer(JsonObject post) {
        if (post != null && post.has("id") && post.has("action")) {
            String action;
            int rId = post.get("id").getAsInt();
            RendererItem renderer = RendererItem.getRenderer(rId);
            if (renderer == null) {
                return false;
            }
            switch (action = post.get("action").getAsString()) {
                case "back": {
                    renderer.playerBack();
                    return true;
                }
                case "prev": {
                    renderer.playerPrev();
                    return true;
                }
                case "play": {
                    renderer.playerPlay();
                    return true;
                }
                case "pause": {
                    renderer.playerPause();
                    return true;
                }
                case "stop": {
                    renderer.playerStop();
                    return true;
                }
                case "next": {
                    renderer.playerNext();
                    return true;
                }
                case "forward": {
                    renderer.playerForward();
                    return true;
                }
                case "volume": {
                    int volume = post.get("value").getAsInt();
                    renderer.playerSetVolume(volume);
                    return true;
                }
                case "mute": {
                    renderer.playerMute();
                    return true;
                }
                case "mediaid": {
                    String id = post.get("value").getAsString();
                    renderer.playerSetMediaId(id);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static JsonObject getRemoteControlBrowse(JsonObject post) {
        if (post != null && post.has("id") && post.has("media")) {
            int rId = post.get("id").getAsInt();
            RendererItem renderer = RendererItem.getRenderer(rId);
            if (renderer == null) {
                return null;
            }
            String media = post.get("media").getAsString();
            JsonObject result = new JsonObject();
            JsonArray parents = new JsonArray();
            JsonArray childrens = new JsonArray();
            List<StoreResource> resources = renderer.renderer.getMediaStore().getResources(media, true);
            if (!resources.isEmpty()) {
                StoreContainer parentFromResources = resources.get(0).getParent();
                if (parentFromResources != null && ((StoreResource)parentFromResources).isFolder() && !"0".equals(parentFromResources.getResourceId())) {
                    JsonObject parent = new JsonObject();
                    parent.addProperty("value", parentFromResources.getResourceId());
                    parent.addProperty("label", ((StoreResource)parentFromResources).getName());
                    parents.add(parent);
                    parentFromResources = parentFromResources.getParent();
                    if (parentFromResources != null && ((StoreResource)parentFromResources).isFolder() && !"0".equals(parentFromResources.getResourceId())) {
                        parent = new JsonObject();
                        parent.addProperty("value", parentFromResources.getResourceId());
                        parent.addProperty("label", ((StoreResource)parentFromResources).getName());
                        parents.add(parent);
                    }
                }
                for (StoreResource resource : resources) {
                    if (resource == null) continue;
                    JsonObject children = new JsonObject();
                    children.addProperty("value", resource.getResourceId());
                    children.addProperty("label", resource.getName());
                    children.addProperty("browsable", resource.isFolder());
                    childrens.add(children);
                }
            }
            result.add("parents", parents);
            result.add("childrens", childrens);
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRenderer(Renderer renderer) {
        HashMap<Renderer, RendererItem> hashMap = RENDERERS;
        synchronized (hashMap) {
            if (!RENDERERS.containsKey(renderer)) {
                RENDERERS.put(renderer, new RendererItem(renderer));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonArray getRenderersAsJsonArray() {
        JsonArray result = new JsonArray();
        HashMap<Renderer, RendererItem> hashMap = RENDERERS;
        synchronized (hashMap) {
            for (RendererItem renderer : RENDERERS.values()) {
                result.add(renderer.toJsonObject());
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RendererItem getRenderer(long id) {
        HashMap<Renderer, RendererItem> hashMap = RENDERERS;
        synchronized (hashMap) {
            for (RendererItem renderer : RENDERERS.values()) {
                if ((long)renderer.id != id) continue;
                return renderer;
            }
        }
        return null;
    }
}

