/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.updateobject;

import net.pms.network.mediaserver.jupnp.support.contentdirectory.updateobject.BaseUpdateObjectHandler;
import net.pms.store.StoreResource;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.store.container.PlaylistFolder;
import net.pms.store.item.WebStream;
import org.jupnp.support.contentdirectory.ContentDirectoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NodeList;

public class AlbumArtUriHandler
extends BaseUpdateObjectHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlbumArtUriHandler.class.getName());

    public AlbumArtUriHandler(StoreResource objectResource, NodeList currentTagValue, NodeList newTagValue) {
        super(objectResource, currentTagValue, newTagValue);
    }

    @Override
    public void handle() throws ContentDirectoryException {
        LOGGER.debug("UpdateObject : AlbumArtURI ... ");
        try {
            String currentValue = this.getNodeTextValue(this.getCurrentTagValue(), 0);
            String newValue = this.getNodeTextValue(this.getNewTagValue(), 0);
            if (!this.isModelValueEqual(currentValue)) {
                throw new ContentDirectoryException(702, "UpdateObject() failed because upnp:albumArtURI value listed in the CurrentTagValue argument do not match the current state of the ContentDirectory service. The specified data is likely out of date.");
            }
            ThumbnailStore.updateThumbnailByURI(newValue, this.getObjectResource().getFileName(), ThumbnailSource.USER);
            StoreResource storeResource = this.getObjectResource();
            if (storeResource instanceof WebStream) {
                WebStream ws = (WebStream)storeResource;
                storeResource = this.getObjectResource().getParent();
                if (storeResource instanceof PlaylistFolder) {
                    PlaylistFolder pls = (PlaylistFolder)storeResource;
                    pls.updateAlbumArtUriDirective(ws.getUrl(), newValue);
                }
            }
        }
        catch (Exception e) {
            LOGGER.debug("UpdateObject : failed", e);
        }
    }

    private boolean isModelValueEqual(String currentValue) {
        return true;
    }
}

