/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.jupnp.support.contentdirectory.result;

import com.google.common.primitives.UnsignedInteger;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAImageResElement;
import net.pms.encoders.EncodingFormat;
import net.pms.formats.Format;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.media.MediaStatus;
import net.pms.media.MediaType;
import net.pms.media.audio.MediaAudio;
import net.pms.media.audio.metadata.MediaAudioMetadata;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.network.mediaserver.MediaServer;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.DlnaHelper;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dc.DC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.BaseObject;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Desc;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.Res;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.Container;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MusicAlbum;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MusicArtist;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.MusicGenre;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.PlaylistContainer;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.container.StorageFolder;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Item;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Movie;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.MusicTrack;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.Photo;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.didl_lite.item.VideoItem;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.dlna.DlnaProtocolInfo;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.pv.PV;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.sec.SEC;
import net.pms.network.mediaserver.jupnp.support.contentdirectory.result.namespace.upnp.UPNP;
import net.pms.renderers.Renderer;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreContainer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.store.container.DVDISOFile;
import net.pms.store.container.PlaylistFolder;
import net.pms.store.container.RealFolder;
import net.pms.store.container.VirtualFolderDbId;
import net.pms.store.item.RealFile;
import net.pms.util.FullyPlayed;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.support.model.Protocol;
import org.jupnp.support.model.ProtocolInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreResourceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreResourceHelper.class);
    private static final SimpleDateFormat DIDL_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.US);

    private StoreResourceHelper() {
    }

    public static final BaseObject getBaseObject(StoreResource resource, String filter) {
        try {
            if (resource instanceof StoreContainer) {
                StoreContainer container = (StoreContainer)resource;
                return StoreResourceHelper.getContainer(container, filter);
            }
            if (resource instanceof StoreItem) {
                StoreItem item = (StoreItem)resource;
                return StoreResourceHelper.getItem(item, filter);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("", ex);
        }
        return null;
    }

    public static final Container getContainer(StoreContainer container, String filter) {
        BaseObject result;
        block26: {
            MediaType mediaType;
            block25: {
                RealFolder realfolder;
                Renderer renderer = container.getDefaultRenderer();
                MediaInfo mediaInfo = container.getMediaInfo();
                mediaType = mediaInfo != null ? mediaInfo.getMediaType() : MediaType.UNKNOWN;
                boolean xbox360 = renderer.isXbox360();
                Object resourceId = container.getResourceId();
                result = null;
                if (xbox360 && container.getFakeParentId() != null) {
                    switch (container.getFakeParentId()) {
                        case "7": {
                            BaseObject baseObject = new MusicAlbum();
                            break;
                        }
                        case "6": {
                            BaseObject baseObject = new MusicArtist();
                            break;
                        }
                        case "5": {
                            BaseObject baseObject = new MusicGenre();
                            break;
                        }
                        case "F": {
                            BaseObject baseObject = new PlaylistContainer();
                            break;
                        }
                        default: {
                            BaseObject baseObject = result = null;
                        }
                    }
                }
                if (result == null) {
                    if (container instanceof PlaylistFolder) {
                        result = new PlaylistContainer();
                    } else if (container instanceof VirtualFolderDbId) {
                        VirtualFolderDbId virtualFolderDbId = (VirtualFolderDbId)container;
                        result = StoreResourceHelper.newContainerFromUpnpClass(virtualFolderDbId.getMediaTypeUclass());
                    } else {
                        result = new StorageFolder();
                    }
                }
                if (xbox360) {
                    resourceId = (String)resourceId + "$";
                }
                result.setId((String)resourceId);
                if (!container.isDiscovered() && container.childrenCount() == 0) {
                    ((Container)result).setChildCount(1L);
                } else {
                    ((Container)result).setChildCount(Long.valueOf(container.childrenCount()));
                }
                resourceId = container.getParentId();
                if (xbox360 && container.getFakeParentId() == null) {
                    resourceId = (String)resourceId + "$";
                }
                result.setParentID((String)resourceId);
                result.setRestricted(true);
                String title = container.getDisplayName(false);
                if (!renderer.isThumbnails() && container instanceof RealFolder && (realfolder = (RealFolder)container).isFullyPlayedMark()) {
                    title = FullyPlayed.addFullyPlayedNamePrefix(title, container);
                }
                result.setTitle(renderer.getDcTitle(title, container.getDisplayNameSuffix(), container));
                if (!renderer.isSendFolderThumbnails() && !(container instanceof DVDISOFile)) break block25;
                for (DLNAImageResElement resElement : StoreResourceHelper.getThumbnailResElements(container, mediaType)) {
                    UPNP.AlbumArtURI albumArtURI;
                    result.addResource(StoreResourceHelper.getImageRes(container, resElement));
                    if (!renderer.needAlbumArtHack() && !(result instanceof MusicAlbum) || (albumArtURI = StoreResourceHelper.getAlbumArtURI((StoreResource)container, resElement)) == null) continue;
                    result.addProperty(albumArtURI);
                }
                break block26;
            }
            if (!(result instanceof MusicAlbum)) break block26;
            for (DLNAImageResElement resElement : StoreResourceHelper.getThumbnailResElements(container, mediaType)) {
                UPNP.AlbumArtURI albumArtURI = StoreResourceHelper.getAlbumArtURI((StoreResource)container, resElement);
                if (albumArtURI == null) continue;
                result.addProperty(albumArtURI);
            }
        }
        return result;
    }

    public static final Item getItem(StoreItem item, String filter) {
        MusicTrack musicTrack;
        RealFile realfile;
        Object title;
        MediaAudioMetadata audioMetadata;
        String updateId;
        Renderer renderer = item.getDefaultRenderer();
        boolean isTrancoded = item.isTranscoded();
        MediaInfo mediaInfo = item.getMediaInfo();
        MediaStatus mediaStatus = item.getMediaStatus();
        MediaSubtitle mediaSubtitle = item.getMediaSubtitle();
        Format format = item.getFormat();
        MediaType mediaType = mediaInfo != null ? mediaInfo.getMediaType() : MediaType.UNKNOWN;
        EncodingFormat encodingFormat = isTrancoded ? item.getTranscodingSettings().getEncodingFormat() : null;
        boolean subsAreValidForStreaming = false;
        boolean xbox360 = renderer.isXbox360();
        Item result = item.getPrimaryResource() != null && mediaInfo != null && !mediaInfo.isSecondaryFormatValid() ? new Item() : (mediaType == MediaType.IMAGE || mediaType == MediaType.UNKNOWN && format != null && format.isImage() ? new Photo() : (mediaType == MediaType.AUDIO || mediaType == MediaType.UNKNOWN && format != null && format.isAudio() ? new MusicTrack() : (mediaInfo != null && mediaInfo.hasVideoMetadata() && (mediaInfo.getVideoMetadata().isTvEpisode() || mediaInfo.getVideoMetadata().getYear() != null) ? new Movie() : new VideoItem())));
        if (mediaInfo != null && mediaInfo.isVideo() && mediaSubtitle != null) {
            if (!renderer.getUmsConfiguration().isDisableSubtitles() && (!isTrancoded || renderer.streamSubsForTranscodedVideo()) && mediaSubtitle.isExternal() && renderer.isExternalSubtitlesFormatSupported(mediaSubtitle, item)) {
                subsAreValidForStreaming = true;
                LOGGER.trace("External subtitles \"{}\" can be streamed to {}", (Object)mediaSubtitle.getName(), (Object)renderer);
            } else if (LOGGER.isTraceEnabled()) {
                if (renderer.getUmsConfiguration().isDisableSubtitles()) {
                    LOGGER.trace("Subtitles are disabled");
                } else if (mediaSubtitle.isEmbedded()) {
                    LOGGER.trace("Subtitles track {} cannot be streamed because it is internal/embedded", (Object)mediaSubtitle.getId());
                } else if (isTrancoded && !renderer.streamSubsForTranscodedVideo()) {
                    LOGGER.trace("Subtitles \"{}\" aren't supported while transcoding to {}", (Object)mediaSubtitle.getName(), (Object)renderer);
                } else {
                    LOGGER.trace("Subtitles \"{}\" aren't valid for streaming to {}", (Object)mediaSubtitle.getName(), (Object)renderer);
                }
            }
        }
        Object resourceId = item.getResourceId();
        if (xbox360) {
            resourceId = (String)resourceId + "$";
        }
        if (renderer.needVersionedObjectId() && (updateId = MediaStoreIds.getObjectUpdateIdAsString(item.getLongId())) != null) {
            resourceId = (String)resourceId + "#" + updateId;
        }
        result.setId((String)resourceId);
        resourceId = item.getParentId();
        if (xbox360 && item.getFakeParentId() == null) {
            resourceId = (String)resourceId + "$";
        }
        result.setParentID((String)resourceId);
        result.setRestricted(true);
        MediaAudioMetadata mediaAudioMetadata = audioMetadata = mediaInfo != null ? mediaInfo.getAudioMetadata() : null;
        if (audioMetadata != null && mediaInfo != null && mediaInfo.isAudio() && StringUtils.isNotBlank(audioMetadata.getSongname())) {
            title = "";
            if (renderer.isPrependTrackNumbers() && audioMetadata.getTrack() > 0) {
                title = (String)title + String.format("%03d - ", audioMetadata.getTrack());
            }
            title = (String)title + audioMetadata.getSongname();
        } else {
            title = subsAreValidForStreaming ? item.getDisplayName(false) : renderer.getUseSameExtension(item.getDisplayName(false));
        }
        if (!renderer.isThumbnails() && item instanceof RealFile && (realfile = (RealFile)item).isFullyPlayedMark()) {
            title = FullyPlayed.addFullyPlayedNamePrefix((String)title, item);
        }
        title = item.resumeStr((String)title);
        result.setTitle(renderer.getDcTitle((String)title, item.getDisplayNameSuffix(), item));
        if (renderer.isSamsung() && item instanceof RealFile && item.getMediaStatus() != null) {
            LOGGER.debug("Setting bookmark for {} => {}", title, (Object)item.getMediaStatus().getBookmark());
            result.addProperty(new SEC.DcmInfo(String.format("CREATIONDATE=0,FOLDER=%s,BM=%d", title, item.getMediaStatus().getBookmark())));
        }
        if (audioMetadata != null && renderer.isSendDateMetadataYearForAudioTags() && audioMetadata.getYear() > 1000 && result instanceof MusicTrack) {
            musicTrack = (MusicTrack)result;
            musicTrack.setDate(Integer.toString(audioMetadata.getYear()));
        } else if (item.getLastModified() > 0L && renderer.isSendDateMetadata()) {
            result.getProperties().set(new DC.Date(StoreResourceHelper.formatDate(new Date(item.getLastModified()))));
        }
        if (mediaInfo != null && audioMetadata != null && result instanceof MusicTrack) {
            musicTrack = (MusicTrack)result;
            if (StringUtils.isNotBlank(audioMetadata.getAlbum())) {
                musicTrack.setAlbum(audioMetadata.getAlbum());
            }
            if (StringUtils.isNotBlank(audioMetadata.getArtist())) {
                musicTrack.setCreator(audioMetadata.getArtist());
                musicTrack.addArtist(new UPNP.Artist(audioMetadata.getArtist()));
            }
            if (StringUtils.isNotBlank(audioMetadata.getComposer())) {
                musicTrack.addArtist(new UPNP.Artist(audioMetadata.getComposer(), "Composer"));
            }
            if (StringUtils.isNotBlank(audioMetadata.getConductor())) {
                musicTrack.addArtist(new UPNP.Artist(audioMetadata.getConductor(), "Conductor"));
            }
            if (StringUtils.isNotBlank(audioMetadata.getGenre())) {
                musicTrack.setGenres(new String[]{audioMetadata.getGenre()});
            }
            if (audioMetadata.getTrack() > 0) {
                musicTrack.setOriginalTrackNumber(audioMetadata.getTrack());
            }
            if (audioMetadata.getRating() != null) {
                result.addProperty(new UPNP.Rating(audioMetadata.getRating().toString()));
            }
        }
        if (mediaInfo != null && mediaInfo.hasVideoMetadata() && result instanceof Movie) {
            Movie movie = (Movie)result;
            MediaVideoMetadata videoMetadata = mediaInfo.getVideoMetadata();
            if (videoMetadata.isTvEpisode()) {
                if (videoMetadata.getTvSeason() != null) {
                    movie.setEpisodeSeason(UnsignedInteger.valueOf(videoMetadata.getTvSeason().intValue()));
                }
                if (StringUtils.isNotBlank(videoMetadata.getTvEpisodeNumber())) {
                    movie.setEpisodeNumber(UnsignedInteger.valueOf(videoMetadata.getTvEpisodeNumber()));
                }
                if (StringUtils.isNotBlank(videoMetadata.getTvSeriesTitle())) {
                    movie.setSeriesTitle(videoMetadata.getTvSeriesTitle());
                }
                if (StringUtils.isNotBlank(videoMetadata.getTvEpisodeName())) {
                    movie.setProgramTitle(videoMetadata.getTvEpisodeName());
                }
            }
            if (mediaStatus != null) {
                movie.setPlaybackCount(mediaStatus.getPlaybackCount());
                if (StringUtils.isNotBlank(mediaStatus.getLastPlaybackTime())) {
                    movie.setLastPlaybackTime(mediaStatus.getLastPlaybackTime());
                }
                if (StringUtils.isNotBlank(mediaStatus.getLastPlaybackPositionForUPnP())) {
                    movie.setLastPlaybackPosition(mediaStatus.getLastPlaybackPositionForUPnP());
                }
            }
        }
        if (mediaType != MediaType.IMAGE) {
            int indexCount = 1;
            if (renderer.isDLNALocalizationRequired()) {
                indexCount = DlnaHelper.getDlnaLocalesCount();
            }
            for (int localizationValue = 0; localizationValue < indexCount; ++localizationValue) {
                Res res = new Res();
                DlnaProtocolInfo protocolInfo = new DlnaProtocolInfo();
                protocolInfo.setProtocol(Protocol.HTTP_GET);
                protocolInfo.setContentFormat(item.getRendererMimeType());
                if (renderer.isSendDLNAOrgFlags()) {
                    String additionalInfo = DlnaHelper.getDlnaAdditionalInfo(item, localizationValue);
                    protocolInfo.setAdditionalInfo(additionalInfo);
                }
                res.setProtocolInfo(protocolInfo);
                if (subsAreValidForStreaming && mediaSubtitle != null && renderer.offerSubtitlesByProtocolInfo() && !renderer.useClosedCaption()) {
                    res.getDependentProperties().add(new PV.SubtitleFileType(mediaSubtitle.getType().getExtension().toUpperCase()));
                    res.getDependentProperties().add(new PV.SubtitleFileUri(item.getSubsURL(mediaSubtitle)));
                }
                if (renderer.getUmsConfiguration().isUpnpCdsWrite() && renderer.getUmsConfiguration().isAnonymousDevicesWrite() && (item.getRendererMimeType().toLowerCase().startsWith("audio") || item.getRendererMimeType().toLowerCase().startsWith("video"))) {
                    String url = MediaServer.getURL() + "/import?id=" + item.getId();
                    res.getDependentProperties().add(new Res.ImportUri(URI.create(url)));
                }
                if (format != null && format.isVideo() && mediaInfo != null && mediaInfo.isMediaParsed()) {
                    MediaVideo defaultVideoTrack = mediaInfo.getDefaultVideoTrack();
                    MediaAudio defaultAudioTrack = mediaInfo.getDefaultAudioTrack();
                    long transcodedSize = renderer.getTranscodedSize();
                    if (!isTrancoded) {
                        res.setSize(mediaInfo.getSize());
                    } else if (transcodedSize != 0L) {
                        res.setSize(transcodedSize);
                    }
                    if (mediaInfo.getDuration() != null) {
                        if (item.isResume()) {
                            long offset = item.getResume().getTimeOffset() / 1000L;
                            double duration = mediaInfo.getDuration() - (double)offset;
                            res.setDuration(StringUtil.formatDLNADuration(duration));
                        } else if (item.getSplitRange().isEndLimitAvailable()) {
                            res.setDuration(StringUtil.formatDLNADuration(item.getSplitRange().getDuration()));
                        } else {
                            res.setDuration(mediaInfo.getDurationString());
                        }
                    }
                    if (defaultVideoTrack != null && defaultVideoTrack.getResolution() != null) {
                        if (isTrancoded && (renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding())) {
                            res.setResolution(item.getResolutionForKeepAR(defaultVideoTrack.getWidth(), defaultVideoTrack.getHeight()));
                        } else {
                            res.setResolution(defaultVideoTrack.getResolution());
                        }
                    }
                    if (mediaInfo.getFrameRate() != null) {
                        res.setFramerate(mediaInfo.getFrameRate().toString());
                    }
                    res.setBitrate(mediaInfo.getRealVideoBitrate());
                    if (defaultAudioTrack != null) {
                        if (defaultAudioTrack.getNumberOfChannels() > 0) {
                            if (!isTrancoded) {
                                res.setNrAudioChannels(defaultAudioTrack.getNumberOfChannels());
                            } else {
                                res.setNrAudioChannels(renderer.getUmsConfiguration().getAudioChannelCount());
                            }
                        }
                        if (defaultAudioTrack.getSampleRate() > 1) {
                            res.setSampleFrequency(defaultAudioTrack.getSampleRate());
                        }
                    }
                    if (defaultVideoTrack != null && defaultVideoTrack.getBitDepth() > 0) {
                        res.setColorDepth(defaultVideoTrack.getBitDepth());
                    }
                } else if (format != null && format.isImage()) {
                    if (mediaInfo != null && mediaInfo.isMediaParsed()) {
                        res.setSize(mediaInfo.getSize());
                        if (mediaInfo.getImageInfo() != null && mediaInfo.getImageInfo().getResolution() != null) {
                            res.setResolution(mediaInfo.getImageInfo().getResolution());
                        }
                    } else {
                        res.setSize(item.length());
                    }
                } else if (format != null && format.isAudio()) {
                    if (mediaInfo != null && mediaInfo.isMediaParsed()) {
                        MediaAudio defaultAudioTrack = mediaInfo.getDefaultAudioTrack();
                        if (mediaInfo.getBitRate() > 0) {
                            res.setBitrate(mediaInfo.getBitRate());
                        }
                        if (mediaInfo.getDuration() != null && mediaInfo.getDuration() != 0.0) {
                            res.setDuration(StringUtil.formatDLNADuration(mediaInfo.getDuration()));
                        }
                        int transcodeFrequency = -1;
                        int transcodeNumberOfChannels = -1;
                        if (defaultAudioTrack != null) {
                            if (!isTrancoded) {
                                if (defaultAudioTrack.getSampleRate() > 1) {
                                    res.setSampleFrequency(defaultAudioTrack.getSampleRate());
                                }
                                if (defaultAudioTrack.getNumberOfChannels() > 0) {
                                    res.setNrAudioChannels(defaultAudioTrack.getNumberOfChannels());
                                }
                            } else {
                                if (renderer.getUmsConfiguration().isAudioResample()) {
                                    transcodeFrequency = renderer.isTranscodeAudioTo441() ? 44100 : 48000;
                                    transcodeNumberOfChannels = 2;
                                } else {
                                    transcodeFrequency = defaultAudioTrack.getSampleRate();
                                    transcodeNumberOfChannels = defaultAudioTrack.getNumberOfChannels();
                                }
                                if (transcodeFrequency > 0) {
                                    res.setSampleFrequency(transcodeFrequency);
                                }
                                if (transcodeNumberOfChannels > 0) {
                                    res.setNrAudioChannels(transcodeNumberOfChannels);
                                }
                            }
                            res.setBitsPerSample(defaultAudioTrack.getBitDepth());
                        }
                        if (!isTrancoded) {
                            if (mediaInfo.getSize() != 0L) {
                                res.setSize(mediaInfo.getSize());
                            }
                        } else if (defaultAudioTrack != null && mediaInfo.getDurationInSeconds() > 0.0 && transcodeFrequency > 0 && transcodeNumberOfChannels > 0) {
                            int finalSize = (int)(mediaInfo.getDurationInSeconds() * (double)transcodeFrequency * 2.0 * (double)transcodeNumberOfChannels);
                            LOGGER.trace("Calculated transcoded size for {}: {}", (Object)item.getFileName(), (Object)finalSize);
                            res.setSize(finalSize);
                        } else if (mediaInfo.getSize() > 0L) {
                            LOGGER.trace("Could not calculate transcoded size for {}, using file size: {}", (Object)item.getFileName(), (Object)mediaInfo.getSize());
                            res.setSize(mediaInfo.getSize());
                        }
                    } else {
                        res.setSize(item.length());
                    }
                } else {
                    res.setSize(0x7FFFFFFF7FFFFFFFL);
                    res.setDuration("09:59:59");
                    res.setBitrate(1000000);
                }
                String transcodedExtension = "";
                if (encodingFormat != null && mediaInfo != null) {
                    if (mediaInfo.isVideo()) {
                        transcodedExtension = renderer.getCustomFFmpegOptions().contains("-f avi") ? "_transcoded_to.avi" : (renderer.getCustomFFmpegOptions().contains("-f flv") ? "_transcoded_to.flv" : (renderer.getCustomFFmpegOptions().contains("-f matroska") ? "_transcoded_to.mkv" : (renderer.getCustomFFmpegOptions().contains("-f mov") ? "_transcoded_to.mov" : (renderer.getCustomFFmpegOptions().contains("-f webm") ? "_transcoded_to.webm" : (encodingFormat.isTranscodeToHLS() ? "_transcoded_to.m3u8" : (encodingFormat.isTranscodeToMPEGTS() ? "_transcoded_to.ts" : (encodingFormat.isTranscodeToMP4() ? "_transcoded_to.mp4" : (encodingFormat.isTranscodeToWMV() && !xbox360 ? "_transcoded_to.wmv" : "_transcoded_to.mpg"))))))));
                    } else if (mediaInfo.isAudio()) {
                        transcodedExtension = renderer.getCustomFFmpegAudioOptions().contains("-f mp3") ? "_transcoded_to.mp3" : (renderer.getCustomFFmpegAudioOptions().contains("-f wav") ? "_transcoded_to.wav" : (renderer.getCustomFFmpegAudioOptions().contains("-f s16be") ? "_transcoded_to.pcm" : (encodingFormat.isTranscodeToMP3() ? "_transcoded_to.mp3" : (encodingFormat.isTranscodeToWAV() ? "_transcoded_to.wav" : "_transcoded_to.pcm"))));
                    }
                }
                res.setValue(URI.create(item.getMediaURL() + transcodedExtension));
                result.addResource(res);
            }
            if (mediaInfo != null && audioMetadata != null && mediaInfo.isAudio()) {
                Desc desc = new Desc("http://ums/tags");
                desc.setId("2");
                desc.setType("ums-tags");
                desc.addMetadata("musicbrainztrackid", audioMetadata.getMbidTrack());
                desc.addMetadata("musicbrainzreleaseid", audioMetadata.getMbidRecord());
                desc.addMetadata("resourceid", mediaInfo.getResourceId());
                if (audioMetadata.getDisc() > 0) {
                    desc.addMetadata("numberOfThisDisc", Integer.toString(audioMetadata.getDisc()));
                }
                if (audioMetadata.getRating() != null) {
                    desc.addMetadata("rating", Integer.toString(audioMetadata.getRating()));
                }
                result.addDescription(desc);
            }
            for (DLNAImageResElement resElement : StoreResourceHelper.getThumbnailResElements(item, mediaType)) {
                UPNP.AlbumArtURI albumArtURI;
                result.addResource(StoreResourceHelper.getImageRes(item, resElement));
                if (!renderer.needAlbumArtHack() || (albumArtURI = StoreResourceHelper.getAlbumArtURI((StoreResource)item, resElement)) == null) continue;
                result.addProperty(albumArtURI);
            }
        } else {
            for (DLNAImageResElement resElement : StoreResourceHelper.getImageResElements(item)) {
                UPNP.AlbumArtURI albumArtURI;
                result.addResource(StoreResourceHelper.getImageRes(item, resElement));
                if (!renderer.needAlbumArtHack() || (albumArtURI = StoreResourceHelper.getAlbumArtURI((StoreResource)item, resElement)) == null) continue;
                result.addProperty(albumArtURI);
            }
        }
        return result;
    }

    private static List<DLNAImageResElement> getImageResElements(StoreResource resource) {
        Renderer renderer = resource.getDefaultRenderer();
        MediaInfo mediaInfo = resource.getMediaInfo();
        ImageInfo imageInfo = mediaInfo != null ? mediaInfo.getImageInfo() : null;
        ImageInfo thumbnailImageInf = null;
        if (resource.getThumbnailImageInfo() != null) {
            thumbnailImageInf = resource.getThumbnailImageInfo();
        } else if (mediaInfo != null && mediaInfo.getThumbnail() != null && mediaInfo.getThumbnail().getImageInfo() != null) {
            thumbnailImageInf = mediaInfo.getThumbnail().getImageInfo();
        }
        boolean includeGIF = imageInfo != null && imageInfo.getFormat() == ImageFormat.GIF && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.GIF_LRG, renderer);
        ArrayList<DLNAImageResElement> resElements = new ArrayList<DLNAImageResElement>();
        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_TN, thumbnailImageInf != null ? thumbnailImageInf : imageInfo, true));
        if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_TN, renderer)) {
            resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_TN, thumbnailImageInf != null ? thumbnailImageInf : imageInfo, true));
        }
        if (imageInfo != null) {
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_RES_H_V, renderer) && imageInfo.getWidth() > 0 && imageInfo.getHeight() > 0) {
                DLNAImageProfile exactResolution = DLNAImageProfile.createJPEG_RES_H_V(imageInfo.getWidth(), imageInfo.getHeight());
                resElements.add(new DLNAImageResElement(exactResolution, imageInfo, exactResolution.useThumbnailSource(imageInfo, thumbnailImageInf)));
            }
            resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_SM, imageInfo, DLNAImageProfile.JPEG_SM.useThumbnailSource(imageInfo, thumbnailImageInf)));
            if (!DLNAImageProfile.PNG_TN.isResolutionCorrect(imageInfo)) {
                if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_LRG, renderer)) {
                    resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_LRG, imageInfo, DLNAImageProfile.PNG_LRG.useThumbnailSource(imageInfo, thumbnailImageInf)));
                }
                if (includeGIF) {
                    resElements.add(new DLNAImageResElement(DLNAImageProfile.GIF_LRG, imageInfo, DLNAImageProfile.GIF_LRG.useThumbnailSource(imageInfo, thumbnailImageInf)));
                }
                if (!DLNAImageProfile.JPEG_SM.isResolutionCorrect(imageInfo)) {
                    if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_MED, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_MED, imageInfo, DLNAImageProfile.JPEG_MED.useThumbnailSource(imageInfo, thumbnailImageInf)));
                    }
                    if (!DLNAImageProfile.JPEG_MED.isResolutionCorrect(imageInfo) && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_LRG, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_LRG, imageInfo, DLNAImageProfile.JPEG_LRG.useThumbnailSource(imageInfo, thumbnailImageInf)));
                    }
                }
            }
        } else {
            resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_SM, null, false));
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_LRG, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_LRG, null, false));
            }
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_LRG, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_LRG, null, false));
            }
            LOGGER.debug("Warning: Image \"{}\" wasn't parsed when DIDL-Lite was generated", (Object)resource.getName());
        }
        Collections.sort(resElements, DLNAImageResElement.getComparator(imageInfo != null ? imageInfo.getFormat() : ImageFormat.JPEG));
        return resElements;
    }

    private static List<DLNAImageResElement> getThumbnailResElements(StoreResource resource, MediaType mediaType) {
        Renderer renderer = resource.getDefaultRenderer();
        MediaInfo mediaInfo = resource.getMediaInfo();
        ArrayList<DLNAImageResElement> resElements = new ArrayList<DLNAImageResElement>();
        if (MediaType.IMAGE != mediaType) {
            ImageInfo imageInfo = null;
            if (resource.getThumbnailImageInfo() != null) {
                imageInfo = resource.getThumbnailImageInfo();
            } else if (mediaInfo != null && mediaInfo.getThumbnail() != null && mediaInfo.getThumbnail().getImageInfo() != null) {
                imageInfo = mediaInfo.getThumbnail().getImageInfo();
            }
            boolean includeGIF = imageInfo != null && imageInfo.getFormat() == ImageFormat.GIF && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.GIF_LRG, renderer);
            resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_TN, imageInfo, true));
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_SM, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_SM, imageInfo, true));
            }
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_TN, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_TN, imageInfo, true));
            }
            if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.PNG_LRG, renderer)) {
                resElements.add(new DLNAImageResElement(DLNAImageProfile.PNG_LRG, imageInfo, true));
            }
            if (imageInfo != null) {
                if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_RES_H_V, renderer) && imageInfo.getWidth() > 0 && imageInfo.getHeight() > 0) {
                    DLNAImageProfile exactResolution = DLNAImageProfile.createJPEG_RES_H_V(imageInfo.getWidth(), imageInfo.getHeight());
                    resElements.add(new DLNAImageResElement(exactResolution, imageInfo, true));
                }
                if (includeGIF) {
                    resElements.add(new DLNAImageResElement(DLNAImageProfile.GIF_LRG, imageInfo, true));
                }
                if (!DLNAImageProfile.JPEG_SM.isResolutionCorrect(imageInfo)) {
                    if (DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_MED, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_MED, imageInfo, true));
                    }
                    if (!DLNAImageProfile.JPEG_MED.isResolutionCorrect(imageInfo) && DLNAImageResElement.isImageProfileSupported(DLNAImageProfile.JPEG_LRG, renderer)) {
                        resElements.add(new DLNAImageResElement(DLNAImageProfile.JPEG_LRG, imageInfo, true));
                    }
                }
            }
            Collections.sort(resElements, DLNAImageResElement.getComparator(imageInfo != null ? imageInfo.getFormat() : ImageFormat.JPEG));
        }
        return resElements;
    }

    private static Res getImageRes(StoreResource resource, DLNAImageResElement resElement) {
        if (resource == null) {
            throw new NullPointerException("resource cannot be null");
        }
        if (resElement == null) {
            throw new NullPointerException("resElement cannot be null");
        }
        if (!resElement.isResolutionKnown() && DLNAImageProfile.JPEG_RES_H_V.equals(resElement.getProfile())) {
            throw new IllegalArgumentException("Resolution cannot be unknown for DLNAImageProfile.JPEG_RES_H_V");
        }
        Object url = null;
        if (resElement.isThumbnail()) {
            url = resource.getThumbnailURL(resElement.getProfile());
        } else if (resource instanceof StoreItem) {
            StoreItem item = (StoreItem)resource;
            url = item.getMediaURL((String)(DLNAImageProfile.JPEG_RES_H_V.equals(resElement.getProfile()) ? "JPEG_RES" + resElement.getWidth() + "x" + resElement.getHeight() : resElement.getProfile().toString()) + "_");
        }
        if (StringUtils.isNotBlank((CharSequence)url)) {
            Object ciFlag = resElement.getCiFlag() == null || resElement.getCiFlag() == 0 ? "" : ";DLNA.ORG_CI=" + resElement.getCiFlag().toString();
            Res res = new Res();
            if (resElement.getSize() != null && resElement.getSize() > 0L) {
                res.setSize(resElement.getSize());
            }
            if (resElement.isResolutionKnown()) {
                res.setResolution(resElement.getWidth(), resElement.getHeight());
            }
            String protocolInfoStr = "http-get:*:" + String.valueOf(resElement.getProfile().getMimeType()) + ":DLNA.ORG_PN=" + String.valueOf(resElement.getProfile()) + (String)ciFlag + ";DLNA.ORG_FLAGS=00900000000000000000000000000000";
            ProtocolInfo protocolInfo = new ProtocolInfo(protocolInfoStr);
            res.setProtocolInfo(protocolInfo);
            String updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
            if (updateId != null && url != null) {
                url = ((String)url).contains("?") ? (String)url + "&update=" + updateId : (String)url + "?update=" + updateId;
            }
            res.setValue(URI.create((String)url));
            return res;
        }
        return null;
    }

    private static UPNP.AlbumArtURI getAlbumArtURI(StoreResource resource, DLNAImageResElement resElement) {
        DLNAImageProfile imageProfile = resElement.getProfile();
        String rendererProfile = resource.getDefaultRenderer().getAlbumArtProfile();
        if (StringUtils.isNotBlank(rendererProfile) && !rendererProfile.equalsIgnoreCase(imageProfile.toString())) {
            return null;
        }
        switch (imageProfile.toInt()) {
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return StoreResourceHelper.getAlbumArtURI(resource, imageProfile);
            }
        }
        return null;
    }

    private static UPNP.AlbumArtURI getAlbumArtURI(StoreResource resource, DLNAImageProfile imageProfile) {
        Object albumArtURL = resource.getThumbnailURL(imageProfile);
        if (StringUtils.isNotBlank((CharSequence)albumArtURL)) {
            String updateId = MediaStoreIds.getObjectUpdateIdAsString(resource.getLongId());
            if (updateId != null && albumArtURL != null) {
                albumArtURL = ((String)albumArtURL).contains("?") ? (String)albumArtURL + "&update=" + updateId : (String)albumArtURL + "?update=" + updateId;
            }
            UPNP.AlbumArtURI albumArtURI = new UPNP.AlbumArtURI(URI.create((String)albumArtURL));
            albumArtURI.setProfileID(imageProfile.toString());
            return albumArtURI;
        }
        return null;
    }

    private static Container newContainerFromUpnpClass(String upnpClass) {
        return switch (upnpClass) {
            case "object.container.album.musicAlbum" -> new MusicAlbum();
            case "object.container.person.musicArtist" -> new MusicArtist();
            case "object.container.playlistContainer" -> new PlaylistContainer();
            case "object.container.storageFolder" -> new StorageFolder();
            default -> new Container();
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatDate(Date data) {
        SimpleDateFormat simpleDateFormat = DIDL_DATE_FORMAT;
        synchronized (simpleDateFormat) {
            return DIDL_DATE_FORMAT.format(data);
        }
    }
}

