/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network.mediaserver.handlers.nextcpapi;

import net.pms.network.mediaserver.handlers.nextcpapi.NextcpApiResponse;
import net.pms.network.mediaserver.handlers.nextcpapi.NextcpApiResponseHandler;
import net.pms.store.MediaScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderScanner
implements NextcpApiResponseHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FolderScanner.class);
    public static final String PATH_MATCH = "folderscanner";

    @Override
    public NextcpApiResponse handleRequest(String uri, String content) {
        NextcpApiResponse response = new NextcpApiResponse();
        response.setStatusCode(204);
        switch (uri) {
            case "rescan": {
                this.rescanMediaStore();
                break;
            }
            case "rescanFileOrFolder": {
                MediaScanner.backgroundScanFileOrFolder(content);
                break;
            }
            default: {
                LOGGER.warn("Invalid nextcp API call. Unknown path : " + uri);
                response.setStatusCode(404);
            }
        }
        return response;
    }

    private void rescanMediaStore() {
        if (!MediaScanner.isMediaScanRunning()) {
            MediaScanner.startMediaScan();
        } else {
            LOGGER.warn("Media scan already in progress");
        }
    }
}

