/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.subtitle;

import com.google.gson.JsonObject;
import com.ibm.icu.text.CharsetMatch;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Locale;
import net.pms.formats.v2.SubtitleType;
import net.pms.media.MediaLang;
import net.pms.util.Constants;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaSubtitle
extends MediaLang
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaSubtitle.class);
    private SubtitleType type = SubtitleType.UNKNOWN;
    private Integer streamOrder;
    private Long optionalId;
    private boolean defaultFlag;
    private boolean forcedFlag;
    private String title;
    private File externalFile;
    private String subsCharacterSet;
    private File convertedFile;

    public boolean isEmbedded() {
        return this.externalFile == null;
    }

    public boolean isExternal() {
        return !this.isEmbedded();
    }

    public Integer getStreamOrder() {
        return this.streamOrder;
    }

    public void setStreamOrder(Integer streamIndex) {
        this.streamOrder = streamIndex;
    }

    public Long getOptionalId() {
        return this.optionalId;
    }

    public void setOptionalId(Long optionalId) {
        this.optionalId = optionalId;
    }

    public boolean isDefault() {
        return this.defaultFlag;
    }

    public void setDefault(boolean value) {
        this.defaultFlag = value;
    }

    public boolean isForced() {
        return this.forcedFlag;
    }

    public void setForced(boolean value) {
        this.forcedFlag = value;
    }

    public SubtitleType getType() {
        return this.type;
    }

    public void setType(SubtitleType type) {
        if (type == null) {
            throw new IllegalArgumentException("Can't set null SubtitleType.");
        }
        this.type = type;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String value) {
        this.title = value;
    }

    public File getExternalFile() {
        return this.externalFile;
    }

    public String getName() {
        return this.externalFile == null ? "" : this.externalFile.getName();
    }

    public void setExternalFile(File externalFile) throws FileNotFoundException {
        if (externalFile == null) {
            throw new FileNotFoundException("Can't read file: no file supplied");
        }
        this.externalFile = externalFile.getAbsoluteFile();
        if (!FileUtil.getFilePermissions(this.externalFile).isReadable()) {
            throw new FileNotFoundException("Insufficient permission to read " + externalFile.getAbsolutePath());
        }
        this.setFileSubsCharacterSet();
    }

    public void setExternalFileOnly(File externalFile) {
        this.externalFile = externalFile;
    }

    private void setFileSubsCharacterSet() {
        block7: {
            if (this.externalFile != null && !this.type.isPicture()) {
                try {
                    CharsetMatch match = FileUtil.getFileCharsetMatch(this.externalFile);
                    if (match != null) {
                        String tmpLanguage;
                        this.subsCharacterSet = match.getName().toUpperCase(Locale.ROOT);
                        if (this.subsCharacterSet.split("-").length > 3) {
                            this.subsCharacterSet = this.subsCharacterSet.substring(0, this.subsCharacterSet.lastIndexOf("-"));
                        }
                        if ((this.lang == null || "und".equals(this.lang)) && StringUtils.isNotBlank(tmpLanguage = match.getLanguage())) {
                            this.lang = tmpLanguage;
                        }
                        LOGGER.debug("Set detected charset \"{}\" and language \"{}\" for {}", this.subsCharacterSet, this.lang, this.externalFile);
                        break block7;
                    }
                    this.subsCharacterSet = null;
                    LOGGER.debug("No charset detected for {}", (Object)this.externalFile);
                }
                catch (IOException ex) {
                    LOGGER.warn("Exception during external file charset detection: {}", (Object)ex.getMessage());
                    LOGGER.trace("", ex);
                }
            } else {
                this.subsCharacterSet = null;
            }
        }
    }

    public void setSubCharacterSet(String charSet) {
        this.subsCharacterSet = charSet;
    }

    public String getSubCharacterSet() {
        return this.subsCharacterSet;
    }

    public boolean isSubsUtf8() {
        return Strings.CI.equals(this.subsCharacterSet, Constants.CHARSET_UTF_8);
    }

    public boolean isExternalFileUtf8() {
        return FileUtil.isCharsetUTF8(this.subsCharacterSet);
    }

    public boolean isExternalFileUtf16() {
        return FileUtil.isCharsetUTF16(this.subsCharacterSet);
    }

    public boolean isExternalFileUtf32() {
        return FileUtil.isCharsetUTF32(this.subsCharacterSet);
    }

    public boolean isExternalFileUtf() {
        return this.isExternalFileUtf8() || this.isExternalFileUtf16() || this.isExternalFileUtf32();
    }

    public void setConvertedFile(File convertedFile) {
        this.convertedFile = convertedFile;
    }

    public File getConvertedFile() {
        return this.convertedFile;
    }

    public JsonObject toJson() {
        JsonObject result = new JsonObject();
        result.addProperty("embedded", this.isEmbedded());
        if (this.isEmbedded()) {
            result.addProperty("id", this.getId());
            result.addProperty("default", this.isDefault());
            result.addProperty("forced", this.isForced());
        }
        if (StringUtils.isNotBlank(this.getTitle())) {
            result.addProperty("title", this.getTitle());
        }
        result.addProperty("lang", this.getLang());
        result.addProperty("type", this.getType().getShortName());
        if (this.getStreamOrder() != null) {
            result.addProperty("stream", this.getStreamOrder());
        }
        if (this.isExternal()) {
            result.addProperty("externalFile", this.getExternalFile().toString());
            result.addProperty("subsCharacterSet", this.getSubCharacterSet());
        }
        if (this.getConvertedFile() != null) {
            result.addProperty("convertedFile", this.getConvertedFile().toString());
        }
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.isEmbedded()) {
            result.append("Id: ").append(this.getId()).append(", Embedded");
            if (this.isDefault()) {
                result.append(", Default");
            }
            if (this.isForced()) {
                result.append(", Forced");
            }
        } else {
            result.append("External");
        }
        if (StringUtils.isNotBlank(this.title)) {
            result.append(", title: ");
            result.append(this.title);
        }
        result.append(", lang: ");
        result.append(this.getLang());
        result.append(", type: ").append((Object)this.type);
        if (this.getStreamOrder() != null) {
            result.append(", Stream Order: ").append(this.getStreamOrder());
        }
        if (this.isExternal()) {
            result.append(", externalFile: ");
            result.append(this.externalFile);
            result.append(", external file character set: ");
            result.append(this.subsCharacterSet);
        }
        if (this.convertedFile != null) {
            result.append(", convertedFile: ");
            result.append(this.convertedFile.toString());
        }
        return result.toString();
    }
}

