/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media.audio.metadata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.pms.media.audio.metadata.MusicBrainzAlbum;

public class DoubleRecordFilter {
    private final Map<MusicBrainzAlbum, HashSet<String>> mbidGenres = new HashMap<MusicBrainzAlbum, HashSet<String>>();
    private final Set<MusicBrainzAlbum> albumObjects = new HashSet<MusicBrainzAlbum>();

    public void addAlbum(MusicBrainzAlbum album) {
        this.extractGenres(album);
        this.albumObjects.add(album);
    }

    private void extractGenres(MusicBrainzAlbum album) {
        HashSet<String> genres = this.getGenres(album);
        if (album.getGenre() != null) {
            String[] splitGenre;
            for (String genre : splitGenre = album.getGenre().split("/")) {
                genres.add(genre.trim());
            }
            this.updatGenre(genres, album);
        }
    }

    private void updatGenre(HashSet<String> genres, MusicBrainzAlbum album) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String genre : genres) {
            sb.append(genre);
            if (genres.size() >= ++i) continue;
            sb.append(" /");
        }
        album.setGenre(sb.toString());
    }

    private HashSet<String> getGenres(MusicBrainzAlbum album) {
        if (this.mbidGenres.get(album) == null) {
            this.mbidGenres.put(album, new HashSet());
        }
        return this.mbidGenres.get(album);
    }

    public Set<MusicBrainzAlbum> getUniqueAlbumSet() {
        return this.albumObjects;
    }
}

