/*
 * Decompiled with CFR 0.152.
 */
package net.pms.media;

import net.pms.util.Iso639;
import org.apache.commons.lang3.StringUtils;

public abstract class MediaLang {
    public static final String UND = "und";
    private int id;
    protected String lang;
    public static final int DUMMY_ID = Integer.MIN_VALUE;

    public String getLangFullName() {
        if (StringUtils.isNotBlank(this.lang)) {
            return Iso639.getFirstName(this.lang);
        }
        return Iso639.getFirstName(UND);
    }

    public boolean matchCode(String code) {
        return Iso639.isCodesMatching(this.lang, code);
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

