/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.core.rolling.helper.CompressionMode;
import ch.qos.logback.core.rolling.helper.Compressor;
import ch.qos.logback.core.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsCompressor
extends Compressor {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmsCompressor.class);
    private final ReentrantLock lock = new ReentrantLock(false);

    public UmsCompressor() {
        super(CompressionMode.ZIP);
    }

    @Override
    public void compress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        this.nioZipCompress(nameOfFile2Compress, nameOfCompressedFile, innerEntryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void nioZipCompress(String nameOfFile2Compress, String nameOfCompressedFile, String innerEntryName) {
        File file2zip = new File(nameOfFile2Compress);
        if (!file2zip.exists()) {
            this.addWarn("The file to compress named [" + nameOfFile2Compress + "] does not exist.");
            return;
        }
        if (innerEntryName == null) {
            this.addWarn("The innerEntryName parameter cannot be null");
            return;
        }
        if (!((String)nameOfCompressedFile).endsWith(".zip")) {
            nameOfCompressedFile = (String)nameOfCompressedFile + ".zip";
        }
        this.lock.lock();
        Instant start = Instant.now();
        File zippedFile = new File((String)nameOfCompressedFile);
        this.createMissingTargetDirsIfNecessary(zippedFile);
        URI uri = URI.create("jar:" + String.valueOf(zippedFile.toURI()));
        this.addInfo("The target compressed file named [" + (String)nameOfCompressedFile + "] will be appended.");
        try (FileSystem fs = FileSystems.newFileSystem(uri, Map.of("create", "true"));){
            long count;
            Path e = fs.getRootDirectories().iterator().next();
            try (Stream<Path> paths = Files.find(e.getRoot(), 1, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile(), new FileVisitOption[0]);){
                count = paths.count();
            }
            Path source = file2zip.toPath();
            innerEntryName = UmsCompressor.getIndexedInnerEntryName(innerEntryName, count);
            Path pathInZipfile = fs.getPath(innerEntryName, new String[0]);
            this.addInfo("ZIP compressing [" + String.valueOf(file2zip) + "] as [" + innerEntryName + "]");
            Files.copy(source, pathInZipfile, StandardCopyOption.REPLACE_EXISTING);
            Instant end = Instant.now();
            LOGGER.info("Compressing [" + nameOfFile2Compress + "] take " + Duration.between(start, end).toString());
            if (!FileUtils.deleteQuietly(file2zip)) {
                LOGGER.warn("Could not delete [" + nameOfFile2Compress + "].");
            }
        }
        catch (IOException e) {
            this.addError("Error occurred while compressing [" + nameOfFile2Compress + "] into [" + (String)nameOfCompressedFile + "].", e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void createMissingTargetDirsIfNecessary(File file) {
        boolean result = FileUtil.createMissingParentDirectories(file);
        if (!result) {
            this.addError("Failed to create parent directories for [" + file.getAbsolutePath() + "]");
        }
    }

    private static String getIndexedInnerEntryName(String innerEntryName, long index) {
        String innerEntryExt = "";
        if (((String)innerEntryName).contains(".")) {
            int dotIndex = ((String)innerEntryName).lastIndexOf(".");
            innerEntryExt = ((String)innerEntryName).substring(dotIndex);
            innerEntryName = ((String)innerEntryName).substring(0, dotIndex);
        }
        innerEntryName = (String)innerEntryName + "." + String.format("%04d", index) + innerEntryExt;
        return innerEntryName;
    }
}

