/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.util.Timer;
import java.util.TimerTask;
import net.pms.io.ProcessWrapperImpl;

public class FailSafeProcessWrapper
extends TimerTask {
    private final ProcessWrapperImpl pw;
    private final Timer timer;
    private final long delay;
    private final Object failureLock = new Object();
    private boolean failure;

    public FailSafeProcessWrapper(ProcessWrapperImpl pw, long delay) {
        this.pw = pw;
        this.timer = new Timer();
        this.delay = delay;
    }

    public void runInSameThread() {
        this.setFailure(false);
        this.timer.schedule((TimerTask)this, this.delay);
        this.pw.runInSameThread();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFailure(boolean value) {
        Object object = this.failureLock;
        synchronized (object) {
            this.failure = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasFail() {
        Object object = this.failureLock;
        synchronized (object) {
            return this.failure;
        }
    }

    @Override
    public void run() {
        if (this.pw != null && this.pw.isAlive()) {
            this.setFailure(true);
            this.pw.stopProcess();
        }
        this.timer.cancel();
    }
}

