/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Metadata;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPEGSubsamplingNotation
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JPEGSubsamplingNotation.class);
    private final double j;
    private final double a;
    private final double b;

    public JPEGSubsamplingNotation(int j, int a, int b) {
        this.j = j;
        this.a = a;
        this.b = b;
    }

    public JPEGSubsamplingNotation(double j, double a, double b) {
        this.j = j;
        this.a = a;
        this.b = b;
    }

    protected JPEGSubsamplingNotation(double[] factors) {
        this.j = factors[0];
        this.a = factors[1];
        this.b = factors[2];
    }

    public static JPEGSubsamplingNotation calculateJPEGSubsampling(Metadata metadata) {
        if (metadata == null) {
            throw new NullPointerException("metadata cannot be null");
        }
        JpegDirectory directory = metadata.getFirstDirectoryOfType(JpegDirectory.class);
        if (directory == null) {
            return new JPEGSubsamplingNotation(Double.NaN, Double.NaN, Double.NaN);
        }
        return JPEGSubsamplingNotation.calculateJPEGSubsampling(directory);
    }

    public static JPEGSubsamplingNotation calculateJPEGSubsampling(JpegDirectory directory) {
        if (directory == null) {
            throw new NullPointerException("directory cannot be null");
        }
        if (directory.getInteger(5) == null || directory.getInteger(5) == 0) {
            return new JPEGSubsamplingNotation(Double.NaN, Double.NaN, Double.NaN);
        }
        int numComponents = directory.getInteger(5);
        int luminanceIdx = -1;
        JpegComponent[] components = new JpegComponent[numComponents];
        for (int i = 0; i < numComponents; ++i) {
            components[i] = directory.getComponent(i);
            if (components[i].getComponentId() != 1) continue;
            luminanceIdx = i;
        }
        if (luminanceIdx < 0) {
            return new JPEGSubsamplingNotation(Double.NaN, Double.NaN, Double.NaN);
        }
        JPEGSubsamplingNotation result = null;
        for (int i = 0; i < numComponents; ++i) {
            if (i == luminanceIdx) continue;
            JPEGSubsamplingNotation componentResult = JPEGSubsamplingNotation.calculateJPEGSubsampling(components, luminanceIdx, i);
            if (result == null) {
                result = componentResult;
                continue;
            }
            if (result.equals(componentResult)) continue;
            LOGGER.trace("Components {} and {} have mismatching chroma subsampling {} and {}. Unable to determine an overall chroma subsampling notation", components[i - 1].getComponentName(), components[i].getComponentName(), result, componentResult);
            return new JPEGSubsamplingNotation(Double.NaN, Double.NaN, Double.NaN);
        }
        return result != null ? result : new JPEGSubsamplingNotation(Double.NaN, Double.NaN, Double.NaN);
    }

    public static JPEGSubsamplingNotation calculateJPEGSubsampling(JpegComponent[] components, int luminanceIdx, int componentIdx) {
        double[] result = new double[3];
        result[0] = 4.0;
        int hMax = 0;
        int vMax = 0;
        for (JpegComponent component : components) {
            hMax = Math.max(hMax, component.getHorizontalSamplingFactor());
            vMax = Math.max(vMax, component.getVerticalSamplingFactor());
        }
        double[] h = new double[components.length];
        double[] v = new double[components.length];
        for (int i = 0; i < components.length; ++i) {
            h[i] = (double)components[i].getHorizontalSamplingFactor() / (double)hMax;
            v[i] = (double)components[i].getVerticalSamplingFactor() / (double)vMax;
        }
        result[1] = 4.0 * h[componentIdx];
        double cHeight = 2.0 * v[componentIdx];
        result[2] = Double.NaN;
        if (cHeight == 2.0) {
            result[2] = result[1];
        } else if (cHeight == 1.0) {
            result[2] = 0.0;
        } else if (cHeight < 1.0) {
            result[2] = 1.0;
        }
        return new JPEGSubsamplingNotation(result);
    }

    public double getJ() {
        return this.j;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public String toString() {
        if ((Double.isNaN(this.j) || Double.isInfinite(this.j)) && (Double.isNaN(this.a) || Double.isInfinite(this.a)) && (Double.isNaN(this.b) || Double.isInfinite(this.b))) {
            return "N/A";
        }
        DecimalFormat df = new DecimalFormat("#.##", new DecimalFormatSymbols(Locale.ROOT));
        return String.format(Locale.ROOT, "%s:%s:%s", this.j == (double)((long)this.j) ? Long.valueOf((long)this.j) : df.format(this.j), this.a == (double)((long)this.a) ? Long.valueOf((long)this.a) : df.format(this.a), this.b == (double)((long)this.b) ? Long.valueOf((long)this.b) : df.format(this.b));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.j);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JPEGSubsamplingNotation)) {
            return false;
        }
        JPEGSubsamplingNotation other = (JPEGSubsamplingNotation)obj;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(other.a)) {
            return false;
        }
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(other.b)) {
            return false;
        }
        return Double.doubleToLongBits(this.j) == Double.doubleToLongBits(other.j);
    }
}

