/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.stream.ImageInputStream;
import net.pms.image.ImageFormat;
import net.pms.image.ImageIORuntimeException;
import net.pms.util.UnknownFormatException;

public class ImageIOTools {
    protected static final IIORegistry REGISTRY = IIORegistry.getDefaultInstance();

    private ImageIOTools() {
    }

    public static ImageReaderResult read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("input == null!");
        }
        ImageInputStream stream = ImageIOTools.createImageInputStream(inputStream);
        try {
            ImageReaderResult result = ImageIOTools.read(stream);
            if (result == null) {
                inputStream.close();
            }
            return result;
        }
        catch (IOException | RuntimeException e) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (e instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)e;
                throw new ImageIORuntimeException("An error occurred while trying to read image: " + e.getMessage(), runtimeException);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageReaderResult read(ImageInputStream stream) throws IOException {
        ImageReaderResult imageReaderResult;
        block14: {
            if (stream == null) {
                throw new IllegalArgumentException("stream == null!");
            }
            ImageInputStream imageInputStream = stream;
            try {
                Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
                if (!iter.hasNext()) {
                    throw new UnknownFormatException("Unable to find a suitable image reader");
                }
                ImageFormat inputFormat = null;
                BufferedImage bufferedImage = null;
                ImageReader reader = iter.next();
                try {
                    inputFormat = ImageFormat.toImageFormat(reader.getFormatName());
                    reader.setInput(stream, true, true);
                    bufferedImage = reader.read(0, reader.getDefaultReadParam());
                }
                finally {
                    reader.dispose();
                }
                ImageReaderResult imageReaderResult2 = imageReaderResult = bufferedImage != null ? new ImageReaderResult(bufferedImage, inputFormat) : null;
                if (imageInputStream == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (imageInputStream != null) {
                        try {
                            imageInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new ImageIORuntimeException("An error occurred while trying to read image: " + e.getMessage(), e);
                }
            }
            imageInputStream.close();
        }
        return imageReaderResult;
    }

    public static ImageFormat detectFileFormat(InputStream inputStream) throws IOException {
        ImageFormat imageFormat;
        block11: {
            if (inputStream == null) {
                throw new IllegalArgumentException("input == null!");
            }
            ImageInputStream stream = ImageIOTools.createImageInputStream(inputStream);
            try {
                Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
                if (!iter.hasNext()) {
                    throw new UnknownFormatException("Unable to find a suitable image reader");
                }
                ImageReader reader = iter.next();
                ImageFormat format = ImageFormat.toImageFormat(reader.getFormatName());
                if (format == null) {
                    throw new UnknownFormatException("Unable to determine image format");
                }
                imageFormat = format;
                if (stream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw new ImageIORuntimeException("An error occurred while trying to detect image format: " + e.getMessage(), e);
                }
            }
            stream.close();
        }
        return imageFormat;
    }

    public static ImageInputStream createImageInputStream(Object input) throws IOException {
        Iterator<ImageInputStreamSpi> iter;
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        try {
            iter = REGISTRY.getServiceProviders(ImageInputStreamSpi.class, true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        while (iter.hasNext()) {
            ImageInputStreamSpi spi = iter.next();
            if (!spi.getInputClass().isInstance(input)) continue;
            try {
                return spi.createInputStreamInstance(input, false, null);
            }
            catch (IOException e) {
                throw new IIOException("Can't create cache file!", e);
            }
        }
        return null;
    }

    public static boolean imageIOWrite(RenderedImage im, String formatName, OutputStream output) throws IOException {
        try {
            return ImageIO.write(im, formatName, output);
        }
        catch (RuntimeException e) {
            throw new ImageIORuntimeException(e.getMessage(), e);
        }
    }

    public static class ImageReaderResult {
        public final BufferedImage bufferedImage;
        public final ImageFormat imageFormat;
        public final int width;
        public final int height;

        public ImageReaderResult(BufferedImage bufferedImage, ImageFormat imageFormat) {
            this.bufferedImage = bufferedImage;
            this.imageFormat = imageFormat;
            this.width = bufferedImage == null ? -1 : bufferedImage.getWidth();
            this.height = bufferedImage == null ? -1 : bufferedImage.getHeight();
        }
    }
}

