/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import java.util.Locale;
import net.pms.dlna.DLNAImageProfile;

public enum ImageFormat {
    ARW,
    BMP,
    CR2,
    CRW,
    CUR,
    DCR,
    DCX,
    DNG,
    RAW,
    GIF,
    ICNS,
    ICO,
    IFF,
    JPEG,
    KDC,
    NEF,
    ORF,
    PCX,
    PICT,
    PEF,
    PNG,
    PNM,
    PSD,
    RAF,
    RGBE,
    RW2,
    SGI,
    SOURCE,
    SRW,
    TGA,
    TIFF,
    WBMP,
    WEBP;

    public static final int TAG_DNG_VERSION = 50706;

    public static ImageFormat toImageFormat(DLNAImageProfile imageProfile) {
        if (imageProfile == null) {
            return null;
        }
        return imageProfile.getFormat();
    }

    public static ImageFormat toImageFormat(String formatName) {
        ImageFormat result = null;
        if (formatName != null) {
            if ((formatName = formatName.toUpperCase(Locale.ROOT)).contains("BMP")) {
                result = BMP;
            } else if (formatName.contains("CUR")) {
                result = CUR;
            } else if (formatName.contains("DCX")) {
                result = DCX;
            } else if (formatName.contains("GIF")) {
                result = GIF;
            } else if (formatName.contains("ICNS")) {
                result = ICNS;
            } else if (formatName.contains("ICO")) {
                result = ICO;
            } else if (formatName.equals("IFF")) {
                result = IFF;
            } else if (formatName.contains("JPEG")) {
                result = JPEG;
            } else if (formatName.contains("PCX")) {
                result = PCX;
            } else if (formatName.contains("PIC") || formatName.contains("PCT")) {
                result = PICT;
            } else if (formatName.contains("PNG")) {
                result = PNG;
            } else if (formatName.contains("PNM") || formatName.contains("PBM") || formatName.contains("PGM") || formatName.contains("PPM") || formatName.contains("PAM") || formatName.contains("PFM")) {
                result = PNM;
            } else if (formatName.contains("PSD")) {
                result = PSD;
            } else if (formatName.contains("RGBE") || formatName.contains("HDR") || formatName.contains("XYZE")) {
                result = RGBE;
            } else if (formatName.contains("SGI") || formatName.equals("RLE")) {
                result = SGI;
            } else if (formatName.contains("TGA") || formatName.contains("TARGA")) {
                result = TGA;
            } else if (formatName.contains("TIFF")) {
                result = TIFF;
            } else if (formatName.contains("WBMP")) {
                result = WBMP;
            } else if (formatName.contains("WEBP")) {
                result = WEBP;
            }
        }
        return result;
    }

    public boolean isRaw() {
        return switch (this) {
            case ARW, CR2, CRW, DCR, DNG, RAW, KDC, NEF, ORF, PEF, RAF, RW2, SRW -> true;
            default -> false;
        };
    }

    public boolean supportedByImageIO() {
        return switch (this) {
            case BMP, CUR, DCX, GIF, ICNS, ICO, IFF, JPEG, PCX, PICT, PNG, PNM, PSD, RGBE, SGI, TGA, TIFF, WBMP -> true;
            default -> false;
        };
    }

    public String toFormatConfiguration() {
        switch (this) {
            case ARW: 
            case CR2: 
            case CRW: 
            case DCR: 
            case DNG: 
            case RAW: 
            case KDC: 
            case NEF: 
            case ORF: 
            case PEF: 
            case RAF: 
            case RW2: 
            case SRW: {
                return "raw";
            }
            case BMP: {
                return "bmp";
            }
            case CUR: {
                return "cur";
            }
            case DCX: {
                return "pcx";
            }
            case GIF: {
                return "gif";
            }
            case ICNS: {
                return "icns";
            }
            case ICO: {
                return "ico";
            }
            case JPEG: {
                return "jpg";
            }
            case PCX: {
                return "pcx";
            }
            case PNG: {
                return "png";
            }
            case PNM: {
                return "pnm";
            }
            case PSD: {
                return "psd";
            }
            case TIFF: {
                return "tiff";
            }
            case WBMP: {
                return "wbmp";
            }
            case WEBP: {
                return "webp";
            }
            case SOURCE: {
                throw new IllegalArgumentException("SOURCE cannot be translated into an actual format");
            }
        }
        return this.toString().toLowerCase(Locale.ROOT);
    }
}

