/*
 * Decompiled with CFR 0.152.
 */
package net.pms.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.pms.PMS;
import net.pms.database.MediaDatabase;
import net.pms.gui.EConnectionState;
import net.pms.gui.IGui;
import net.pms.network.webguiserver.WebGuiServer;
import net.pms.renderers.Renderer;
import net.pms.swing.gui.JavaGui;

public class GuiManager {
    private static final List<String> LOG_BUFFER = Collections.synchronizedList(new ArrayList());
    private static final int LOG_BUFFER_SIZE = 5000;
    private static final int BYTES_TO_MBYTES = 0x100000;
    private static IGui swingFrame;
    private static IGui webGui;
    private static EConnectionState connectionState;
    private static long readCount;
    private static int currentBitrate;
    private static int peakBitrate;
    private static int maxMemory;
    private static int usedMemory;
    private static int dbCacheMemory;
    private static int bufferMemory;
    private static boolean reloadable;
    private static boolean serverReady;
    private static boolean needLogFile;
    private static boolean mediaScanRunning;
    private static final Runnable UPDATE_MEMORY_USAGE_RUNNABLE;
    private static final Thread UPDATE_MEMORY_USAGE_THREAD;

    private GuiManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addGui(IGui gui) {
        if (gui != null) {
            List<Renderer> foundRenderers;
            if (gui instanceof JavaGui) {
                GuiManager.dumpCurrentLog(gui);
                swingFrame = gui;
            } else if (gui instanceof WebGuiServer) {
                webGui = gui;
            } else {
                return;
            }
            GuiManager.startMemoryThread();
            gui.setConnectionState(connectionState);
            gui.setCurrentBitrate(currentBitrate);
            gui.setPeakBitrate(peakBitrate);
            gui.setReloadable(reloadable);
            gui.setMemoryUsage(maxMemory, usedMemory, dbCacheMemory, bufferMemory);
            gui.setMediaScanStatus(mediaScanRunning);
            if (serverReady) {
                gui.serverReady();
            }
            List<Renderer> list = foundRenderers = PMS.get().getFoundRenderers();
            synchronized (list) {
                for (Renderer renderer : foundRenderers) {
                    gui.addRenderer(renderer);
                }
            }
        }
    }

    public static void removeGui(IGui gui) {
        if (gui instanceof WebGuiServer) {
            webGui = null;
        }
    }

    private static boolean hasGui() {
        return webGui != null || swingFrame != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpCurrentLog(IGui gui) {
        List<String> list = LOG_BUFFER;
        synchronized (list) {
            if (!LOG_BUFFER.isEmpty()) {
                for (String buffered : LOG_BUFFER) {
                    gui.appendLog(buffered);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendLog(String msg) {
        List<String> list = LOG_BUFFER;
        synchronized (list) {
            LOG_BUFFER.add(msg);
            if (LOG_BUFFER.size() > 5000) {
                needLogFile = true;
                LOG_BUFFER.remove(0);
            }
        }
        if (swingFrame != null) {
            swingFrame.appendLog(msg);
        }
        if (webGui != null) {
            webGui.appendLog(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLogLines() {
        List<String> list = LOG_BUFFER;
        synchronized (list) {
            return (String[])LOG_BUFFER.toArray(String[]::new);
        }
    }

    public static boolean hasMoreLogLines() {
        return needLogFile;
    }

    public static void setConnectionState(EConnectionState value) {
        if (!value.equals((Object)connectionState)) {
            connectionState = value;
            if (swingFrame != null) {
                swingFrame.setConnectionState(connectionState);
            }
            if (webGui != null) {
                webGui.setConnectionState(connectionState);
            }
        }
    }

    public static void addRenderer(Renderer renderer) {
        if (swingFrame != null) {
            swingFrame.addRenderer(renderer);
        }
        if (webGui != null) {
            webGui.addRenderer(renderer);
        }
    }

    public static void setReloadable(boolean value) {
        reloadable = value;
        if (swingFrame != null) {
            swingFrame.setReloadable(reloadable);
        }
        if (webGui != null) {
            webGui.setReloadable(reloadable);
        }
    }

    public static void addEngines() {
        if (swingFrame != null) {
            swingFrame.addEngines();
        }
        if (webGui != null) {
            webGui.addEngines();
        }
    }

    public static void setStatusLine(String line) {
        if (swingFrame != null) {
            swingFrame.setStatusLine(line);
        }
        if (webGui != null) {
            webGui.setStatusLine(line);
        }
    }

    public static void showSwingFrame() {
        IGui iGui = swingFrame;
        if (iGui instanceof JavaGui) {
            JavaGui frame = (JavaGui)iGui;
            frame.setVisible(true);
        }
    }

    public static void setSecondaryStatusLine(String line) {
        if (swingFrame != null) {
            swingFrame.setSecondaryStatusLine(line);
        }
        if (webGui != null) {
            webGui.setSecondaryStatusLine(line);
        }
    }

    public static void serverReady() {
        if (!serverReady) {
            serverReady = true;
            if (swingFrame != null) {
                swingFrame.serverReady();
            }
            if (webGui != null) {
                webGui.serverReady();
            }
        }
    }

    public static void updateServerStatus() {
        if (swingFrame != null) {
            swingFrame.updateServerStatus();
        }
        if (webGui != null) {
            webGui.updateServerStatus();
        }
    }

    public static void setMediaScanStatus(boolean running) {
        if (running != mediaScanRunning) {
            mediaScanRunning = running;
            if (swingFrame != null) {
                swingFrame.setMediaScanStatus(mediaScanRunning);
            }
            if (webGui != null) {
                webGui.setMediaScanStatus(mediaScanRunning);
            }
        }
    }

    public static void enableWebUiButton() {
        if (swingFrame != null) {
            swingFrame.enableWebUiButton();
        }
        if (webGui != null) {
            webGui.enableWebUiButton();
        }
    }

    public static void showErrorMessage(String message, String title) {
        if (swingFrame != null) {
            swingFrame.showErrorMessage(message, title);
        }
        if (webGui != null) {
            webGui.showErrorMessage(message, title);
        }
    }

    public static void setConfigurationChanged(String key) {
        if (swingFrame != null) {
            swingFrame.setConfigurationChanged(key);
        }
        if (webGui != null) {
            webGui.setConfigurationChanged(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBuffer() {
        List<Renderer> foundRenderers;
        long buf = 0L;
        List<Renderer> list = foundRenderers = PMS.get().getFoundRenderers();
        synchronized (list) {
            for (Renderer r : foundRenderers) {
                buf += r.getBuffer();
            }
        }
        if (buf == 0L && currentBitrate != 0) {
            currentBitrate = 0;
            GuiManager.updateCurrentBitrate();
        }
    }

    public static void setReadValue(long v) {
        if (v > readCount) {
            int sizeinMb = (int)((v - readCount) / 125L) / 1024;
            if (currentBitrate != sizeinMb) {
                currentBitrate = sizeinMb;
                GuiManager.updateCurrentBitrate();
            }
            if (sizeinMb > peakBitrate) {
                peakBitrate = sizeinMb;
                GuiManager.updatePeakBitrate();
            }
        }
        readCount = v;
    }

    private static void updateCurrentBitrate() {
        if (swingFrame != null) {
            swingFrame.setCurrentBitrate(currentBitrate);
        }
        if (webGui != null) {
            webGui.setCurrentBitrate(currentBitrate);
        }
    }

    private static void updatePeakBitrate() {
        if (swingFrame != null) {
            swingFrame.setPeakBitrate(peakBitrate);
        }
        if (webGui != null) {
            webGui.setPeakBitrate(peakBitrate);
        }
    }

    private static int getBytesToMegabytes(long value) {
        return (int)(value / 0x100000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateMemoryUsage() {
        if (GuiManager.hasGui()) {
            List<Renderer> foundRenderers;
            maxMemory = GuiManager.getBytesToMegabytes(Runtime.getRuntime().maxMemory());
            usedMemory = GuiManager.getBytesToMegabytes(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory());
            dbCacheMemory = MediaDatabase.getCacheSize();
            long buf = 0L;
            List<Renderer> list = foundRenderers = PMS.get().getFoundRenderers();
            synchronized (list) {
                for (Renderer r : foundRenderers) {
                    buf += r.getBuffer();
                }
            }
            if (buf == 0L && currentBitrate != 0) {
                currentBitrate = 0;
                GuiManager.updateCurrentBitrate();
            }
            bufferMemory = (int)buf;
            if (swingFrame != null) {
                swingFrame.setMemoryUsage(maxMemory, usedMemory, dbCacheMemory, bufferMemory);
            }
            if (webGui != null) {
                webGui.setMemoryUsage(maxMemory, usedMemory, dbCacheMemory, bufferMemory);
            }
        }
    }

    private static void startMemoryThread() {
        if (!UPDATE_MEMORY_USAGE_THREAD.isAlive()) {
            UPDATE_MEMORY_USAGE_THREAD.start();
        }
    }

    static {
        connectionState = EConnectionState.UNKNOWN;
        readCount = 0L;
        currentBitrate = 0;
        peakBitrate = 0;
        reloadable = false;
        serverReady = false;
        needLogFile = false;
        mediaScanRunning = false;
        UPDATE_MEMORY_USAGE_RUNNABLE = () -> {
            while (true) {
                GuiManager.updateMemoryUsage();
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        };
        UPDATE_MEMORY_USAGE_THREAD = new Thread(UPDATE_MEMORY_USAGE_RUNNABLE, "GuiManager Memory Usage Updater");
    }
}

