/*
 * Decompiled with CFR 0.152.
 */
package net.pms.formats;

import java.util.Locale;
import net.pms.configuration.RendererConfigurations;
import net.pms.network.HTTPResource;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.FileUtil;
import net.pms.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Format
implements Cloneable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Format.class);
    private String icon = null;
    protected int type = 8;
    protected Format secondaryFormat;
    private String matchedExtension;
    public static final int UNSET = 0;
    public static final int AUDIO = 1;
    public static final int IMAGE = 2;
    public static final int VIDEO = 4;
    public static final int UNKNOWN = 8;
    public static final int PLAYLIST = 16;
    public static final int ISO = 32;
    public static final int SUBTITLE = 64;

    public int getType() {
        return this.type;
    }

    public String getMatchedExtension() {
        return this.matchedExtension;
    }

    public void setMatchedExtension(String extension) {
        this.matchedExtension = extension;
    }

    public Format getSecondaryFormat() {
        return this.secondaryFormat;
    }

    public void setSecondaryFormat(Format secondaryFormat) {
        this.secondaryFormat = secondaryFormat;
    }

    public void setType(int type) {
        if (this.isUnknown()) {
            this.type = type;
        }
    }

    public String[] getSupportedExtensions() {
        return null;
    }

    public boolean isCompatible(StoreItem resource, Renderer renderer) {
        Renderer referenceRenderer = renderer != null ? renderer : RendererConfigurations.getDefaultRenderer();
        return referenceRenderer.isCompatible(resource, this);
    }

    public abstract boolean transcodable();

    public String mimeType() {
        return HTTPResource.getDefaultMimeType(this.type);
    }

    public String getIcon() {
        return this.icon;
    }

    public boolean match(String filename) {
        if (filename == null) {
            return false;
        }
        filename = filename.toLowerCase(Locale.ROOT);
        String[] supportedExtensions = this.getSupportedExtensions();
        if (supportedExtensions != null) {
            String protocol = FileUtil.getProtocol(filename);
            if (protocol != null) {
                return false;
            }
            for (String extension : supportedExtensions) {
                String ext = extension.toLowerCase(Locale.ROOT);
                if (!filename.endsWith("." + ext)) continue;
                this.setMatchedExtension(ext);
                return true;
            }
        }
        return false;
    }

    public boolean isVideo() {
        return (this.type & 4) == 4;
    }

    public boolean isAudio() {
        return (this.type & 1) == 1;
    }

    public boolean isImage() {
        return (this.type & 2) == 2;
    }

    public boolean isUnknown() {
        return (this.type & 8) == 8;
    }

    public boolean isSubtitle() {
        return (this.type & 0x40) == 64;
    }

    protected Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.error(null, e);
        }
        return o;
    }

    public Format duplicate() {
        return (Format)this.clone();
    }

    public boolean skip(String ... extensions) {
        for (String extensionsString : extensions) {
            String[] extensionsArray;
            if (extensionsString == null) continue;
            if ("*".equals(extensionsString)) {
                return true;
            }
            for (String extension : extensionsArray = extensionsString.split(",\\s*")) {
                if (!StringUtil.hasValue(extension) || !extension.equalsIgnoreCase(this.matchedExtension)) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public abstract Identifier getIdentifier();

    public static String getStringType(int type) {
        return switch (type) {
            case 1 -> "AUDIO";
            case 2 -> "IMAGE";
            case 4 -> "VIDEO";
            case 8 -> "UNKNOWN";
            case 16 -> "PLAYLIST";
            case 32 -> "ISO";
            case 64 -> "SUBTITLE";
            default -> "NOT DEFINED";
        };
    }

    public static enum Identifier {
        AACP,
        AC3,
        ADPCM,
        ADTS,
        AIFF,
        APE,
        ATRAC,
        AU,
        AUDIO_AS_VIDEO,
        ASS,
        BMP,
        DFF,
        DSF,
        DTS,
        DVRMS,
        EAC3,
        FLAC,
        GIF,
        RGBE,
        ICNS,
        ICO,
        IFF,
        IDX,
        ISO,
        ISOVOB,
        JPG,
        M4A,
        MICRODVD,
        MKA,
        MKV,
        MLP,
        MP3,
        MPA,
        MPC,
        MPG,
        OGA,
        OGG,
        PCX,
        PICT,
        PNG,
        PNM,
        PSD,
        RA,
        RAW,
        SAMI,
        SGI,
        SHN,
        SUBRIP,
        SUP,
        TGA,
        THD,
        THREEGA,
        THREEG2A,
        TIFF,
        TTA,
        TXT,
        WAV,
        WBMP,
        WEB,
        WEBP,
        WEBVTT,
        WMA,
        WV,
        CUSTOM,
        PLAYLIST;

    }
}

