/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import net.pms.external.ProgressCallback;

public class FileBodySubscriber
implements Flow.Subscriber<List<ByteBuffer>> {
    private final File file;
    private final long fileSize;
    private final String uri;
    private final ProgressCallback progressCallback;
    private FileChannel fileChannel;
    private long writtenBytes = 0L;
    private Flow.Subscription subscription;
    private final AtomicBoolean subscribed = new AtomicBoolean();
    private final CompletableFuture<File> result = new CompletableFuture();

    public FileBodySubscriber(File file, long fileSize, String uri, ProgressCallback progressCallback) {
        this.file = file;
        this.fileSize = fileSize;
        this.uri = uri;
        this.progressCallback = progressCallback;
    }

    private void releaseResources() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void onSubscribe(Flow.Subscription subscription) {
        Objects.requireNonNull(subscription);
        if (!this.subscribed.compareAndSet(false, true)) {
            subscription.cancel();
            return;
        }
        try {
            this.fileChannel = FileChannel.open(this.file.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException ex) {
            this.result.completeExceptionally(ex);
            subscription.cancel();
            return;
        }
        this.subscription = subscription;
        subscription.request(1L);
    }

    @Override
    public void onNext(List<ByteBuffer> items) {
        Objects.requireNonNull(items);
        try {
            this.writtenBytes += this.fileChannel.write((ByteBuffer[])items.toArray(ByteBuffer[]::new));
        }
        catch (IOException ex) {
            this.releaseResources();
            this.subscription.cancel();
            this.result.completeExceptionally(ex);
        }
        if (this.progressCallback != null) {
            this.progressCallback.progress(this.uri, this.writtenBytes, this.fileSize);
            if (this.progressCallback.isCancelled()) {
                this.subscription.cancel();
            }
        }
        this.subscription.request(1L);
    }

    @Override
    public void onError(Throwable throwable) {
        this.releaseResources();
        this.result.completeExceptionally(throwable);
    }

    @Override
    public void onComplete() {
        this.releaseResources();
        this.result.complete(this.file);
    }
}

