/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.io.Serializable;
import net.pms.dlna.protocolinfo.AribOrJpProfileName;
import net.pms.dlna.protocolinfo.DLNAOrgConversionIndicator;
import net.pms.dlna.protocolinfo.DLNAOrgFlags;
import net.pms.dlna.protocolinfo.DLNAOrgOperations;
import net.pms.dlna.protocolinfo.DLNAOrgPlaySpeeds;
import net.pms.dlna.protocolinfo.DLNAOrgProfileName;
import net.pms.dlna.protocolinfo.PanasonicComProfileName;
import net.pms.dlna.protocolinfo.ProfileName;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jupnp.support.model.Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProtocolInfoAttribute
extends Serializable {
    public static final ProtocolInfoAttributeFactory FACTORY = new ProtocolInfoAttributeFactory();

    public ProtocolInfoAttributeName getName();

    public String getNameString();

    public String getValue();

    public String getAttributeString();

    public static class ProtocolInfoAttributeFactory {
        private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolInfoAttributeFactory.class);

        protected ProtocolInfoAttributeFactory() {
        }

        public ProtocolInfoAttribute getAttribute(String attributeName, String attributeValue) throws ParseException {
            return this.getAttribute(ProtocolInfoAttributeName.FACTORY.createAttributeName(attributeName), attributeValue);
        }

        public ProtocolInfoAttribute getAttribute(ProtocolInfoAttributeName attributeName, String attributeValue) throws ParseException {
            if (DLNAOrgOperations.NAME.equals(attributeName)) {
                throw new IllegalArgumentException("Cannot get DLNA.ORG_FLAGS instance because protocol information is needed - use an overloaded version of this method which takes a protocol argument");
            }
            return this.getAttribute(attributeName, attributeValue, null);
        }

        public ProtocolInfoAttribute getAttribute(String attributeName, String attributeValue, Protocol protocol) throws ParseException {
            return this.getAttribute(ProtocolInfoAttributeName.FACTORY.createAttributeName(attributeName), attributeValue, protocol);
        }

        public ProtocolInfoAttribute getAttribute(ProtocolInfoAttributeName attributeName, String attributeValue, Protocol protocol) throws ParseException {
            if (attributeName == null) {
                return null;
            }
            if (DLNAOrgConversionIndicator.NAME.equals(attributeName)) {
                return DLNAOrgConversionIndicator.FACTORY.getConversionIndicator(attributeValue);
            }
            if (DLNAOrgOperations.NAME.equals(attributeName)) {
                return DLNAOrgOperations.FACTORY.getOperations(protocol, attributeValue);
            }
            if (DLNAOrgPlaySpeeds.NAME.equals(attributeName)) {
                return DLNAOrgPlaySpeeds.FACTORY.getPlaySpeeds(attributeValue);
            }
            if (DLNAOrgProfileName.NAME.equals(attributeName)) {
                return DLNAOrgProfileName.FACTORY.getProfileName(attributeValue);
            }
            if (PanasonicComProfileName.NAME.equals(attributeName)) {
                return PanasonicComProfileName.FACTORY.getProfileName(attributeValue);
            }
            if (AribOrJpProfileName.NAME.equals(attributeName)) {
                return AribOrJpProfileName.FACTORY.getProfileName(attributeValue);
            }
            if (attributeName.getName().contains("_PN")) {
                return ProfileName.DefaultGenericProfileName.FACTORY.getProfileName(attributeName, attributeValue);
            }
            return null;
        }

        public ProtocolInfoAttribute createAttribute(String attributeName, String attributeValue) throws ParseException {
            return this.createAttribute(ProtocolInfoAttributeName.FACTORY.createAttributeName(attributeName), attributeValue);
        }

        public ProtocolInfoAttribute createAttribute(ProtocolInfoAttributeName attributeName, String attributeValue) throws ParseException {
            if (DLNAOrgOperations.NAME.equals(attributeName)) {
                throw new IllegalArgumentException("Cannot create DLNA.ORG_FLAGS instance because protocol information is needed - use an overloaded version of this method which takes a protocol argument");
            }
            return this.createAttribute(attributeName, attributeValue, null);
        }

        public ProtocolInfoAttribute createAttribute(String attributeName, String attributeValue, Protocol protocol) throws ParseException {
            return this.createAttribute(ProtocolInfoAttributeName.FACTORY.createAttributeName(attributeName), attributeValue, protocol);
        }

        public ProtocolInfoAttribute createAttribute(ProtocolInfoAttributeName attributeName, String attributeValue, Protocol protocol) throws ParseException {
            if (attributeName == null) {
                return null;
            }
            ProtocolInfoAttribute instance = this.getAttribute(attributeName, attributeValue, protocol);
            if (instance != null) {
                return instance;
            }
            if (DLNAOrgPlaySpeeds.NAME.equals(attributeName)) {
                return DLNAOrgPlaySpeeds.FACTORY.createPlaySpeeds(attributeValue);
            }
            if (DLNAOrgFlags.NAME.equals(attributeName)) {
                DLNAOrgFlags flags = new DLNAOrgFlags(attributeValue);
                if (DLNAOrgFlags.IMPLIED.equals(flags)) {
                    return DLNAOrgFlags.IMPLIED;
                }
                return flags;
            }
            if (attributeName == DLNAOrgProfileName.NAME) {
                return DLNAOrgProfileName.FACTORY.createProfileName(attributeValue);
            }
            if (PanasonicComProfileName.NAME.equals(attributeName)) {
                return PanasonicComProfileName.FACTORY.createProfileName(attributeValue);
            }
            if (AribOrJpProfileName.NAME.equals(attributeName)) {
                return AribOrJpProfileName.FACTORY.createProfileName(attributeValue);
            }
            if (attributeName.getName().contains("_PN")) {
                return ProfileName.DefaultGenericProfileName.FACTORY.createProfileName(attributeName, attributeValue);
            }
            LOGGER.trace("Creating unknown ProtocolInfoAttribute \"{}\" with value \"{}\"", (Object)attributeName, (Object)attributeValue);
            return new StringAttribute(attributeName, attributeValue);
        }
    }

    public static class StringAttribute
    implements ProtocolInfoAttribute {
        private static final long serialVersionUID = 1L;
        protected final ProtocolInfoAttributeName name;
        protected final String value;

        public StringAttribute(ProtocolInfoAttributeName name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public ProtocolInfoAttributeName getName() {
            return this.name;
        }

        @Override
        public String getNameString() {
            return this.name == null ? null : this.name.getName();
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.name) + " = " + this.value;
        }

        @Override
        public String getAttributeString() {
            return this.name == null || StringUtils.isBlank(this.name.getName()) || StringUtils.isBlank(this.value) ? "" : this.name.getName() + "=" + this.value;
        }
    }
}

