/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MimeType
implements Comparable<MimeType>,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MimeType.class);
    private static final long serialVersionUID = 1L;
    public static final String ANY = "*";
    public static final MimeType ANYANY = new MimeType();
    protected final String type;
    protected final String subtype;
    protected final Map<String, String> parameters;
    protected final String stringValue;

    protected MimeType() {
        this(ANY, ANY);
    }

    public MimeType(String type, String subtype) {
        this(type, subtype, null);
    }

    public MimeType(String type, String subtype, Map<String, String> parameters) {
        this.type = type == null ? ANY : type;
        String string = this.subtype = subtype == null ? ANY : subtype;
        if (parameters == null) {
            this.parameters = Collections.emptyMap();
        } else {
            TreeMap<String, String> map = new TreeMap<String, String>((o1, o2) -> o1.compareToIgnoreCase((String)o2));
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                map.put(entry.getKey(), entry.getValue());
            }
            this.parameters = Collections.unmodifiableSortedMap(map);
        }
        this.stringValue = this.generateStringValue();
    }

    public String getType() {
        return this.type;
    }

    public boolean isAnyType() {
        return StringUtils.isBlank(this.type) || ANY.equals(this.type);
    }

    public String getSubtype() {
        return this.subtype;
    }

    public boolean isAnySubtype() {
        return ANY.equals(this.subtype);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public boolean isCompatible(MimeType other) {
        if (other == null) {
            return false;
        }
        if ((StringUtils.isBlank(this.type) || ANY.equals(this.type)) && StringUtils.isBlank(this.subtype) || (StringUtils.isBlank(other.type) || ANY.equals(other.type)) && StringUtils.isBlank(other.subtype)) {
            return true;
        }
        if (StringUtils.isBlank(this.type) || StringUtils.isBlank(other.type)) {
            return StringUtils.isBlank(this.subtype) || StringUtils.isBlank(other.subtype) || ANY.equals(this.subtype) || ANY.equals(other.subtype) || this.subtype.toLowerCase(Locale.ROOT).equals(other.subtype.toLowerCase(Locale.ROOT));
        }
        if (this.type.toLowerCase(Locale.ROOT).equals(other.type.toLowerCase(Locale.ROOT)) && (StringUtils.isBlank(this.subtype) || ANY.equals(this.subtype) || StringUtils.isBlank(other.subtype) || ANY.equals(other.subtype))) {
            return true;
        }
        if (StringUtils.isBlank(this.subtype) || StringUtils.isBlank(other.subtype)) {
            return false;
        }
        return this.type.toLowerCase(Locale.ROOT).equals(other.type.toLowerCase(Locale.ROOT)) && this.subtype.toLowerCase(Locale.ROOT).equals(other.subtype.toLowerCase(Locale.ROOT));
    }

    public static MimeType valueOf(String stringValue) throws ParseException {
        if (StringUtils.isBlank(stringValue)) {
            return ANYANY;
        }
        String[] parts = stringValue.trim().split("\\s*;\\s*");
        String[] elements = parts[0].split("\\s*/\\s*");
        String type = null;
        String subtype = null;
        if (elements.length < 2) {
            if (parts[0].equals(ANY) || StringUtils.isBlank(parts[0])) {
                type = ANY;
                subtype = ANY;
            } else {
                type = elements[0];
                subtype = ANY;
            }
        } else if (elements.length == 2) {
            type = elements[0];
            subtype = elements[1];
        } else if (elements.length > 2) {
            throw new ParseException("Error parsing mimetype \"" + parts[0] + "\" from \"" + stringValue + "\"");
        }
        if (parts.length > 1) {
            HashMap<String, String> parameterMap = new HashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                if (StringUtils.isBlank(parts[i])) continue;
                String[] parameter = parts[i].trim().split("\\s*=\\s*");
                if (parameter.length == 2 && StringUtils.isNotBlank(parameter[0])) {
                    parameterMap.put(parameter[0], parameter[1]);
                    continue;
                }
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("MimeType: Unable to parse parameter \"{}\" - it will be ignored", (Object)parts[i]);
            }
            return new MimeType(type, subtype, parameterMap);
        }
        return new MimeType(type, subtype);
    }

    public boolean isDRM() {
        return this.isDTCP();
    }

    public boolean isDTCP() {
        return "application".equalsIgnoreCase(this.type) && "x-dtcp1".equalsIgnoreCase(this.subtype);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MimeType)) {
            return false;
        }
        MimeType other = (MimeType)obj;
        if (this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters)) {
            return false;
        }
        if (this.subtype == null) {
            if (other.subtype != null) {
                return false;
            }
        } else {
            if (other.subtype == null) {
                return false;
            }
            if (!this.subtype.toLowerCase(Locale.ROOT).equals(other.subtype.toLowerCase(Locale.ROOT))) {
                return false;
            }
        }
        if (this.type == null) {
            if (other.type != null) {
                return false;
            }
        } else {
            if (other.type == null) {
                return false;
            }
            if (!this.type.toLowerCase(Locale.ROOT).equals(other.type.toLowerCase(Locale.ROOT))) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        result = 31 * result + (this.subtype == null ? 0 : this.subtype.toLowerCase(Locale.ROOT).hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.toLowerCase(Locale.ROOT).hashCode());
        return result;
    }

    public String toString() {
        return this.stringValue;
    }

    protected final String generateStringValue() {
        StringBuilder sb = new StringBuilder(this.toStringWithoutParameters());
        if (this.parameters != null && !this.parameters.isEmpty()) {
            for (Map.Entry<String, String> parameter : this.parameters.entrySet()) {
                sb.append(";").append(parameter.getKey()).append("=").append(parameter.getValue());
            }
        }
        return sb.toString();
    }

    public org.jupnp.util.MimeType toSeamlessMimeType() {
        return new org.jupnp.util.MimeType(this.type, this.subtype, this.parameters);
    }

    public String toStringWithoutParameters() {
        return this.type + "/" + this.subtype;
    }

    @Override
    public int compareTo(MimeType other) {
        if (other == null) {
            return -1;
        }
        if (this.stringValue == null && other.stringValue != null) {
            return 1;
        }
        if (this.stringValue != null && other.stringValue == null) {
            return -1;
        }
        if (this.stringValue != null && other.stringValue != null) {
            return this.stringValue.compareTo(other.stringValue);
        }
        return 0;
    }
}

