/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.protocolinfo.DeviceProtocolInfoSource;
import net.pms.dlna.protocolinfo.ProtocolInfo;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.LookupTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceProtocolInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(DeviceProtocolInfo.class);
    public static final DeviceProtocolInfoSource<DeviceProtocolInfo> GET_PROTOCOLINFO_SOURCE = new GetProtocolInfoType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getType() {
            return "GetProtocolInfo Source";
        }
    };
    public static final DeviceProtocolInfoSource<DeviceProtocolInfo> GET_PROTOCOLINFO_SINK = new GetProtocolInfoType(){
        private static final long serialVersionUID = 1L;

        @Override
        public String getType() {
            return "GetProtocolInfo Sink";
        }
    };
    public static final String COMMA_SPLIT_REGEX = "\\s*(?:(?<!\\\\),|(?<!\\\\)\\\\\\\\,)\\s*";
    public static final CharSequenceTranslator PROTOCOLINFO_UNESCAPE = new LookupTranslator(Map.of("\\\\", "\\", "\\,", ","));
    public static final CharSequenceTranslator PROTOCOLINFO_ESCAPE = new LookupTranslator(Map.of(",", "\\,", "\\", "\\\\"));
    protected final ReentrantReadWriteLock setsLock = new ReentrantReadWriteLock();
    protected final HashMap<DeviceProtocolInfoSource<?>, SortedSet<ProtocolInfo>> protocolInfoSets = new HashMap();
    protected final SortedSet<DLNAImageProfile> imageProfileSet = new TreeSet<DLNAImageProfile>();

    public DeviceProtocolInfo() {
    }

    public DeviceProtocolInfo(GetProtocolInfoType type, String protocolInfoString) {
        this.add(type, protocolInfoString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(DeviceProtocolInfoSource<?> type, String protocolInfoString) {
        if (StringUtils.isBlank(protocolInfoString)) {
            return false;
        }
        String[] elements = protocolInfoString.trim().split(COMMA_SPLIT_REGEX);
        boolean result = false;
        this.setsLock.writeLock().lock();
        try {
            SortedSet<Object> currentSet;
            if (this.protocolInfoSets.containsKey(type)) {
                currentSet = this.protocolInfoSets.get(type);
            } else {
                currentSet = new TreeSet();
                this.protocolInfoSets.put(type, currentSet);
            }
            for (String element : elements) {
                try {
                    SortedSet<ProtocolInfo> tempSet = DeviceProtocolInfo.handleSpecialCaseString(element);
                    if (tempSet == null) {
                        result |= currentSet.add(new ProtocolInfo(DeviceProtocolInfo.unescapeString(element)));
                        continue;
                    }
                    result |= currentSet.addAll(tempSet);
                }
                catch (ParseException e) {
                    LOGGER.warn("Unable to parse protocolInfo from \"{}\", this profile will not be registered: {}", (Object)element, (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
            }
            this.updateImageProfiles();
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImageProfiles() {
        this.setsLock.writeLock().lock();
        try {
            this.imageProfileSet.clear();
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                for (ProtocolInfo protocolInfo : set) {
                    this.imageProfileSet.addAll(DLNAImageProfile.toDLNAImageProfiles(protocolInfo));
                }
            }
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size(DeviceProtocolInfoSource<?> type) {
        this.setsLock.readLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            int n = set == null ? 0 : set.size();
            return n;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        long result = 0L;
        this.setsLock.readLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                if (set == null) continue;
                result += (long)set.size();
            }
        }
        finally {
            this.setsLock.readLock().unlock();
        }
        return result > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(DeviceProtocolInfoSource<?> type) {
        this.setsLock.readLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            boolean bl = set == null || set.isEmpty();
            return bl;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.setsLock.readLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                if (set == null || set.isEmpty()) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.setsLock.readLock().unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(DeviceProtocolInfoSource<?> type, ProtocolInfo protocolInfo) {
        this.setsLock.readLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            boolean bl = set != null && set.contains(protocolInfo);
            return bl;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(ProtocolInfo protocolInfo) {
        this.setsLock.readLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                if (set == null || !set.contains(protocolInfo)) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.setsLock.readLock().unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolInfo[] toArray(DeviceProtocolInfoSource<?> type) {
        this.setsLock.readLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            ProtocolInfo[] protocolInfoArray = set == null ? null : set.toArray(new ProtocolInfo[this.protocolInfoSets.size()]);
            return protocolInfoArray;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProtocolInfo[] toArray() {
        TreeSet<ProtocolInfo> result = new TreeSet<ProtocolInfo>();
        this.setsLock.readLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                if (set == null) continue;
                result.addAll(set);
            }
        }
        finally {
            this.setsLock.readLock().unlock();
        }
        return (ProtocolInfo[])result.toArray(ProtocolInfo[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(DeviceProtocolInfoSource<?> type, Collection<ProtocolInfo> collection) {
        this.setsLock.readLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            boolean bl = set != null && set.containsAll(collection);
            return bl;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<ProtocolInfo> collection) {
        this.setsLock.readLock().lock();
        try {
            for (ProtocolInfo protocolInfo : collection) {
                if (this.contains(protocolInfo)) continue;
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.setsLock.readLock().unlock();
        }
        return true;
    }

    public void clear(DeviceProtocolInfoSource<?> type) {
        this.setsLock.writeLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            if (set != null) {
                set.clear();
                this.updateImageProfiles();
            }
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    public void clear() {
        this.setsLock.writeLock().lock();
        try {
            this.protocolInfoSets.clear();
            this.imageProfileSet.clear();
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(DeviceProtocolInfoSource<?> type, ProtocolInfo protocolInfo) {
        this.setsLock.writeLock().lock();
        try {
            SortedSet<Object> currentSet;
            if (this.protocolInfoSets.containsKey(type)) {
                currentSet = this.protocolInfoSets.get(type);
            } else {
                currentSet = new TreeSet();
                this.protocolInfoSets.put(type, currentSet);
            }
            if (currentSet.add(protocolInfo)) {
                this.updateImageProfiles();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(DeviceProtocolInfoSource<?> type, Collection<? extends ProtocolInfo> collection) {
        this.setsLock.writeLock().lock();
        try {
            SortedSet<Object> currentSet;
            if (this.protocolInfoSets.containsKey(type)) {
                currentSet = this.protocolInfoSets.get(type);
            } else {
                currentSet = new TreeSet();
                this.protocolInfoSets.put(type, currentSet);
            }
            if (currentSet.addAll(collection)) {
                this.updateImageProfiles();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(DeviceProtocolInfoSource<?> type, ProtocolInfo protocolInfo) {
        this.setsLock.writeLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            if (set != null && set.remove(protocolInfo)) {
                this.updateImageProfiles();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(ProtocolInfo protocolInfo) {
        boolean result = false;
        this.setsLock.writeLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                result |= set != null && set.remove(protocolInfo);
            }
            if (result) {
                this.updateImageProfiles();
            }
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(DeviceProtocolInfoSource<?> type, Collection<ProtocolInfo> collection) {
        this.setsLock.writeLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            if (set != null && set.removeAll(collection)) {
                this.updateImageProfiles();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection<ProtocolInfo> collection) {
        boolean result = false;
        this.setsLock.writeLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                result |= set != null && set.removeAll(collection);
            }
            if (result) {
                this.updateImageProfiles();
            }
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(DeviceProtocolInfoSource<?> type, Collection<ProtocolInfo> collection) {
        this.setsLock.writeLock().lock();
        try {
            SortedSet<ProtocolInfo> set = this.protocolInfoSets.get(type);
            if (set != null && set.retainAll(collection)) {
                this.updateImageProfiles();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection<ProtocolInfo> collection) {
        boolean result = false;
        this.setsLock.writeLock().lock();
        try {
            for (SortedSet<ProtocolInfo> set : this.protocolInfoSets.values()) {
                result |= set != null && set.retainAll(collection);
            }
            if (result) {
                this.updateImageProfiles();
            }
        }
        finally {
            this.setsLock.writeLock().unlock();
        }
        return result;
    }

    public int imageProfilesSize() {
        this.setsLock.readLock().lock();
        try {
            int n = this.imageProfileSet.size();
            return n;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    public boolean isImageProfilesEmpty() {
        this.setsLock.readLock().lock();
        try {
            boolean bl = this.imageProfileSet.isEmpty();
            return bl;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    public boolean imageProfilesContains(DLNAImageProfile imageProfile) {
        this.setsLock.readLock().lock();
        try {
            boolean bl = this.imageProfileSet.contains(imageProfile);
            return bl;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    public DLNAImageProfile[] imageProfilesToArray() {
        this.setsLock.readLock().lock();
        try {
            DLNAImageProfile[] dLNAImageProfileArray = (DLNAImageProfile[])this.imageProfileSet.toArray(DLNAImageProfile[]::new);
            return dLNAImageProfileArray;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    public boolean imageProfilesContainsAll(Collection<DLNAImageProfile> collection) {
        this.setsLock.readLock().lock();
        try {
            boolean bl = this.imageProfileSet.containsAll(collection);
            return bl;
        }
        finally {
            this.setsLock.readLock().unlock();
        }
    }

    public String toString() {
        return this.toString(null, false);
    }

    public String toString(DeviceProtocolInfoSource<?> type) {
        return this.toString(type, false);
    }

    public String toString(boolean debug) {
        return this.toString(null, debug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString(DeviceProtocolInfoSource<?> type, boolean debug) {
        StringBuilder sb = new StringBuilder();
        this.setsLock.readLock().lock();
        try {
            if (this.protocolInfoSets != null && !this.protocolInfoSets.isEmpty()) {
                for (Map.Entry<DeviceProtocolInfoSource<?>, SortedSet<ProtocolInfo>> entry : this.protocolInfoSets.entrySet()) {
                    if (type != null && !type.equals(entry.getKey()) || entry.getValue().isEmpty()) continue;
                    sb.append(entry.getKey().getType()).append(" entries:\n");
                    for (ProtocolInfo protocolInfo : entry.getValue()) {
                        if (protocolInfo == null) continue;
                        sb.append("  ").append(debug ? protocolInfo.toDebugString() : protocolInfo.toString()).append("\n");
                    }
                    sb.append("\n");
                }
            }
            if (this.imageProfileSet != null && !this.imageProfileSet.isEmpty()) {
                sb.append("DLNAImageProfile entries:\n");
                for (DLNAImageProfile imageProfile : this.imageProfileSet) {
                    if (imageProfile == null) continue;
                    sb.append("  ").append(imageProfile).append("\n");
                }
            }
        }
        finally {
            this.setsLock.readLock().unlock();
        }
        return sb.toString();
    }

    public static String escapeString(String unescapedString) {
        return PROTOCOLINFO_ESCAPE.translate(unescapedString);
    }

    public static String unescapeString(String escapedString) {
        return PROTOCOLINFO_UNESCAPE.translate(escapedString);
    }

    public static SortedSet<ProtocolInfo> handleSpecialCaseString(String element) throws ParseException {
        if (StringUtils.isBlank(element)) {
            return null;
        }
        if (element.equals("http-get:*:audio/sonyoma:*http-get:*:audio/ogg:*")) {
            TreeSet<ProtocolInfo> currentSet = new TreeSet<ProtocolInfo>();
            currentSet.add(new ProtocolInfo("http-get:*:audio/sonyoma:*"));
            currentSet.add(new ProtocolInfo("http-get:*:audio/ogg:*"));
            return currentSet;
        }
        return null;
    }

    public static abstract class GetProtocolInfoType
    extends DeviceProtocolInfoSource<DeviceProtocolInfo> {
        private static final long serialVersionUID = 1L;

        @Override
        public Class<DeviceProtocolInfo> getClazz() {
            return DeviceProtocolInfo.class;
        }
    }
}

